/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.structure.match;

import hellfirepvp.astralsorcery.common.structure.MatchableStructure;
import hellfirepvp.astralsorcery.common.structure.ObservableArea;
import hellfirepvp.astralsorcery.common.structure.ObservableAreaBoundingBox;
import hellfirepvp.astralsorcery.common.structure.StructureMatcher;
import hellfirepvp.astralsorcery.common.structure.StructureRegistry;
import hellfirepvp.astralsorcery.common.structure.array.PatternBlockArray;
import hellfirepvp.astralsorcery.common.structure.change.BlockStateChangeSet;
import hellfirepvp.astralsorcery.common.util.log.LogCategory;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;

public class StructureMatcherPatternArray
extends StructureMatcher {
    private PatternBlockArray structure;
    private ObservableArea structureArea;
    private Set<BlockPos> mismatches = new HashSet<BlockPos>();

    public StructureMatcherPatternArray(@Nonnull ResourceLocation registryName) {
        super(registryName);
        this.setStructure(registryName);
    }

    private void setStructure(ResourceLocation structName) {
        MatchableStructure struct = StructureRegistry.INSTANCE.getStructure(structName);
        if (!(struct instanceof PatternBlockArray)) {
            throw new IllegalArgumentException("Passed structure matcher key does not have a registered underlying structure pattern: " + structName);
        }
        this.structure = (PatternBlockArray)struct;
        this.structureArea = new ObservableAreaBoundingBox(this.structure.getMin(), this.structure.getMax());
    }

    public void initialize(IBlockAccess world, BlockPos center) {
        for (BlockPos offset : this.structure.getPattern().keySet()) {
            if (this.structure.matchSingleBlock(world, center, offset)) continue;
            this.mismatches.add(offset);
        }
        LogCategory.STRUCTURE_MATCH.info(() -> "Structure matcher initialized at " + center + " with " + this.mismatches.size() + " initial mismatches!");
    }

    @Override
    public ObservableArea getObservableArea() {
        return this.structureArea;
    }

    @Override
    public boolean notifyChange(IBlockAccess world, BlockPos centre, BlockStateChangeSet changeSet) {
        int mismatchesPre = this.mismatches.size();
        for (BlockStateChangeSet.StateChange change : changeSet.getChanges()) {
            if (this.structure.hasBlockAt(change.pos) && !this.structure.matchSingleBlockState(change.pos, change.newState)) {
                this.mismatches.add(change.pos);
                continue;
            }
            this.mismatches.remove(change.pos);
        }
        this.mismatches.removeIf(mismatchPos -> !this.structure.hasBlockAt((BlockPos)mismatchPos));
        int mismatchesPost = this.mismatches.size();
        LogCategory.STRUCTURE_MATCH.info(() -> "Updated structure integrity with " + mismatchesPre + " mismatches before and " + mismatchesPost + " mismatches afterwards.");
        if (mismatchesPost > 0) {
            LogCategory.STRUCTURE_MATCH.info(() -> "Found mismatches at (relative to center): " + this.mismatches.stream().map(Vec3i::toString).collect(Collectors.joining(", ")));
        }
        return mismatchesPost <= 0;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.mismatches.clear();
        NBTTagList tagMismatches = tag.func_150295_c("mismatchList", 10);
        for (int i = 0; i < tagMismatches.func_74745_c(); ++i) {
            NBTTagCompound tagPos = tagMismatches.func_150305_b(i);
            this.mismatches.add(NBTHelper.readBlockPosFromNBT(tagPos));
        }
        this.setStructure(new ResourceLocation(tag.func_74779_i("structureToMatch")));
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList tagMismatches = new NBTTagList();
        for (BlockPos pos : this.mismatches) {
            NBTTagCompound tagPos = new NBTTagCompound();
            NBTHelper.writeBlockPosToNBT(pos, tagPos);
            tagMismatches.func_74742_a((NBTBase)tagPos);
        }
        tag.func_74782_a("mismatchList", (NBTBase)tagMismatches);
        tag.func_74778_a("structureToMatch", this.structure.getRegistryName().toString());
    }
}

