/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.wand;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.event.ClientRenderEventHandler;
import hellfirepvp.astralsorcery.client.util.AirBlockRenderWorld;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.common.base.Mods;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.integrations.ModIntegrationBotania;
import hellfirepvp.astralsorcery.common.item.ItemBlockStorage;
import hellfirepvp.astralsorcery.common.item.base.render.ItemAlignmentChargeConsumer;
import hellfirepvp.astralsorcery.common.item.base.render.ItemAlignmentChargeRevealer;
import hellfirepvp.astralsorcery.common.item.base.render.ItemHandRender;
import hellfirepvp.astralsorcery.common.item.base.render.ItemHudRender;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.structure.array.BlockArray;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import hellfirepvp.astralsorcery.common.util.struct.BlockDiscoverer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.lwjgl.opengl.GL11;

public class ItemExchangeWand
extends ItemBlockStorage
implements ItemHandRender,
ItemHudRender,
ItemAlignmentChargeConsumer {
    private static final int searchDepth = 5;

    public ItemExchangeWand() {
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77637_a(RegistryItems.creativeTabAstralSorcery);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldReveal(ItemAlignmentChargeRevealer.ChargeType ct, ItemStack stack) {
        return ct == ItemAlignmentChargeRevealer.ChargeType.TEMP;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return 0.0f;
    }

    public boolean func_150897_b(IBlockState blockIn) {
        return true;
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderInHandHUD(ItemStack lastCacheInstance, float fadeAlpha, float pTicks) {
        Collection<ItemStack> stored = ItemExchangeWand.getMappedStoredStates(lastCacheInstance).values();
        if (stored.isEmpty()) {
            return;
        }
        LinkedHashMap<ItemStack, Integer> amountMap = new LinkedHashMap<ItemStack, Integer>();
        for (ItemStack stack : stored) {
            int found = 0;
            if (Mods.BOTANIA.isPresent()) {
                found = ModIntegrationBotania.getItemCount((EntityPlayer)Minecraft.func_71410_x().field_71439_g, lastCacheInstance, ItemUtils.createBlockState(stack));
            } else {
                Collection<ItemStack> stacks = ItemUtils.scanInventoryForMatching((IItemHandler)new InvWrapper((IInventory)Minecraft.func_71410_x().field_71439_g.field_71071_by), stack, false);
                for (ItemStack foundStack : stacks) {
                    found += foundStack.func_190916_E();
                }
            }
            amountMap.put(stack, found);
        }
        int heightNormal = 26;
        int heightSplit = 13;
        int width = 26;
        int offsetX = 30;
        int offsetY = 15;
        GlStateManager.func_179094_E();
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        Blending.DEFAULT.applyStateManager();
        Blending.DEFAULT.apply();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(fadeAlpha * 0.9f));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(fadeAlpha * 0.9f));
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        int tempOffsetY = offsetY;
        for (int i = 0; i < amountMap.size(); ++i) {
            boolean last;
            boolean first = i == 0;
            boolean bl = last = i + 1 == amountMap.size();
            if (first) {
                vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                ClientRenderEventHandler.texHUDItemFrame.bind();
                vb.func_181662_b((double)offsetX, (double)(tempOffsetY + heightSplit), 10.0).func_187315_a(0.0, 0.5).func_181675_d();
                vb.func_181662_b((double)(offsetX + width), (double)(tempOffsetY + heightSplit), 10.0).func_187315_a(1.0, 0.5).func_181675_d();
                vb.func_181662_b((double)(offsetX + width), (double)tempOffsetY, 10.0).func_187315_a(1.0, 0.0).func_181675_d();
                vb.func_181662_b((double)offsetX, (double)tempOffsetY, 10.0).func_187315_a(0.0, 0.0).func_181675_d();
                tempOffsetY += heightSplit;
                tes.func_78381_a();
            } else {
                vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                ClientRenderEventHandler.texHUDItemFrameEx.bind();
                vb.func_181662_b((double)offsetX, (double)(tempOffsetY + heightNormal), 10.0).func_187315_a(0.0, 1.0).func_181675_d();
                vb.func_181662_b((double)(offsetX + width), (double)(tempOffsetY + heightNormal), 10.0).func_187315_a(1.0, 1.0).func_181675_d();
                vb.func_181662_b((double)(offsetX + width), (double)tempOffsetY, 10.0).func_187315_a(1.0, 0.0).func_181675_d();
                vb.func_181662_b((double)offsetX, (double)tempOffsetY, 10.0).func_187315_a(0.0, 0.0).func_181675_d();
                tempOffsetY += heightNormal;
                tes.func_78381_a();
            }
            if (!last) continue;
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            ClientRenderEventHandler.texHUDItemFrame.bind();
            vb.func_181662_b((double)offsetX, (double)(tempOffsetY + heightSplit), 10.0).func_187315_a(0.0, 1.0).func_181675_d();
            vb.func_181662_b((double)(offsetX + width), (double)(tempOffsetY + heightSplit), 10.0).func_187315_a(1.0, 1.0).func_181675_d();
            vb.func_181662_b((double)(offsetX + width), (double)tempOffsetY, 10.0).func_187315_a(1.0, 0.5).func_181675_d();
            vb.func_181662_b((double)offsetX, (double)tempOffsetY, 10.0).func_187315_a(0.0, 0.5).func_181675_d();
            tempOffsetY += heightSplit;
            tes.func_78381_a();
        }
        TextureHelper.refreshTextureBindState();
        TextureHelper.setActiveTextureToAtlasSprite();
        RenderHelper.func_74520_c();
        RenderItem ri = Minecraft.func_71410_x().func_175599_af();
        tempOffsetY = offsetY;
        for (Map.Entry entry : amountMap.entrySet()) {
            ri.func_184391_a((EntityLivingBase)Minecraft.func_71410_x().field_71439_g, (ItemStack)entry.getKey(), offsetX + 5, tempOffsetY + 5);
            tempOffsetY += heightNormal;
            GlStateManager.func_179141_d();
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179097_i();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(offsetX + 14), (float)(offsetY + 16), (float)0.0f);
        int c = 0xDDDDDD;
        for (Map.Entry entry : amountMap.entrySet()) {
            String amountStr = String.valueOf(entry.getValue());
            if ((Integer)entry.getValue() == -1) {
                amountStr = "\u221e";
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(-Minecraft.func_71410_x().field_71466_p.func_78256_a(amountStr) / 3), (float)0.0f, (float)0.0f);
            GlStateManager.func_179139_a((double)0.7, (double)0.7, (double)0.7);
            if (amountStr.length() > 3) {
                GlStateManager.func_179139_a((double)0.9, (double)0.9, (double)0.9);
            }
            Minecraft.func_71410_x().field_71466_p.func_175063_a(amountStr, 0.0f, 0.0f, c);
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)heightNormal, (float)0.0f);
        }
        TextureHelper.refreshTextureBindState();
        GlStateManager.func_179121_F();
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179121_F();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderWhileInHand(ItemStack stack, EnumHand hand, float pTicks) {
        BlockArray blockArray;
        Map<IBlockState, ItemStack> storedStates = ItemExchangeWand.getMappedStoredStates(stack);
        if (storedStates.isEmpty()) {
            return;
        }
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Random r = ItemExchangeWand.getPreviewRandomFromWorld((World)world);
        EntityPlayerSP pl = Minecraft.func_71410_x().field_71439_g;
        PlayerControllerMP ctrl = Minecraft.func_71410_x().field_71442_b;
        if (ctrl == null || pl == null) {
            return;
        }
        RayTraceResult rtr = this.getLookBlock((Entity)pl, false, true, ctrl.func_78757_d());
        if (rtr == null || rtr.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        AirBlockRenderWorld airWorld = new AirBlockRenderWorld(Biomes.field_76772_c, world.func_175624_G());
        BlockPos origin = rtr.func_178782_a();
        IBlockState atOrigin = world.func_180495_p(origin);
        IBlockState match = MiscUtils.getMatchingState(storedStates.keySet(), atOrigin);
        if (match != null && storedStates.keySet().size() <= 1) {
            storedStates.remove(match);
        }
        if (storedStates.isEmpty()) {
            return;
        }
        float hardness = atOrigin.func_185887_b((World)world, origin);
        if (Config.exchangeWandMaxHardness != -1.0f && hardness > Config.exchangeWandMaxHardness) {
            return;
        }
        if (hardness == -1.0f) {
            return;
        }
        int total = 0;
        LinkedHashMap<IBlockState, Tuple<ItemStack, Integer>> amountMap = new LinkedHashMap<IBlockState, Tuple<ItemStack, Integer>>();
        for (Map.Entry<IBlockState, ItemStack> entry : storedStates.entrySet()) {
            int found2 = 0;
            if (Mods.BOTANIA.isPresent()) {
                found2 = ModIntegrationBotania.getItemCount((EntityPlayer)Minecraft.func_71410_x().field_71439_g, stack, ItemUtils.createBlockState(entry.getValue()));
            } else {
                Collection<ItemStack> stacks = ItemUtils.scanInventoryForMatching((IItemHandler)new InvWrapper((IInventory)Minecraft.func_71410_x().field_71439_g.field_71071_by), entry.getValue(), false);
                for (ItemStack foundStack : stacks) {
                    found2 += foundStack.func_190916_E();
                }
            }
            total += found2 == -1 ? 500000 : found2;
            amountMap.put(entry.getKey(), new Tuple<ItemStack, Integer>(entry.getValue(), found2));
        }
        Map<IBlockState, Integer> amtMap = MiscUtils.remap(amountMap, tpl -> (Integer)tpl.value);
        if (pl.func_184812_l_()) {
            for (IBlockState state : amtMap.keySet()) {
                amtMap.put(state, Integer.MAX_VALUE);
            }
            total = Integer.MAX_VALUE;
        }
        if ((blockArray = BlockDiscoverer.discoverBlocksWithSameStateAround((World)world, origin, true, 5, total, false)).isEmpty()) {
            return;
        }
        ArrayList applicableStates = Lists.newArrayList(storedStates.keySet());
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        Blending.ADDITIVEDARK.applyStateManager();
        Blending.ADDITIVEDARK.apply();
        GlStateManager.func_179097_i();
        GlStateManager.func_179118_c();
        RenderingUtils.removeStandartTranslationFromTESRMatrix(pTicks);
        TextureHelper.setActiveTextureToAtlasSprite();
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        for (BlockPos pos : blockArray.getPattern().keySet()) {
            Collections.shuffle(applicableStates, r);
            IBlockState potentialState = (IBlockState)Iterables.getFirst((Iterable)applicableStates, (Object)Blocks.field_150350_a.func_176223_P());
            try {
                potentialState = potentialState.func_177230_c().getStateForPlacement((World)world, pos, rtr.field_178784_b, (float)rtr.field_72307_f.field_72450_a, (float)rtr.field_72307_f.field_72448_b, (float)rtr.field_72307_f.field_72449_c, potentialState.func_177230_c().func_176201_c(potentialState), (EntityLivingBase)pl, hand);
            }
            catch (Exception exception) {
                // empty catch block
            }
            RenderingUtils.renderBlockSafely(airWorld, pos, potentialState, vb);
        }
        vb.func_181674_a((float)TileEntityRendererDispatcher.field_147554_b, (float)TileEntityRendererDispatcher.field_147555_c, (float)TileEntityRendererDispatcher.field_147552_d);
        tes.func_78381_a();
        TextureHelper.refreshTextureBindState();
        Blending.DEFAULT.apply();
        Blending.DEFAULT.applyStateManager();
        GlStateManager.func_179126_j();
        GlStateManager.func_179118_c();
        GlStateManager.func_179121_F();
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World world, BlockPos origin, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        BlockArray blockArray;
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        ItemStack stack = playerIn.func_184586_b(hand);
        if (stack.func_190926_b()) {
            return EnumActionResult.SUCCESS;
        }
        if (playerIn.func_70093_af()) {
            ItemExchangeWand.tryStoreBlock(stack, world, origin);
            return EnumActionResult.SUCCESS;
        }
        Map<IBlockState, ItemStack> storedStates = ItemExchangeWand.getMappedStoredStates(stack);
        IBlockState atOrigin = world.func_180495_p(origin);
        IBlockState match = MiscUtils.getMatchingState(storedStates.keySet(), atOrigin);
        if (match != null && storedStates.keySet().size() <= 1) {
            storedStates.remove(match);
        }
        if (storedStates.isEmpty()) {
            return EnumActionResult.SUCCESS;
        }
        float hardness = atOrigin.func_185887_b(world, origin);
        if (Config.exchangeWandMaxHardness != -1.0f && hardness > Config.exchangeWandMaxHardness) {
            return EnumActionResult.SUCCESS;
        }
        if (hardness == -1.0f) {
            return EnumActionResult.SUCCESS;
        }
        int total = 0;
        LinkedHashMap<IBlockState, Tuple<ItemStack, Integer>> amountMap = new LinkedHashMap<IBlockState, Tuple<ItemStack, Integer>>();
        for (Map.Entry<IBlockState, ItemStack> entry : storedStates.entrySet()) {
            int found2 = 0;
            if (Mods.BOTANIA.isPresent()) {
                found2 = ModIntegrationBotania.getItemCount(playerIn, stack, ItemUtils.createBlockState(entry.getValue()));
            } else {
                Collection<ItemStack> stacks = ItemUtils.scanInventoryForMatching((IItemHandler)new InvWrapper((IInventory)playerIn.field_71071_by), entry.getValue(), false);
                for (ItemStack foundStack : stacks) {
                    found2 += foundStack.func_190916_E();
                }
            }
            total += found2 == -1 ? 500000 : found2;
            amountMap.put(entry.getKey(), new Tuple<ItemStack, Integer>(entry.getValue(), found2));
        }
        Map<IBlockState, Integer> amtMap = MiscUtils.remap(amountMap, tpl -> (Integer)tpl.value);
        if (playerIn.func_184812_l_()) {
            for (IBlockState state : amtMap.keySet()) {
                amtMap.put(state, Integer.MAX_VALUE);
            }
            total = Integer.MAX_VALUE;
        }
        if ((blockArray = BlockDiscoverer.discoverBlocksWithSameStateAround(playerIn.func_130014_f_(), origin, true, 5, total, false)).isEmpty()) {
            return EnumActionResult.SUCCESS;
        }
        List<Tuple> shuffleable = MiscUtils.flatten(storedStates, Tuple::new);
        Random r = ItemExchangeWand.getPreviewRandomFromWorld(world);
        for (BlockPos placePos : blockArray.getPattern().keySet()) {
            Tuple applicable;
            Collections.shuffle(shuffleable, r);
            Tuple tuple = applicable = playerIn.func_184812_l_() ? (Tuple)Iterables.getFirst(shuffleable, null) : null;
            if (!playerIn.func_184812_l_()) {
                for (Tuple it : shuffleable) {
                    ItemStack test = ItemUtils.copyStackWithSize((ItemStack)it.value, 1);
                    if (!ItemUtils.consumeFromPlayerInventory(playerIn, stack, test, true)) continue;
                    applicable = it;
                    break;
                }
            }
            if (applicable == null) break;
            if (!this.drainTempCharge(playerIn, Config.exchangeWandUseCost, true) || !((EntityPlayerMP)playerIn).field_71134_c.func_180237_b(placePos)) continue;
            IBlockState place = (IBlockState)applicable.key;
            try {
                place = ((IBlockState)applicable.key).func_177230_c().getStateForPlacement(world, placePos, facing, hitX, hitY, hitZ, ((ItemStack)applicable.value).func_77960_j(), (EntityLivingBase)playerIn, hand);
            }
            catch (Exception it) {
                // empty catch block
            }
            if (!MiscUtils.canPlayerPlaceBlockPos(playerIn, hand, place, placePos, EnumFacing.UP) || !world.func_175656_a(placePos, place)) continue;
            this.drainTempCharge(playerIn, Config.exchangeWandUseCost, false);
            if (!playerIn.func_184812_l_()) {
                ItemUtils.consumeFromPlayerInventory(playerIn, stack, ItemUtils.copyStackWithSize((ItemStack)applicable.value, 1), false);
            }
            PktParticleEvent ev = new PktParticleEvent(PktParticleEvent.ParticleEventType.ARCHITECT_PLACE, (Vec3i)placePos);
            ev.setAdditionalDataLong(Block.func_176210_f((IBlockState)atOrigin));
            PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(world, (Vec3i)placePos, 40.0));
        }
        return EnumActionResult.SUCCESS;
    }
}

