/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.network;

import crafttweaker.CraftTweakerAPI;
import hellfirepvp.astralsorcery.common.crafting.helper.CraftingAccessManager;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.network.SerializeableRecipe;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.util.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class AltarRecipeRemove
implements SerializeableRecipe {
    private ItemStack matchOutRemove;
    private TileAltar.AltarLevel level;
    private String recipeRegistryName;

    AltarRecipeRemove() {
    }

    public AltarRecipeRemove(String recipeRegistryName) {
        this.recipeRegistryName = recipeRegistryName;
    }

    @Deprecated
    public AltarRecipeRemove(ItemStack matchOutRemove, TileAltar.AltarLevel altarLevel) {
        this.matchOutRemove = matchOutRemove;
        this.level = altarLevel;
    }

    @Override
    public SerializeableRecipe.CraftingType getType() {
        return SerializeableRecipe.CraftingType.ALTAR_REMOVE;
    }

    @Override
    public void read(ByteBuf buf) {
        this.recipeRegistryName = ByteBufUtils.readString(buf);
        this.matchOutRemove = ByteBufUtils.readItemStack(buf);
        this.level = TileAltar.AltarLevel.values()[buf.readInt()];
    }

    @Override
    public void write(ByteBuf buf) {
        ByteBufUtils.writeString(buf, this.recipeRegistryName);
        ByteBufUtils.writeItemStack(buf, this.matchOutRemove);
        buf.writeInt(this.level.ordinal());
    }

    @Override
    public void applyRecipe() {
        if (this.matchOutRemove != null) {
            CraftingAccessManager.tryRemoveAltarRecipeByOutputAndLevel(this.matchOutRemove, this.level);
        } else if (!CraftingAccessManager.tryRemoveAltarRecipe(new ResourceLocation(this.recipeRegistryName))) {
            CraftTweakerAPI.logError((String)("[AstralSorcery Altar Crafting] Could not find recipe to remove with name " + this.recipeRegistryName));
        }
    }
}

