/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base.patreon.base;

import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.obj.WavefrontObject;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.common.auxiliary.tick.ITickHandler;
import hellfirepvp.astralsorcery.common.auxiliary.tick.TickManager;
import hellfirepvp.astralsorcery.common.base.patreon.PatreonEffectHelper;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PtEffectCelestialWings
extends PatreonEffectHelper.PatreonEffect
implements ITickHandler {
    private final UUID playerUUID;
    private Object objShWings;
    private BindableResource texWings;
    private int dlList = -1;

    public PtEffectCelestialWings(UUID sessionEffectId, PatreonEffectHelper.FlareColor chosenColor, UUID playerUUID) {
        super(sessionEffectId, chosenColor);
        this.playerUUID = playerUUID;
    }

    @Override
    public void initialize() {
        super.initialize();
        MinecraftForge.EVENT_BUS.register((Object)this);
        TickManager.getInstance().register(this);
    }

    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        EntityPlayer player = (EntityPlayer)context[0];
        Side side = (Side)context[1];
        if (side == Side.CLIENT && player != null && player.func_110124_au().equals(this.playerUUID) && Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.func_110124_au().equals(this.playerUUID) && Minecraft.func_71410_x().field_71474_y.field_74320_O != 0) {
            this.spawnEffects(player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnEffects(EntityPlayer player) {
        float yOffset = 1.5f;
        if (player.func_70093_af()) {
            yOffset = 1.2f;
        }
        double offset = Math.sin(Math.abs((float)(ClientScheduler.getClientTick() % 120L) - 60.0f) / 60.0f) * 0.07;
        float rot = RenderingUtils.interpolateRotation(player.field_70760_ar, player.field_70761_aq, 0.0f);
        Vector3 look = new Vector3(1, 0, 0).rotate(Math.toRadians(360.0f - rot), Vector3.RotAxis.Y_AXIS).normalize();
        Vector3 pos = Vector3.atEntityCorner((Entity)player);
        pos.setY(player.field_70163_u + (double)yOffset + offset);
        for (int i = 0; i < 4; ++i) {
            double height = -0.1 + Math.min((double)rand.nextFloat() * 1.3, (double)rand.nextFloat() * 1.3);
            double distance = (double)1.1f - (double)rand.nextFloat() * 0.6 * (1.0 - Math.max(0.0, height));
            Vector3 dir = look.clone().rotate(Math.toRadians(180 * (rand.nextBoolean() ? 1 : 0)), Vector3.RotAxis.Y_AXIS).normalize().multiply(distance);
            Vector3 at = pos.clone().addY(height).add(dir);
            Color col = Color.getHSBColor(0.68f, 1.0f, 0.6f - rand.nextFloat() * 0.5f);
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle(at).setColor(col).scale(0.25f + rand.nextFloat() * 0.1f).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
            p.setMaxAge(25 + rand.nextInt(25));
            if (rand.nextInt(5) != 0) continue;
            p.scale(0.08f + rand.nextFloat() * 0.02f);
            p.setColor(Color.WHITE);
            p.setMaxAge(10 + rand.nextInt(5));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRender(RenderPlayerEvent.Post event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player == null || !player.func_110124_au().equals(this.playerUUID)) {
            return;
        }
        if (player.func_184218_aH() || player.func_184613_cA()) {
            return;
        }
        if (this.objShWings == null) {
            this.objShWings = AssetLoader.loadObjModel(AssetLoader.ModelLocation.OBJ, "sh_wings");
        }
        if (this.texWings == null) {
            this.texWings = AssetLibrary.loadTexture(AssetLoader.TextureLocation.MODELS, "star_bg");
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float rot = RenderingUtils.interpolateRotation(player.field_70760_ar, player.field_70761_aq, event.getPartialRenderTick());
        if (this.dlList == -1) {
            GlStateManager.func_179094_E();
            this.dlList = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_187423_f((int)this.dlList, (int)4864);
            ((WavefrontObject)this.objShWings).renderAll(true);
            GlStateManager.func_187415_K();
            GlStateManager.func_179121_F();
        }
        this.texWings.bind();
        float yOffset = 1.5f;
        if (player.func_70093_af()) {
            yOffset = 1.2f;
        }
        double offset = Math.sin(Math.abs((float)(ClientScheduler.getClientTick() % 120L) - 60.0f) / 60.0f) * 0.07;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)event.getX(), (double)(event.getY() + (double)yOffset + offset), (double)event.getZ());
        GlStateManager.func_179114_b((float)(180.0f - rot), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)0.02, (double)0.02, (double)0.02);
        GlStateManager.func_179140_f();
        GlStateManager.func_179109_b((float)-20.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179148_o((int)this.dlList);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-40.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179148_o((int)this.dlList);
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
        TextureHelper.refreshTextureBindState();
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.PLAYER);
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    @Override
    public String getName() {
        return "Patreon - Celestial Wings " + this.playerUUID.toString();
    }
}

