/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.gui;

import com.google.common.collect.BoundType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.data.KnowledgeFragmentData;
import hellfirepvp.astralsorcery.client.data.PersistentDataManager;
import hellfirepvp.astralsorcery.client.gui.journal.GuiScreenJournal;
import hellfirepvp.astralsorcery.client.gui.journal.overlay.GuiJournalOverlayKnowledge;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.GuiTextEntry;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.common.data.fragment.KnowledgeFragment;
import hellfirepvp.astralsorcery.common.lib.Sounds;
import hellfirepvp.astralsorcery.common.util.SoundHelper;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.opengl.GL11;

public class GuiJournalKnowledgeIndex
extends GuiScreenJournal {
    private static final AbstractRenderableTexture texArrow = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "guijarrow");
    private static final AbstractRenderableTexture textureSearchTextBG = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "guijtextarea");
    public static final int DEFAULT_WIDTH = 170;
    private static final int entriesLeft = 15;
    private static final int entriesRight = 14;
    private static Rectangle rectSearchTextEntry = new Rectangle(300, 20, 88, 15);
    private Rectangle rectNext;
    private Rectangle rectPrev;
    private KnowledgeFragment lastRenderHover = null;
    private final List<KnowledgeFragment> allFragments;
    private List<KnowledgeFragment> searchResult;
    private int doublePageID = 0;
    private Map<Integer, List<KnowledgeFragment>> indexedPages = Maps.newHashMap();
    private GuiTextEntry searchTextEntry = new GuiTextEntry();

    public GuiJournalKnowledgeIndex() {
        super(40);
        this.closeWithInventoryKey = false;
        KnowledgeFragmentData dat = (KnowledgeFragmentData)PersistentDataManager.INSTANCE.getData(PersistentDataManager.PersistentKey.KNOWLEDGE_FRAGMENTS);
        ArrayList known = Lists.newArrayList(dat.getAllFragments());
        known.removeIf(f -> !f.isFullyPresent());
        known.sort(Comparator.comparing(KnowledgeFragment::getLocalizedIndexName));
        this.allFragments = known;
        this.searchResult = Lists.newArrayList(this.allFragments);
        this.searchResult.sort(Comparator.comparing(KnowledgeFragment::getLocalizedIndexName));
        this.searchTextEntry.setChangeCallback(this::updateSearchResult);
        this.updatePages();
    }

    private void updateSearchResult() {
        this.searchResult = Lists.newArrayList(this.allFragments);
        String res = this.searchTextEntry.getText().toLowerCase();
        this.searchResult.removeIf(k -> !k.getLocalizedIndexName().toLowerCase().contains(res));
        this.searchResult.sort(Comparator.comparing(KnowledgeFragment::getLocalizedIndexName));
        this.updatePages();
    }

    private void updatePages() {
        this.indexedPages.clear();
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int index = 0;
        TreeMap results = Maps.newTreeMap();
        for (KnowledgeFragment frag : this.searchResult) {
            int lines = fr.func_78271_c(frag.getLocalizedIndexName(), 170).size();
            for (int i = 0; i < lines; ++i) {
                results.put(index, frag);
                ++index;
            }
        }
        int pageIndex = 0;
        LinkedList<KnowledgeFragment> currentDoublePage = new LinkedList<KnowledgeFragment>();
        do {
            int startIndex = pageIndex * 29;
            int endIndex = Math.min(startIndex + 29, results.size());
            NavigableMap pageMap = Maps.subMap((NavigableMap)results, (Range)Range.range((Comparable)Integer.valueOf(startIndex), (BoundType)BoundType.CLOSED, (Comparable)Integer.valueOf(endIndex), (BoundType)BoundType.OPEN));
            for (KnowledgeFragment frag : pageMap.values()) {
                if (currentDoublePage.contains(frag)) continue;
                currentDoublePage.add(frag);
            }
            this.indexedPages.put(pageIndex, currentDoublePage);
            currentDoublePage = new LinkedList();
        } while (results.containsKey(++pageIndex * 29));
        while (this.doublePageID > 0 && this.doublePageID >= this.indexedPages.size()) {
            --this.doublePageID;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        Point mouse = new Point(mouseX, mouseY);
        this.lastRenderHover = null;
        this.drawDefault(textureResBlank, mouse);
        this.drawFragmentIndices(mouseX, mouseY);
        this.drawSearchBox();
        this.field_73735_i += 150.0f;
        this.drawNavArrows(mouseX, mouseY, partialTicks);
        this.field_73735_i -= 150.0f;
    }

    private void drawFragmentIndices(int mouseX, int mouseY) {
        GL11.glColor4f((float)0.86f, (float)0.86f, (float)0.86f, (float)1.0f);
        GlStateManager.func_179131_c((float)0.86f, (float)0.86f, (float)0.86f, (float)1.0f);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GL11.glEnable((int)3042);
        Blending.DEFAULT.apply();
        Blending.DEFAULT.applyStateManager();
        TextureHelper.setActiveTextureToAtlasSprite();
        int offsetX = this.guiLeft + 35;
        int offsetY = this.guiTop + 26;
        List<KnowledgeFragment> pageFragments = this.indexedPages.get(this.doublePageID);
        if (pageFragments != null) {
            Object rctString;
            int length;
            int maxLength;
            List lines;
            KnowledgeFragment frag;
            int iOffsetY;
            int y;
            int step;
            int idx;
            int start = 0;
            int drawIndex = 0;
            boolean drewHover = false;
            double effectPart = (Math.sin(Math.toRadians((double)ClientScheduler.getClientTick() * 5.0 % 360.0)) + 1.0) / 2.0;
            int br = Math.round((0.45f + 0.1f * (float)effectPart) * 255.0f);
            int c = Math.round((0.7f + 0.2f * (float)effectPart) * 255.0f);
            Color boxColor = new Color(c, c, c, br);
            for (idx = 0; idx < Math.min(pageFragments.size(), start + 15) && drawIndex < 15; ++idx) {
                step = 12;
                iOffsetY = y = offsetY + drawIndex * step;
                frag = pageFragments.get(idx);
                lines = this.field_146289_q.func_78271_c(frag.getLocalizedIndexName(), 170);
                drawIndex += lines.size();
                maxLength = 0;
                for (String line : lines) {
                    length = this.field_146289_q.func_175065_a(line, (float)offsetX, (float)iOffsetY, 0xD0D0D0, false) - offsetX;
                    if (length > maxLength) {
                        maxLength = length;
                    }
                    iOffsetY += step;
                }
                rctString = new Rectangle(offsetX - 2, y - 2, maxLength + 4, iOffsetY - y);
                if (drewHover || !((Rectangle)rctString).contains(mouseX, mouseY)) continue;
                GuiJournalKnowledgeIndex.func_73734_a((int)((Rectangle)rctString).x, (int)((Rectangle)rctString).y, (int)(((Rectangle)rctString).x + ((Rectangle)rctString).width), (int)(((Rectangle)rctString).y + ((Rectangle)rctString).height), (int)boxColor.getRGB());
                this.lastRenderHover = frag;
                drewHover = true;
            }
            offsetX = this.guiLeft + 225;
            offsetY = this.guiTop + 39;
            start += idx;
            drawIndex = 0;
            while (idx < Math.min(pageFragments.size(), start + 14)) {
                step = 12;
                iOffsetY = y = offsetY + drawIndex * step;
                frag = pageFragments.get(idx);
                lines = this.field_146289_q.func_78271_c(frag.getLocalizedIndexName(), 170);
                drawIndex += lines.size();
                maxLength = 0;
                for (String line : lines) {
                    length = this.field_146289_q.func_175065_a(line, (float)offsetX, (float)iOffsetY, 0xD0D0D0, false) - offsetX;
                    if (length > maxLength) {
                        maxLength = length;
                    }
                    iOffsetY += step;
                }
                rctString = new Rectangle(offsetX - 2, y - 2, maxLength + 4, iOffsetY - y);
                if (!drewHover && ((Rectangle)rctString).contains(mouseX, mouseY)) {
                    GuiJournalKnowledgeIndex.func_73734_a((int)((Rectangle)rctString).x, (int)((Rectangle)rctString).y, (int)(((Rectangle)rctString).x + ((Rectangle)rctString).width), (int)(((Rectangle)rctString).y + ((Rectangle)rctString).height), (int)boxColor.getRGB());
                    this.lastRenderHover = frag;
                    drewHover = true;
                }
                ++idx;
            }
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TextureHelper.refreshTextureBindState();
    }

    @Override
    protected boolean handleRightClickClose(int mouseX, int mouseY) {
        if (rectSearchTextEntry.contains(mouseX - this.guiLeft, mouseY - this.guiTop)) {
            this.searchTextEntry.setText("");
            return true;
        }
        return false;
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton != 0) {
            return;
        }
        Point p = new Point(mouseX, mouseY);
        if (this.handleBookmarkClick(p)) {
            return;
        }
        if (this.rectPrev != null && this.rectPrev.contains(p)) {
            if (this.doublePageID >= 1) {
                --this.doublePageID;
            }
            SoundHelper.playSoundClient(Sounds.bookFlip, 1.0f, 1.0f);
            return;
        }
        if (this.rectNext != null && this.rectNext.contains(p)) {
            if (this.doublePageID <= this.indexedPages.size() - 1) {
                ++this.doublePageID;
            }
            SoundHelper.playSoundClient(Sounds.bookFlip, 1.0f, 1.0f);
            return;
        }
        if (this.lastRenderHover != null) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiJournalOverlayKnowledge(this, this.lastRenderHover));
            SoundHelper.playSoundClient(Sounds.bookFlip, 1.0f, 1.0f);
            return;
        }
    }

    private void drawSearchBox() {
        boolean addDots;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        Blending.DEFAULT.applyStateManager();
        GlStateManager.func_179118_c();
        GlStateManager.func_179097_i();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(this.guiLeft + 300), (float)(this.guiTop + 20), (float)0.0f);
        textureSearchTextBG.bindTexture();
        this.drawTexturedRectAtCurrentPos(88.5, 15.0);
        String text = this.searchTextEntry.getText();
        int length = this.field_146289_q.func_78256_a(text);
        boolean bl = addDots = length > 75;
        while (length > 75) {
            text = text.substring(1, text.length());
            length = this.field_146289_q.func_78256_a("..." + text);
        }
        if (addDots) {
            text = "..." + text;
        }
        if (ClientScheduler.getClientTick() % 20L > 10L) {
            text = text + "_";
        }
        GlStateManager.func_179109_b((float)4.0f, (float)4.0f, (float)0.0f);
        this.field_146289_q.func_175065_a(text, 0.0f, 0.0f, new Color(0xCCCCCC).getRGB(), false);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TextureHelper.refreshTextureBindState();
        GlStateManager.func_179121_F();
        GlStateManager.func_179141_d();
        GlStateManager.func_179126_j();
    }

    private void drawNavArrows(int mouseX, int mouseY, float partialTicks) {
        float sin;
        double t;
        float vFrom;
        float uFrom;
        int height;
        int width;
        GlStateManager.func_179097_i();
        Point mouse = new Point(mouseX, mouseY);
        this.rectNext = null;
        this.rectPrev = null;
        if (this.doublePageID - 1 >= 0) {
            width = 30;
            height = 15;
            this.rectPrev = new Rectangle(this.guiLeft + 25, this.guiTop + 220, width, height);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(this.rectPrev.getX() + (double)(width / 2)), (double)(this.rectPrev.getY() + (double)(height / 2)), (double)0.0);
            uFrom = 0.0f;
            vFrom = 0.5f;
            if (this.rectPrev.contains(mouse)) {
                uFrom = 0.5f;
                GlStateManager.func_179139_a((double)1.1, (double)1.1, (double)1.1);
            } else {
                t = (float)ClientScheduler.getClientTick() + partialTicks;
                sin = (float)Math.sin(t / 4.0) / 32.0f + 1.0f;
                GlStateManager.func_179152_a((float)sin, (float)sin, (float)sin);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
            GlStateManager.func_179109_b((float)(-(width / 2)), (float)(-(height / 2)), (float)0.0f);
            texArrow.bindTexture();
            this.drawTexturedRectAtCurrentPos(width, height, uFrom, vFrom, 0.5f, 0.5f);
            GlStateManager.func_179121_F();
        }
        if (this.doublePageID + 1 < this.indexedPages.size()) {
            width = 30;
            height = 15;
            this.rectNext = new Rectangle(this.guiLeft + 367, this.guiTop + 220, width, height);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(this.rectNext.getX() + (double)(width / 2)), (double)(this.rectNext.getY() + (double)(height / 2)), (double)0.0);
            uFrom = 0.0f;
            vFrom = 0.0f;
            if (this.rectNext.contains(mouse)) {
                uFrom = 0.5f;
                GlStateManager.func_179139_a((double)1.1, (double)1.1, (double)1.1);
            } else {
                t = (float)ClientScheduler.getClientTick() + partialTicks;
                sin = (float)Math.sin(t / 4.0) / 32.0f + 1.0f;
                GlStateManager.func_179152_a((float)sin, (float)sin, (float)sin);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
            GlStateManager.func_179109_b((float)(-(width / 2)), (float)(-(height / 2)), (float)0.0f);
            texArrow.bindTexture();
            this.drawTexturedRectAtCurrentPos(width, height, uFrom, vFrom, 0.5f, 0.5f);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179126_j();
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (keyCode != 1) {
            this.searchTextEntry.textboxKeyTyped(typedChar, keyCode);
        }
    }
}

