/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.recipes;

import com.google.gson.JsonObject;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class BeeIngredient
extends Ingredient {
    public static final Random rand = new Random();
    @Nonnull
    final Set<EnumBeeType> allowedTypes;
    final IAllele[] requirements;
    ItemStack[] stacks;

    public BeeIngredient(@Nonnull Set<EnumBeeType> allowedTypes, IAllele[] requirements) {
        super(BeeIngredient.createMatchingStacks(allowedTypes));
        this.allowedTypes = allowedTypes;
        this.requirements = requirements;
    }

    private static ItemStack[] createMatchingStacks(@Nonnull Set<EnumBeeType> allowedTypes) {
        return (ItemStack[])allowedTypes.stream().map(t -> {
            switch (t) {
                case DRONE: {
                    return "bee_drone_ge";
                }
                case PRINCESS: {
                    return "bee_princess_ge";
                }
                case QUEEN: {
                    return "bee_queen_ge";
                }
                case LARVAE: {
                    return "bee_larvae_ge";
                }
            }
            throw new IllegalStateException();
        }).map(s -> new ResourceLocation("forestry", s)).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getValue(arg_0)).map(ItemStack::new).toArray(ItemStack[]::new);
    }

    @Nonnull
    public static ItemStack[] createRandomBees(int n, @Nonnull Collection<EnumBeeType> allowedTypes, @Nonnull IAllele[] requirements, @Nonnull Random random) {
        ItemStack[] stacks = new ItemStack[n];
        IAllele[][][] template = new IAllele[n][2][requirements.length];
        EnumBeeChromosome[] values = EnumBeeChromosome.values();
        for (int i = 0; i < values.length; ++i) {
            int j;
            ArrayList iAlleles;
            IAllele requirement = requirements[i];
            if (!(requirement == null || values[i] != EnumBeeChromosome.SPECIES && requirement.isDominant())) {
                for (int j2 = 0; j2 < n; ++j2) {
                    IAllele iAllele = requirement;
                    template[j2][1][i] = iAllele;
                    template[j2][0][i] = iAllele;
                }
                continue;
            }
            if (requirement != null && requirement.isDominant()) {
                EnumBeeChromosome enumBeeChromosome = values[i];
                iAlleles = new ArrayList(AlleleManager.alleleRegistry.getRegisteredAlleles((IChromosomeType)enumBeeChromosome));
                if (iAlleles.isEmpty()) {
                    return new ItemStack[0];
                }
                for (j = 0; j < n; ++j) {
                    int k = random.nextInt(2);
                    template[j][k][i] = requirement;
                    template[j][1 - k][i] = (IAllele)iAlleles.get(random.nextInt(iAlleles.size()));
                }
                continue;
            }
            EnumBeeChromosome enumBeeChromosome = values[i];
            iAlleles = new ArrayList(AlleleManager.alleleRegistry.getRegisteredAlleles((IChromosomeType)enumBeeChromosome));
            if (iAlleles.isEmpty()) {
                return new ItemStack[0];
            }
            for (j = 0; j < n; ++j) {
                template[j][0][i] = (IAllele)iAlleles.get(random.nextInt(iAlleles.size()));
                template[j][1][i] = (IAllele)iAlleles.get(random.nextInt(iAlleles.size()));
            }
        }
        ArrayList<EnumBeeType> beeTypes = new ArrayList<EnumBeeType>(allowedTypes);
        for (int j = 0; j < n; ++j) {
            ItemStack beeStack;
            IBeeGenome genome = BeeManager.beeRoot.templateAsGenome(template[j][0], template[j][1]);
            IBee bee = BeeManager.beeRoot.getBee(genome);
            EnumBeeType enumBeeType = beeTypes.get(random.nextInt(beeTypes.size()));
            bee.analyze();
            stacks[j] = beeStack = BeeManager.beeRoot.getMemberStack((IIndividual)bee, (ISpeciesType)enumBeeType);
        }
        return stacks;
    }

    @Nonnull
    public ItemStack[] func_193365_a() {
        if (this.stacks == null) {
            this.stacks = BeeIngredient.createRandomBees(24, this.allowedTypes, this.requirements, rand);
        }
        return this.stacks;
    }

    public boolean apply(@Nullable ItemStack p_apply_1_) {
        if (p_apply_1_ == null) {
            return false;
        }
        EnumBeeType type = BeeManager.beeRoot.getType(p_apply_1_);
        if (type == null || !this.allowedTypes.contains(type)) {
            return false;
        }
        IBee member = BeeManager.beeRoot.getMember(p_apply_1_);
        if (member == null) {
            return false;
        }
        IBeeGenome genome = member.getGenome();
        IChromosome[] chromosomes = genome.getChromosomes();
        for (int i = 0; i < this.requirements.length; ++i) {
            if (this.requirements[i] == null || chromosomes[i].getActiveAllele().equals(this.requirements[i])) continue;
            return false;
        }
        return super.apply(p_apply_1_);
    }

    public static class Factory
    implements IIngredientFactory {
        @Nonnull
        public Ingredient parse(JsonContext context, @Nonnull JsonObject json) {
            EnumSet<EnumBeeType> allowedTypes;
            String type = JsonUtils.func_151219_a((JsonObject)json, (String)"beetype", (String)"any");
            if (Objects.equals(type, "any")) {
                allowedTypes = EnumSet.allOf(EnumBeeType.class);
            } else {
                allowedTypes = EnumSet.noneOf(EnumBeeType.class);
                for (String s : type.split(",")) {
                    EnumBeeType enumBeeType = EnumBeeType.valueOf((String)s.toUpperCase(Locale.ENGLISH));
                    allowedTypes.add(enumBeeType);
                }
            }
            JsonUtils.func_151200_h((JsonObject)json, (String)"species");
            IAllele[] requirements = new IAllele[EnumBeeChromosome.values().length];
            for (EnumBeeChromosome enumBeeChromosome : EnumBeeChromosome.values()) {
                IAllele allele;
                String name = enumBeeChromosome.getName();
                if (!JsonUtils.func_151204_g((JsonObject)json, (String)name)) continue;
                String string = JsonUtils.func_151200_h((JsonObject)json, (String)name);
                requirements[enumBeeChromosome.ordinal()] = allele = AlleleManager.alleleRegistry.getAllele(string);
            }
            return new BeeIngredient(allowedTypes, requirements);
        }
    }
}

