/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import com.rwtema.careerbees.effects.EffectBase;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import java.util.HashMap;
import java.util.Iterator;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class HousingTerritoryTracker {
    private static final Function<Byte, WeakHashMap<IBeeHousing, AxisAlignedBB>> WEAK_MAP_LAMBDA = t -> new WeakHashMap();
    private final WeakHashMap<World, HashMap<Byte, WeakHashMap<IBeeHousing, AxisAlignedBB>>> bounds_server = new WeakHashMap();
    private final WeakHashMap<World, HashMap<Byte, WeakHashMap<IBeeHousing, AxisAlignedBB>>> bounds_client = new WeakHashMap();
    private final Predicate<IBeeHousing> isValidPredicate;

    public HousingTerritoryTracker(Predicate<IBeeHousing> isValidPredicate) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.isValidPredicate = isValidPredicate;
    }

    public HousingTerritoryTracker(EffectBase effectBase) {
        this((IBeeHousing housing) -> {
            ItemStack queen = housing.getBeeInventory().getQueen();
            if (queen.func_190926_b()) {
                return false;
            }
            IBee member = BeeManager.beeRoot.getMember(queen);
            if (member == null) {
                return false;
            }
            IBeeGenome genome = member.getGenome();
            return genome.getEffect() == effectBase && effectBase.isValidSpecies(genome);
        });
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        this.getMap(event.getWorld()).remove(event.getWorld());
    }

    public WeakHashMap<World, HashMap<Byte, WeakHashMap<IBeeHousing, AxisAlignedBB>>> getMap(World world) {
        return world.field_72995_K ? this.bounds_client : this.bounds_server;
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        World world = event.world;
        HashMap<Byte, WeakHashMap<IBeeHousing, AxisAlignedBB>> map = this.getMap(world).get(world);
        if (world.func_82737_E() % 16L != 0L) {
            return;
        }
        if (map == null) {
            return;
        }
        Iterator<WeakHashMap<IBeeHousing, AxisAlignedBB>> iterator = map.values().iterator();
        while (iterator.hasNext()) {
            WeakHashMap<IBeeHousing, AxisAlignedBB> weakHashMap = iterator.next();
            weakHashMap.keySet().removeIf(t -> !this.isValid((IBeeHousing)t));
            if (!weakHashMap.isEmpty()) continue;
            iterator.remove();
        }
    }

    public boolean isInRange(World world, BlockPos pos) {
        HashMap<Byte, WeakHashMap<IBeeHousing, AxisAlignedBB>> m = this.getMap(world).get(world);
        if (m == null) {
            return false;
        }
        WeakHashMap<IBeeHousing, AxisAlignedBB> s = m.get(this.hashChunk(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4));
        if (s == null) {
            return false;
        }
        for (AxisAlignedBB bb : s.values()) {
            if (!bb.func_186668_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1))) continue;
            return true;
        }
        return false;
    }

    public boolean isValid(IBeeHousing housing) {
        if (housing instanceof TileEntity ? ((TileEntity)housing).func_145837_r() : housing instanceof Entity && ((Entity)housing).field_70128_L) {
            return false;
        }
        return this.isValidPredicate.test(housing);
    }

    public void register(IBeeHousing housing, AxisAlignedBB territory) {
        HashMap<Byte, WeakHashMap<IBeeHousing, AxisAlignedBB>> boundmap = this.getMap(housing.getWorldObj()).get(housing.getWorldObj());
        for (int dx = MathHelper.func_76128_c((double)territory.field_72340_a) >> 4; dx <= MathHelper.func_76128_c((double)territory.field_72336_d) >> 4; ++dx) {
            int dz = MathHelper.func_76128_c((double)territory.field_72339_c) >> 4;
            while (dx <= MathHelper.func_76128_c((double)territory.field_72334_f) >> 4) {
                byte b = this.hashChunk(dx, dz);
                WeakHashMap<IBeeHousing, AxisAlignedBB> map = boundmap.computeIfAbsent(b, WEAK_MAP_LAMBDA);
                map.put(housing, territory);
                ++dx;
            }
        }
    }

    public byte hashChunk(int chunk_x, int chunk_z) {
        return (byte)(15 * chunk_x + chunk_z);
    }
}

