/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import com.google.common.collect.Lists;
import com.rwtema.careerbees.effects.EffectBaseThrottled;
import com.rwtema.careerbees.effects.settings.IEffectSettingsHolder;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.genetics.IEffectData;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class EffectBuisness
extends EffectBaseThrottled {
    public static final EffectBuisness JUNK = new EffectBuisness("junk_sale", 100.0f){

        @Override
        public int numTrades(Random random) {
            return 2 + random.nextInt(10);
        }

        @Override
        @Nonnull
        public ItemStack getStack(@Nonnull Random random, ItemStack itemToSell) {
            int maxDamage;
            if ((itemToSell = itemToSell.func_77946_l()).func_77984_f() && (maxDamage = itemToSell.func_77958_k()) > 0) {
                int newDamage = maxDamage - Math.max(1, random.nextInt(maxDamage / 2));
                itemToSell.func_77964_b(newDamage);
            }
            return itemToSell;
        }

        @Override
        public boolean isValidItemToSell(ItemStack itemToSell1) {
            NBTTagCompound tagCompound = itemToSell1.func_77978_p();
            return tagCompound == null || tagCompound.func_150296_c().size() == 1 && tagCompound.func_150297_b("ench", 9);
        }

        @Override
        public boolean isValidItemToBuy(ItemStack buy1, @Nullable ItemStack buy2) {
            return buy1.func_77973_b() == Items.field_151166_bC && buy2 == null;
        }
    };
    public static final EffectBuisness INSTANCE = new EffectBuisness("buisness", 100.0f){

        @Override
        @Nonnull
        public ItemStack getStack(@Nonnull Random random, ItemStack itemToSell) {
            int skim = itemToSell.func_190916_E() / 2;
            if (skim > 0) {
                itemToSell = itemToSell.func_77946_l();
                itemToSell.func_190920_e(itemToSell.func_190916_E() - skim + random.nextInt(skim));
            }
            return itemToSell;
        }

        @Override
        public boolean isValidItemToSell(ItemStack itemToSell1) {
            return itemToSell1.func_77973_b() == Items.field_151166_bC;
        }

        @Override
        public boolean isValidItemToBuy(ItemStack buy1, @Nullable ItemStack buy2) {
            return true;
        }
    };
    private ArrayList<EntityVillager.ITradeList> trades;

    public EffectBuisness(String name, float baseTicksBetweenProcessing) {
        super(name, baseTicksBetweenProcessing);
    }

    public ArrayList<EntityVillager.ITradeList> getTrades() {
        ArrayList<Object> trades = this.trades;
        if (trades == null) {
            trades = new ArrayList();
            for (VillagerRegistry.VillagerProfession profession : GameRegistry.findRegistry(VillagerRegistry.VillagerProfession.class).getValues()) {
                HashSet<VillagerRegistry.VillagerCareer> careers = new HashSet<VillagerRegistry.VillagerCareer>();
                for (int i = 0; i < 100 && careers.add(profession.getCareer(i)); ++i) {
                }
                for (VillagerRegistry.VillagerCareer career : careers) {
                    for (int i = 0; i < 20; ++i) {
                        List trade = career.getTrades(i);
                        if (trade == null) continue;
                        trades.addAll(trade);
                    }
                }
            }
            this.trades = trades;
        }
        return trades;
    }

    public int numTrades(Random random) {
        return 1;
    }

    @Override
    public void performEffect(@Nonnull IBeeGenome genome, @Nonnull IEffectData storedData, @Nonnull IBeeHousing housing, @Nonnull Random random, World world, BlockPos pos, IBeeModifier beeHousingModifier, IBeeModifier beeModeModifier, IEffectSettingsHolder settings) {
        int numTrades = this.numTrades(random);
        if (numTrades == 0) {
            return;
        }
        HashMap<ItemStackTrackerEntry, InvInventory> stacks = new HashMap<ItemStackTrackerEntry, InvInventory>();
        for (IItemHandler handler : this.getAdjacentCapabilities(housing, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack itemStack = handler.extractItem(i, 64, true);
                if (itemStack.func_190926_b()) continue;
                stacks.computeIfAbsent(new ItemStackTrackerEntry(itemStack), t -> new InvInventory()).track(handler, i, itemStack.func_190916_E());
            }
        }
        if (stacks.isEmpty()) {
            return;
        }
        MyIMerchant merchant = new MyIMerchant(housing);
        ArrayList shuffledTradeLists = Lists.newArrayList(this.getTrades());
        Collections.shuffle(shuffledTradeLists);
        for (EntityVillager.ITradeList trade : shuffledTradeLists) {
            MerchantRecipeList list = new MerchantRecipeList();
            trade.func_190888_a((IMerchant)merchant, list, random);
            for (MerchantRecipe recipe : list) {
                InvInventory secondInvInventory;
                ItemStack secondItemToBuy;
                ItemStack itemToBuy;
                InvInventory invInventory;
                ItemStack itemToSell1;
                if (recipe.func_82784_g() || !this.isValidItemToSell(itemToSell1 = recipe.func_77397_d()) || (invInventory = (InvInventory)stacks.get(new ItemStackTrackerEntry(itemToBuy = recipe.func_77394_a()))) == null || invInventory.num < itemToBuy.func_190916_E()) continue;
                boolean hasSecondItemToBuy = recipe.func_77398_c();
                if (hasSecondItemToBuy) {
                    secondItemToBuy = recipe.func_77396_b();
                    if (ItemHandlerHelper.canItemStacksStack((ItemStack)itemToBuy, (ItemStack)secondItemToBuy)) {
                        itemToBuy.func_190917_f(secondItemToBuy.func_190916_E());
                        if (invInventory.num < itemToBuy.func_190916_E()) continue;
                        hasSecondItemToBuy = false;
                        secondItemToBuy = null;
                        secondInvInventory = null;
                    } else {
                        secondInvInventory = (InvInventory)stacks.get(new ItemStackTrackerEntry(secondItemToBuy));
                        if (secondInvInventory == null || secondInvInventory.num < itemToBuy.func_190916_E()) {
                            continue;
                        }
                    }
                } else {
                    secondItemToBuy = null;
                    secondInvInventory = null;
                }
                if (!this.isValidItemToBuy(itemToBuy, secondItemToBuy)) continue;
                ItemStack itemToSell = itemToSell1;
                if ((itemToSell = this.getStack(random, itemToSell)).func_190926_b()) continue;
                if (invInventory.extract(itemToBuy, false) && (!hasSecondItemToBuy || secondInvInventory.extract(secondItemToBuy, false)) && housing.getBeeInventory().addProduct(itemToSell, true)) {
                    invInventory.extract(itemToBuy, true);
                    if (hasSecondItemToBuy) {
                        secondInvInventory.extract(secondItemToBuy, true);
                    }
                }
                if (--numTrades > 0) continue;
                return;
            }
        }
    }

    @Nonnull
    public abstract ItemStack getStack(@Nonnull Random var1, ItemStack var2);

    public abstract boolean isValidItemToSell(ItemStack var1);

    public abstract boolean isValidItemToBuy(ItemStack var1, @Nullable ItemStack var2);

    public static class MyIMerchant
    implements IMerchant {
        private final IBeeHousing housing;

        public MyIMerchant(IBeeHousing housing) {
            this.housing = housing;
        }

        @Nullable
        public EntityPlayer func_70931_l_() {
            return null;
        }

        public void func_70932_a_(@Nullable EntityPlayer player) {
        }

        @Nullable
        public MerchantRecipeList func_70934_b(@Nonnull EntityPlayer player) {
            return null;
        }

        public void func_70930_a(@Nullable MerchantRecipeList recipeList) {
        }

        public void func_70933_a(@Nonnull MerchantRecipe recipe) {
        }

        public void func_110297_a_(@Nonnull ItemStack stack) {
        }

        @Nonnull
        public ITextComponent func_145748_c_() {
            return this.housing.getBeeInventory().getQueen().func_151000_E();
        }

        @Nonnull
        public World func_190670_t_() {
            return this.housing.getWorldObj();
        }

        @Nonnull
        public BlockPos func_190671_u_() {
            return this.housing.getCoordinates();
        }
    }

    public static class ItemStackTrackerEntry {
        public final ItemStack stack;

        public ItemStackTrackerEntry(ItemStack stack) {
            this.stack = stack;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof ItemStackTrackerEntry && ItemHandlerHelper.canItemStacksStack((ItemStack)this.stack, (ItemStack)((ItemStackTrackerEntry)obj).stack);
        }

        public int hashCode() {
            int hash = System.identityHashCode(this.stack.func_77973_b());
            hash = hash * 31 + this.stack.func_77960_j();
            hash = hash * 31 + (this.stack.func_77942_o() ? 1 : 0);
            return hash;
        }
    }

    private static class InvInventory {
        int num;
        HashMap<IItemHandler, TIntHashSet> slots = new HashMap();

        private InvInventory() {
        }

        public void track(IItemHandler inv, int slot, int amount) {
            this.num += amount;
            this.slots.computeIfAbsent(inv, t -> new TIntHashSet()).add(slot);
        }

        public boolean extract(@Nonnull ItemStack target, boolean doExtract) {
            int n = target.func_190916_E();
            for (Map.Entry<IItemHandler, TIntHashSet> entry : this.slots.entrySet()) {
                for (int slot : entry.getValue()) {
                    ItemStack item = entry.getKey().extractItem(slot, n, !doExtract);
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)item, (ItemStack)target) || (n -= item.func_190916_E()) > 0) continue;
                    return true;
                }
            }
            return n <= 0;
        }
    }
}

