/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.bees;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.rwtema.careerbees.BeeMod;
import com.rwtema.careerbees.helpers.CollectionHelper;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeMutationBuilder;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IMutationBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;

public class BeeMutationTree {
    final List<Entry> entries = new ArrayList<Entry>();
    final HashMultimap<SpeciesEntry, Entry> recipes = HashMultimap.create();

    public void add(SpeciesEntry a, SpeciesEntry b, SpeciesEntry result, double chance) {
        this.add(a, b, result, chance, null);
    }

    public void add(SpeciesEntry a, SpeciesEntry b, SpeciesEntry result, double chance, Function<IBeeMutationBuilder, IMutationBuilder> requirements) {
        Entry entry = new Entry(a, b, result, chance, requirements);
        this.entries.add(entry);
        this.recipes.put((Object)result, (Object)entry);
    }

    @Nonnull
    public List<SpeciesEntry> getVanillaParents(SpeciesEntry entry) {
        SpeciesEntry poll;
        HashSet<SpeciesEntry> checked = new HashSet<SpeciesEntry>();
        LinkedList<SpeciesEntry> toCheck = new LinkedList<SpeciesEntry>();
        toCheck.add(entry);
        ArrayList<SpeciesEntry> results = new ArrayList<SpeciesEntry>();
        while ((poll = (SpeciesEntry)toCheck.poll()) != null) {
            if (poll.isVanilla()) {
                results.add(poll);
            }
            for (Entry e : this.recipes.get((Object)poll)) {
                if (checked.add(e.a)) {
                    toCheck.add(e.a);
                }
                if (!checked.add(e.b)) continue;
                toCheck.add(e.b);
            }
        }
        return results;
    }

    public List<SpeciesEntry> getParents(SpeciesEntry entry) {
        if (!this.recipes.containsKey((Object)entry)) {
            return ImmutableList.of();
        }
        ArrayList<SpeciesEntry> results = new ArrayList<SpeciesEntry>();
        for (Entry entry1 : this.recipes.get((Object)entry)) {
            results.add(entry1.a);
            results.add(entry1.b);
        }
        for (int i = 0; i < results.size(); ++i) {
            for (Entry entry1 : this.recipes.get((Object)entry)) {
                results.add(entry1.a);
                results.add(entry1.b);
            }
        }
        return results;
    }

    public int getComplexity(SpeciesEntry spc) {
        return this.getLeastParents(spc).stream().mapToInt(HashSet::size).min().orElse(0);
    }

    @Nonnull
    public Set<HashSet<SpeciesEntry>> getLeastParents(SpeciesEntry spc) {
        return this.getLeastParents(spc, new HashSet<SpeciesEntry>());
    }

    @Nonnull
    public Set<HashSet<SpeciesEntry>> getLeastParents(SpeciesEntry spc, @Nonnull Set<SpeciesEntry> visited) {
        HashSet<HashSet<SpeciesEntry>> entries = new HashSet<HashSet<SpeciesEntry>>();
        if (!this.recipes.containsKey((Object)spc)) {
            return ImmutableSet.of((Object)Sets.newHashSet((Object[])new SpeciesEntry[]{spc}));
        }
        HashSet updatedVisited = Sets.newHashSet(visited);
        updatedVisited.add(spc);
        for (Entry e : this.recipes.get((Object)spc)) {
            if (updatedVisited.contains(e.a) || updatedVisited.contains(e.b)) continue;
            if (e.a == e.b) {
                for (HashSet<SpeciesEntry> sa : this.getLeastParents(e.a, updatedVisited)) {
                    HashSet<SpeciesEntry> s = new HashSet<SpeciesEntry>();
                    s.addAll(sa);
                    s.add(spc);
                    entries.add(s);
                }
                continue;
            }
            for (HashSet<SpeciesEntry> sa : this.getLeastParents(e.a, updatedVisited)) {
                for (HashSet<SpeciesEntry> sb : this.getLeastParents(e.b, updatedVisited)) {
                    HashSet<SpeciesEntry> s = new HashSet<SpeciesEntry>();
                    s.addAll(sa);
                    s.addAll(sb);
                    s.add(spc);
                    entries.add(s);
                }
            }
        }
        return entries;
    }

    public void registerMutations() {
        if (BeeMod.deobf) {
            BeeMod.logger.info(this.entries.stream().flatMap(e -> Stream.of(e.a, e.b, e.result)).distinct().sorted(Comparator.comparingInt(this::getComplexity).thenComparing(Object::toString)).map(s -> s + " " + this.getComplexity((SpeciesEntry)s)).collect(Collectors.joining("\n")));
        }
        for (Entry entry : this.entries) {
            ArrayList pair = Lists.newArrayList((Object[])new SpeciesEntry[]{entry.a, entry.b});
            pair.sort(CollectionHelper.firstCheckEqualThen(Comparator.comparing(SpeciesEntry::isVanilla).thenComparingInt(this::getComplexity)));
            IAlleleBeeSpecies primary = (IAlleleBeeSpecies)((SpeciesEntry)pair.get(0)).get();
            IAlleleBeeSpecies secondary = (IAlleleBeeSpecies)((SpeciesEntry)pair.get(1)).get();
            IBeeMutationBuilder mutation = BeeManager.beeMutationFactory.createMutation(primary, secondary, BeeManager.beeRoot.getTemplate((IAlleleSpecies)entry.result.get()), (int)Math.round(100.0 * entry.chance));
            if (entry.requirement != null) {
                mutation = (IBeeMutationBuilder)entry.requirement.apply(mutation);
            }
            mutation.build();
        }
    }

    public class Entry {
        public final SpeciesEntry a;
        public final SpeciesEntry b;
        public final SpeciesEntry result;
        public final double chance;
        public final Function<IBeeMutationBuilder, IMutationBuilder> requirement;

        public Entry(SpeciesEntry a, SpeciesEntry b, SpeciesEntry result, double chance, Function<IBeeMutationBuilder, IMutationBuilder> requirement) {
            this.a = a;
            this.b = b;
            this.result = result;
            this.chance = chance;
            this.requirement = requirement;
        }
    }

    public static class VanillaEntry
    implements SpeciesEntry {
        final String name;

        public VanillaEntry(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof VanillaEntry)) {
                return false;
            }
            VanillaEntry that = (VanillaEntry)o;
            return this.name != null ? this.name.equals(that.name) : that.name == null;
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }

        @Nonnull
        public String toString() {
            return "VanillaEntry{name='" + this.name + '\'' + '}';
        }

        @Override
        public boolean isVanilla() {
            return true;
        }

        @Override
        public IAlleleBeeSpecies get() {
            return (IAlleleBeeSpecies)Validate.notNull((Object)((IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele(this.name)));
        }
    }

    public static interface SpeciesEntry
    extends Supplier<IAlleleBeeSpecies> {
        public boolean isVanilla();
    }
}

