/*
 * Decompiled with CFR 0.152.
 */
package com.kjmaster.kjlib.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootingEnchantBonus;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class LootUtils {
    public static void removeLootFromTable(LootTable table, Item toRemove) {
        List pools = (List)ReflectionHelper.getPrivateValue(LootTable.class, (Object)table, (String[])new String[]{"pools", "field_186466_c"});
        block0: for (LootPool pool : pools) {
            List entries = (List)ReflectionHelper.getPrivateValue(LootPool.class, (Object)pool, (String[])new String[]{"lootEntries", "field_186453_a"});
            Iterator it = entries.iterator();
            while (it.hasNext()) {
                LootEntry entry = (LootEntry)it.next();
                if (!(entry instanceof LootEntryItem)) continue;
                LootEntryItem lei = (LootEntryItem)entry;
                Item i = (Item)ReflectionHelper.getPrivateValue(LootEntryItem.class, (Object)lei, (String[])new String[]{"item", "field_186368_a"});
                if (i != toRemove) continue;
                it.remove();
                continue block0;
            }
        }
    }

    public static void addItemToTable(LootTable table, Item item, int weight, float numRolls, float probability, int minQuantity, int maxQuantity, float minLootBonus, float maxLootBonus, String name) {
        LootUtils.addItemToTable(table, item, 0, 0, weight, numRolls, probability, minQuantity, maxQuantity, minLootBonus, maxLootBonus, name);
    }

    public static void addItemToTable(LootTable table, Item item, int weight, float numRolls, float probability, int minQuantity, int maxQuantity, float minLootBonus, float maxLootBonus, String name, IMethod LootCallbacks, ICondition LootConditions) {
        LootUtils.addItemToTable(table, item, 0, 0, weight, numRolls, probability, minQuantity, maxQuantity, minLootBonus, maxLootBonus, name, LootCallbacks, LootConditions);
    }

    public static void addItemToTable(LootTable table, Item item, int weight, float numRolls, float probability, int minQuantity, int maxQuantity, float minLootBonus, float maxLootBonus, String name, IMethod LootCallbacks) {
        LootUtils.addItemToTable(table, item, 0, 0, weight, numRolls, probability, minQuantity, maxQuantity, minLootBonus, maxLootBonus, name, LootCallbacks, new ICondition(){

            @Override
            public void FunctionsCallback(ArrayList<LootCondition> lootconds) {
            }
        });
    }

    public static void addItemToTable(LootTable table, Item item, int weight, float numRolls, float probability, int minQuantity, int maxQuantity, float minLootBonus, float maxLootBonus, String name, ICondition LootConditions) {
        LootUtils.addItemToTable(table, item, 0, 0, weight, numRolls, probability, minQuantity, maxQuantity, minLootBonus, maxLootBonus, name, new IMethod(){

            @Override
            public void FunctionsCallback(ArrayList<LootFunction> lootfuncs) {
            }
        }, LootConditions);
    }

    public static void addItemToTable(LootTable table, Item item, int minMeta, int maxMeta, int weight, float numRolls, float probability, int minQuantity, int maxQuantity, float minLootBonus, float maxLootBonus, String name) {
        LootUtils.addItemToTable(table, item, 0, 0, weight, numRolls, probability, minQuantity, maxQuantity, minLootBonus, maxLootBonus, name, new IMethod(){

            @Override
            public void FunctionsCallback(ArrayList<LootFunction> lootfuncs) {
            }
        }, new ICondition(){

            @Override
            public void FunctionsCallback(ArrayList<LootCondition> lootconds) {
            }
        });
    }

    public static void addItemToTable(LootTable table, Item item, int minMeta, int maxMeta, int weight, float numRolls, float probability, int minQuantity, int maxQuantity, float minLootBonus, float maxLootBonus, String name, IMethod LootCallbacks, ICondition LootConditions) {
        ArrayList<LootCondition> _conditions = new ArrayList<LootCondition>();
        _conditions.add((LootCondition)new RandomChance(probability));
        LootConditions.FunctionsCallback(_conditions);
        LootCondition[] lchance = _conditions.toArray(new LootCondition[0]);
        ArrayList<LootFunction> _functions = new ArrayList<LootFunction>();
        _functions.add((LootFunction)new SetCount(lchance, new RandomValueRange((float)minQuantity, (float)maxQuantity)));
        _functions.add((LootFunction)new LootingEnchantBonus(new LootCondition[0], new RandomValueRange(minLootBonus, maxLootBonus), 0));
        _functions.add((LootFunction)new SetMetadata(new LootCondition[0], new RandomValueRange((float)minMeta, (float)maxMeta)));
        LootCallbacks.FunctionsCallback(_functions);
        LootFunction[] lcount = _functions.toArray(new LootFunction[0]);
        LootEntryItem[] leitem = new LootEntryItem[]{new LootEntryItem(item, weight, 1, lcount, lchance, name)};
        LootPool newPool = LootUtils.createLootPool(leitem, lcount, lchance, new RandomValueRange(numRolls), new RandomValueRange(0.0f), name);
        LootUtils.addItemToTable(table, newPool);
    }

    public static LootPool createLootPool(LootEntryItem[] leitem, LootFunction[] lcount, LootCondition[] lchance, RandomValueRange numRolls, RandomValueRange bonusRolls, String name) {
        return new LootPool((LootEntry[])leitem, lchance, numRolls, bonusRolls, name);
    }

    public static void addItemToTable(LootTable table, LootPool pool) {
        table.addPool(pool);
    }

    public static interface ICondition {
        public void FunctionsCallback(ArrayList<LootCondition> var1);
    }

    public static interface IMethod {
        public void FunctionsCallback(ArrayList<LootFunction> var1);
    }
}

