/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawersextra.client.model;

import com.google.common.collect.ImmutableList;
import com.jaquadro.minecraft.chameleon.Chameleon;
import com.jaquadro.minecraft.chameleon.model.CachedBuilderModel;
import com.jaquadro.minecraft.chameleon.model.ChamModel;
import com.jaquadro.minecraft.chameleon.model.ProxyBuilderModel;
import com.jaquadro.minecraft.chameleon.render.ChamRender;
import com.jaquadro.minecraft.chameleon.resources.register.DefaultRegister;
import com.jaquadro.minecraft.storagedrawers.api.storage.EnumBasicDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGeometry;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.block.modeldata.DrawerStateModelData;
import com.jaquadro.minecraft.storagedrawers.client.model.component.DrawerDecoratorModel;
import com.jaquadro.minecraft.storagedrawersextra.StorageDrawersExtra;
import com.jaquadro.minecraft.storagedrawersextra.block.BlockExtraDrawers;
import com.jaquadro.minecraft.storagedrawersextra.block.EnumMod;
import com.jaquadro.minecraft.storagedrawersextra.block.EnumVariant;
import com.jaquadro.minecraft.storagedrawersextra.client.model.SimpleDrawerRender;
import com.jaquadro.minecraft.storagedrawersextra.client.model.TextureFace;
import com.jaquadro.minecraft.storagedrawersextra.config.ConfigManagerExt;
import com.jaquadro.minecraft.storagedrawersextra.core.ModBlocks;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;

public class ExtraDrawerModel
extends ChamModel {
    private static final ItemHandler itemHandler = new ItemHandler();

    public static IBakedModel fromBlock(IBlockState state) {
        if (!(state instanceof IExtendedBlockState)) {
            return new ExtraDrawerModel(state, false, EnumVariant.DEFAULT);
        }
        IExtendedBlockState xstate = (IExtendedBlockState)state;
        return new ExtraDrawerModel(state, false, (EnumVariant)((Object)xstate.getValue(BlockExtraDrawers.VARIANT)));
    }

    public static IBakedModel fromItem(@Nonnull ItemStack stack) {
        IBlockState state = ModBlocks.extraDrawers.func_176203_a(stack.func_77960_j());
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("material")) {
            return new ExtraDrawerModel(state, true, EnumVariant.DEFAULT);
        }
        return new ExtraDrawerModel(state, true, EnumVariant.byResource(stack.func_77978_p().func_74779_i("material")));
    }

    private ExtraDrawerModel(IBlockState state, boolean mergeLayers, EnumVariant variant) {
        super(state, mergeLayers, new Object[]{variant});
    }

    protected void renderMippedLayer(ChamRender renderer, IBlockState state, Object ... args) {
        EnumVariant varient = (EnumVariant)((Object)args[0]);
        SimpleDrawerRender drawerRender = new SimpleDrawerRender(renderer);
        drawerRender.render(null, state, BlockPos.field_177992_a, (EnumFacing)state.func_177229_b((IProperty)BlockDrawers.FACING), varient);
    }

    public TextureAtlasSprite func_177554_e() {
        IBlockState state = this.getState();
        if (!(state instanceof IExtendedBlockState)) {
            return Chameleon.instance.iconRegistry.getIcon(TextureMap.field_174945_f);
        }
        IExtendedBlockState xstate = (IExtendedBlockState)state;
        EnumVariant variant = (EnumVariant)((Object)xstate.getValue(BlockExtraDrawers.VARIANT));
        return Chameleon.instance.iconRegistry.getIcon(TextureFace.SIDE.getLocation(variant));
    }

    private static class ItemHandler
    extends ItemOverrideList {
        public ItemHandler() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, @Nonnull ItemStack stack, World world, EntityLivingBase entity) {
            return ExtraDrawerModel.fromItem(stack);
        }
    }

    private static class Model
    extends ProxyBuilderModel {
        public Model() {
            super(Chameleon.instance.iconRegistry.getIcon(new ResourceLocation("storagedrawers", "blocks/base/base_default")));
        }

        protected IBakedModel buildModel(IBlockState state, IBakedModel parent) {
            IBakedModel mainModel = ExtraDrawerModel.fromBlock(state);
            if (!(state instanceof IExtendedBlockState)) {
                return mainModel;
            }
            IExtendedBlockState xstate = (IExtendedBlockState)state;
            DrawerStateModelData stateModel = (DrawerStateModelData)xstate.getValue(BlockDrawers.STATE_MODEL);
            try {
                if (!DrawerDecoratorModel.shouldHandleState((DrawerStateModelData)stateModel)) {
                    return mainModel;
                }
                EnumBasicDrawer drawer = (EnumBasicDrawer)state.func_177229_b((IProperty)BlockStandardDrawers.BLOCK);
                EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)BlockDrawers.FACING);
                return new DrawerDecoratorModel(mainModel, xstate, (IDrawerGeometry)drawer, dir, stateModel);
            }
            catch (Throwable t) {
                try {
                    return mainModel;
                }
                catch (Throwable t2) {
                    return parent;
                }
            }
        }

        public ItemOverrideList func_188617_f() {
            return itemHandler;
        }

        public List<Object> getKey(IBlockState state) {
            try {
                ArrayList<Object> key = new ArrayList<Object>();
                IExtendedBlockState xstate = (IExtendedBlockState)state;
                key.add(xstate.getValue(BlockDrawers.STATE_MODEL));
                key.add(xstate.getValue(BlockExtraDrawers.VARIANT));
                return key;
            }
            catch (Throwable t) {
                return super.getKey(state);
            }
        }
    }

    public static class Register
    extends DefaultRegister {
        public Register() {
            super((Block)ModBlocks.extraDrawers);
        }

        public List<IBlockState> getBlockStates() {
            ArrayList<IBlockState> states = new ArrayList<IBlockState>();
            for (EnumBasicDrawer drawer : EnumBasicDrawer.values()) {
                for (EnumFacing dir : EnumFacing.field_176754_o) {
                    states.add(ModBlocks.extraDrawers.func_176223_P().func_177226_a((IProperty)BlockStandardDrawers.BLOCK, (Comparable)drawer).func_177226_a((IProperty)BlockDrawers.FACING, (Comparable)dir));
                }
            }
            return states;
        }

        public IBakedModel getModel(IBlockState state, IBakedModel existingModel) {
            return new CachedBuilderModel((ProxyBuilderModel)new Model());
        }

        public IBakedModel getModel(ItemStack stack, IBakedModel existingModel) {
            return new Model();
        }

        public List<ResourceLocation> getTextureResources() {
            ConfigManagerExt configExt = StorageDrawersExtra.config;
            ArrayList<ResourceLocation> resources = new ArrayList<ResourceLocation>();
            for (EnumVariant variant : EnumVariant.values()) {
                EnumMod mod;
                if (variant == EnumVariant.DEFAULT || (mod = variant.getMod()) == null || !mod.isEnabled(configExt.getModToggleState(mod))) continue;
                for (TextureFace face : TextureFace.values()) {
                    resources.add(face.getLocation(variant));
                }
            }
            return resources;
        }
    }
}

