/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.model;

import ic2.core.model.BasicBakedBlockModel;
import ic2.core.util.Util;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;

public class VdUtil {
    public static final int quadVertexCount = 4;
    public static final VertexFormat vertexFormat = DefaultVertexFormats.field_176599_b;
    public static final int dataStride = vertexFormat.func_177338_f() / 4;
    private static final int[] faceShades = VdUtil.getFaceShades();

    public static IntBuffer getQuadBuffer() {
        return IntBuffer.allocate(4 * dataStride);
    }

    public static void addCuboid(float xS, float yS, float zS, float xE, float yE, float zE, Set<EnumFacing> faces, TextureAtlasSprite sprite, List<BakedQuad>[] faceQuads, List<BakedQuad> generalQuads) {
        float spriteU = sprite.func_94209_e();
        float spriteV = sprite.func_94206_g();
        VdUtil.addCuboid(xS, yS, zS, xE, yE, zE, spriteU, spriteV, sprite.func_94212_f() - spriteU, sprite.func_94210_h() - spriteV, faces, sprite, faceQuads, generalQuads);
    }

    public static void addCuboid(float xS, float yS, float zS, float xE, float yE, float zE, int color, Set<EnumFacing> faces, TextureAtlasSprite sprite, List<BakedQuad>[] faceQuads, List<BakedQuad> generalQuads) {
        float spriteU = sprite.func_94209_e();
        float spriteV = sprite.func_94206_g();
        VdUtil.addCuboid(xS, yS, zS, xE, yE, zE, color, spriteU, spriteV, sprite.func_94212_f() - spriteU, sprite.func_94210_h() - spriteV, faces, sprite, faceQuads, generalQuads);
    }

    public static void addFlippedCuboid(float xS, float yS, float zS, float xE, float yE, float zE, Set<EnumFacing> faces, TextureAtlasSprite sprite, List<BakedQuad>[] faceQuads, List<BakedQuad> generalQuads) {
        float spriteU = sprite.func_94212_f();
        float spriteV = sprite.func_94210_h();
        VdUtil.addCuboid(xS, yS, zS, xE, yE, zE, spriteU, spriteV, sprite.func_94209_e() - spriteU, sprite.func_94206_g() - spriteV, faces, sprite, faceQuads, generalQuads);
    }

    public static void addFlippedCuboid(float xS, float yS, float zS, float xE, float yE, float zE, int colour, Set<EnumFacing> faces, TextureAtlasSprite sprite, List<BakedQuad>[] faceQuads, List<BakedQuad> generalQuads) {
        float spriteU = sprite.func_94212_f();
        float spriteV = sprite.func_94210_h();
        VdUtil.addCuboid(xS, yS, zS, xE, yE, zE, colour, spriteU, spriteV, sprite.func_94209_e() - spriteU, sprite.func_94206_g() - spriteV, faces, sprite, faceQuads, generalQuads);
    }

    public static void addFlippedCuboidWithYOffset(float xS, float yS, float zS, float xE, float yE, float zE, int colour, Set<EnumFacing> faces, TextureAtlasSprite sprite, List<BakedQuad>[] faceQuads, List<BakedQuad> generalQuads, float offset) {
        float spriteU = sprite.func_94212_f();
        float spriteV = sprite.func_94210_h();
        VdUtil.addCuboidWithYOffset(xS, yS, zS, xE, yE, zE, colour, spriteU, spriteV, sprite.func_94209_e() - spriteU, sprite.func_94206_g() - spriteV, faces, sprite, faceQuads, generalQuads, offset);
    }

    private static void addCuboid(float xS, float yS, float zS, float xE, float yE, float zE, float spriteU, float spriteV, float spriteWidth, float spriteHeight, Set<EnumFacing> faces, TextureAtlasSprite sprite, List<BakedQuad>[] faceQuads, List<BakedQuad> generalQuads) {
        IntBuffer quadBuffer = VdUtil.getQuadBuffer();
        block8: for (EnumFacing facing : faces) {
            boolean isFace;
            switch (facing) {
                case DOWN: {
                    if (xS == xE || zS == zE) continue block8;
                    VdUtil.generateBlockVertex(xS, yS, zS, spriteU + spriteWidth * xS, spriteV + spriteHeight * zS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS, zS, spriteU + spriteWidth * xE, spriteV + spriteHeight * zS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS, zE, spriteU + spriteWidth * xE, spriteV + spriteHeight * zE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yS, zE, spriteU + spriteWidth * xS, spriteV + spriteHeight * zE, facing, quadBuffer);
                    isFace = yS == 0.0f;
                    break;
                }
                case UP: {
                    if (xS == xE || zS == zE) continue block8;
                    VdUtil.generateBlockVertex(xS, yE, zS, spriteU + spriteWidth * xS, spriteV + spriteHeight * zS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE, zE, spriteU + spriteWidth * xS, spriteV + spriteHeight * zE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zE, spriteU + spriteWidth * xE, spriteV + spriteHeight * zE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zS, spriteU + spriteWidth * xE, spriteV + spriteHeight * zS, facing, quadBuffer);
                    isFace = yE == 1.0f;
                    break;
                }
                case NORTH: {
                    if (xS == xE || yS == yE) continue block8;
                    VdUtil.generateBlockVertex(xS, yS, zS, spriteU + spriteWidth * xS, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE, zS, spriteU + spriteWidth * xS, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zS, spriteU + spriteWidth * xE, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS, zS, spriteU + spriteWidth * xE, spriteV + spriteHeight * yS, facing, quadBuffer);
                    isFace = zS == 0.0f;
                    break;
                }
                case SOUTH: {
                    if (xS == xE || yS == yE) continue block8;
                    VdUtil.generateBlockVertex(xS, yS, zE, spriteU + spriteWidth * xS, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS, zE, spriteU + spriteWidth * xE, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zE, spriteU + spriteWidth * xE, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE, zE, spriteU + spriteWidth * xS, spriteV + spriteHeight * yE, facing, quadBuffer);
                    isFace = zE == 1.0f;
                    break;
                }
                case WEST: {
                    if (yS == yE || zS == zE) continue block8;
                    VdUtil.generateBlockVertex(xS, yS, zS, spriteU + spriteWidth * zS, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yS, zE, spriteU + spriteWidth * zE, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE, zE, spriteU + spriteWidth * zE, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE, zS, spriteU + spriteWidth * zS, spriteV + spriteHeight * yE, facing, quadBuffer);
                    isFace = xS == 0.0f;
                    break;
                }
                case EAST: {
                    if (yS == yE || zS == zE) continue block8;
                    VdUtil.generateBlockVertex(xE, yS, zS, spriteU + spriteWidth * zS, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zS, spriteU + spriteWidth * zS, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zE, spriteU + spriteWidth * zE, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS, zE, spriteU + spriteWidth * zE, spriteV + spriteHeight * yS, facing, quadBuffer);
                    isFace = xE == 1.0f;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected facing: " + facing);
                }
            }
            if (quadBuffer.position() <= 0) continue;
            BakedQuad quad = BasicBakedBlockModel.createQuad(Arrays.copyOf(quadBuffer.array(), quadBuffer.position()), facing, sprite);
            if (isFace) {
                faceQuads[facing.ordinal()].add(quad);
            } else {
                generalQuads.add(quad);
            }
            quadBuffer.rewind();
        }
    }

    private static void addCuboid(float xS, float yS, float zS, float xE, float yE, float zE, int color, float spriteU, float spriteV, float spriteWidth, float spriteHeight, Set<EnumFacing> faces, TextureAtlasSprite sprite, List<BakedQuad>[] faceQuads, List<BakedQuad> generalQuads) {
        IntBuffer quadBuffer = VdUtil.getQuadBuffer();
        block8: for (EnumFacing facing : faces) {
            boolean isFace;
            switch (facing) {
                case DOWN: {
                    if (xS == xE || zS == zE) continue block8;
                    VdUtil.generateBlockVertex(xS, yS, zS, color, spriteU + spriteWidth * xS, spriteV + spriteHeight * zS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS, zS, color, spriteU + spriteWidth * xE, spriteV + spriteHeight * zS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS, zE, color, spriteU + spriteWidth * xE, spriteV + spriteHeight * zE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yS, zE, color, spriteU + spriteWidth * xS, spriteV + spriteHeight * zE, facing, quadBuffer);
                    isFace = yS == 0.0f;
                    break;
                }
                case UP: {
                    if (xS == xE || zS == zE) continue block8;
                    VdUtil.generateBlockVertex(xS, yE, zS, color, spriteU + spriteWidth * xS, spriteV + spriteHeight * zS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE, zE, color, spriteU + spriteWidth * xS, spriteV + spriteHeight * zE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zE, color, spriteU + spriteWidth * xE, spriteV + spriteHeight * zE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zS, color, spriteU + spriteWidth * xE, spriteV + spriteHeight * zS, facing, quadBuffer);
                    isFace = yE == 1.0f;
                    break;
                }
                case NORTH: {
                    if (xS == xE || yS == yE) continue block8;
                    VdUtil.generateBlockVertex(xS, yS, zS, color, spriteU + spriteWidth * xS, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE, zS, color, spriteU + spriteWidth * xS, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zS, color, spriteU + spriteWidth * xE, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS, zS, color, spriteU + spriteWidth * xE, spriteV + spriteHeight * yS, facing, quadBuffer);
                    isFace = zS == 0.0f;
                    break;
                }
                case SOUTH: {
                    if (xS == xE || yS == yE) continue block8;
                    VdUtil.generateBlockVertex(xS, yS, zE, color, spriteU + spriteWidth * xS, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS, zE, color, spriteU + spriteWidth * xE, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zE, color, spriteU + spriteWidth * xE, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE, zE, color, spriteU + spriteWidth * xS, spriteV + spriteHeight * yE, facing, quadBuffer);
                    isFace = zE == 1.0f;
                    break;
                }
                case WEST: {
                    if (yS == yE || zS == zE) continue block8;
                    VdUtil.generateBlockVertex(xS, yS, zS, color, spriteU + spriteWidth * zS, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yS, zE, color, spriteU + spriteWidth * zE, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE, zE, color, spriteU + spriteWidth * zE, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE, zS, color, spriteU + spriteWidth * zS, spriteV + spriteHeight * yE, facing, quadBuffer);
                    isFace = xS == 0.0f;
                    break;
                }
                case EAST: {
                    if (yS == yE || zS == zE) continue block8;
                    VdUtil.generateBlockVertex(xE, yS, zS, color, spriteU + spriteWidth * zS, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zS, color, spriteU + spriteWidth * zS, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zE, color, spriteU + spriteWidth * zE, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS, zE, color, spriteU + spriteWidth * zE, spriteV + spriteHeight * yS, facing, quadBuffer);
                    isFace = xE == 1.0f;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected facing: " + facing);
                }
            }
            if (quadBuffer.position() <= 0) continue;
            BakedQuad quad = BasicBakedBlockModel.createQuad(Arrays.copyOf(quadBuffer.array(), quadBuffer.position()), facing, sprite);
            if (isFace) {
                faceQuads[facing.ordinal()].add(quad);
            } else {
                generalQuads.add(quad);
            }
            quadBuffer.rewind();
        }
    }

    private static void addCuboidWithYOffset(float xS, float yS, float zS, float xE, float yE, float zE, int color, float spriteU, float spriteV, float spriteWidth, float spriteHeight, Set<EnumFacing> faces, TextureAtlasSprite sprite, List<BakedQuad>[] faceQuads, List<BakedQuad> generalQuads, float offset) {
        IntBuffer quadBuffer = VdUtil.getQuadBuffer();
        block8: for (EnumFacing facing : faces) {
            boolean isFace;
            switch (facing) {
                case DOWN: {
                    if (xS == xE || zS == zE) continue block8;
                    VdUtil.generateBlockVertex(xS, yS + offset, zS, color, spriteU + spriteWidth * xS, spriteV + spriteHeight * zS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS + offset, zS, color, spriteU + spriteWidth * xE, spriteV + spriteHeight * zS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS + offset, zE, color, spriteU + spriteWidth * xE, spriteV + spriteHeight * zE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yS + offset, zE, color, spriteU + spriteWidth * xS, spriteV + spriteHeight * zE, facing, quadBuffer);
                    isFace = yS == 0.0f;
                    break;
                }
                case UP: {
                    if (xS == xE || zS == zE) continue block8;
                    VdUtil.generateBlockVertex(xS, yE + offset, zS, color, spriteU + spriteWidth * xS, spriteV + spriteHeight * zS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE + offset, zE, color, spriteU + spriteWidth * xS, spriteV + spriteHeight * zE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE + offset, zE, color, spriteU + spriteWidth * xE, spriteV + spriteHeight * zE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE + offset, zS, color, spriteU + spriteWidth * xE, spriteV + spriteHeight * zS, facing, quadBuffer);
                    isFace = yE == 1.0f;
                    break;
                }
                case NORTH: {
                    if (xS == xE || yS == yE) continue block8;
                    VdUtil.generateBlockVertex(xS, yS + offset, zS, color, spriteU + spriteWidth * xS, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE + offset, zS, color, spriteU + spriteWidth * xS, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE + offset, zS, color, spriteU + spriteWidth * xE, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS + offset, zS, color, spriteU + spriteWidth * xE, spriteV + spriteHeight * yS, facing, quadBuffer);
                    isFace = zS == 0.0f;
                    break;
                }
                case SOUTH: {
                    if (xS == xE || yS == yE) continue block8;
                    VdUtil.generateBlockVertex(xS, yS + offset, zE, color, spriteU + spriteWidth * xS, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS + offset, zE, color, spriteU + spriteWidth * xE, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE + offset, zE, color, spriteU + spriteWidth * xE, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE + offset, zE, color, spriteU + spriteWidth * xS, spriteV + spriteHeight * yE, facing, quadBuffer);
                    isFace = zE == 1.0f;
                    break;
                }
                case WEST: {
                    if (yS == yE || zS == zE) continue block8;
                    VdUtil.generateBlockVertex(xS, yS + offset, zS, color, spriteU + spriteWidth * zS, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yS + offset, zE, color, spriteU + spriteWidth * zE, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE + offset, zE, color, spriteU + spriteWidth * zE, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE + offset, zS, color, spriteU + spriteWidth * zS, spriteV + spriteHeight * yE, facing, quadBuffer);
                    isFace = xS == 0.0f;
                    break;
                }
                case EAST: {
                    if (yS == yE || zS == zE) continue block8;
                    VdUtil.generateBlockVertex(xE, yS + offset, zS, color, spriteU + spriteWidth * zS, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE + offset, zS, color, spriteU + spriteWidth * zS, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE + offset, zE, color, spriteU + spriteWidth * zE, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS + offset, zE, color, spriteU + spriteWidth * zE, spriteV + spriteHeight * yS, facing, quadBuffer);
                    isFace = xE == 1.0f;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected facing: " + facing);
                }
            }
            if (quadBuffer.position() <= 0) continue;
            BakedQuad quad = BasicBakedBlockModel.createQuad(Arrays.copyOf(quadBuffer.array(), quadBuffer.position()), facing, sprite);
            if (isFace) {
                faceQuads[facing.ordinal()].add(quad);
            } else {
                generalQuads.add(quad);
            }
            quadBuffer.rewind();
        }
    }

    public static void generateVertex(float x, float y, float z, int color, float u, float v, EnumFacing facing, IntBuffer out) {
        VdUtil.generateVertex(x, y, z, color, u, v, facing.func_82601_c(), facing.func_96559_d(), facing.func_82599_e(), out);
    }

    public static void generateVertex(float x, float y, float z, int color, float u, float v, float nx, float ny, float nz, IntBuffer out) {
        out.put(Float.floatToRawIntBits(x));
        out.put(Float.floatToRawIntBits(y));
        out.put(Float.floatToRawIntBits(z));
        out.put(color);
        out.put(Float.floatToRawIntBits(u));
        out.put(Float.floatToRawIntBits(v));
        out.put(VdUtil.packNormals(nx, ny, nz));
    }

    public static void generateBlockVertex(float x, float y, float z, int color, float u, float v, EnumFacing facing, IntBuffer out) {
        VdUtil.generateVertex(x, y, z, color, u, v, facing.func_82601_c(), facing.func_96559_d(), facing.func_82599_e(), out);
    }

    public static void generateBlockVertex(float x, float y, float z, float u, float v, EnumFacing facing, IntBuffer out) {
        VdUtil.generateVertex(x, y, z, faceShades[facing.ordinal()], u, v, facing.func_82601_c(), facing.func_96559_d(), facing.func_82599_e(), out);
    }

    private static int packNormals(float nx, float ny, float nz) {
        return VdUtil.mapFloatToByte(nx) | VdUtil.mapFloatToByte(ny) << 8 | VdUtil.mapFloatToByte(nz) << 16;
    }

    private static int mapFloatToByte(float f) {
        assert (f >= -1.0f && f <= 1.0f);
        return Math.round(f * 127.0f) & 0xFF;
    }

    private static int[] getFaceShades() {
        int[] ret = new int[EnumFacing.field_82609_l.length];
        double[] faceBrightness = new double[]{0.5, 1.0, 0.8, 0.8, 0.6, 0.6};
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            int brightness = Util.limit((int)(faceBrightness[facing.ordinal()] * 255.0), 0, 255);
            ret[facing.ordinal()] = 0xFF000000 | brightness << 16 | brightness << 8 | brightness;
        }
        return ret;
    }
}

