/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.block;

import erogenousbeef.bigreactors.common.Properties;
import erogenousbeef.bigreactors.common.multiblock.MultiblockTurbine;
import erogenousbeef.bigreactors.common.multiblock.PartType;
import erogenousbeef.bigreactors.common.multiblock.RotorShaftState;
import erogenousbeef.bigreactors.common.multiblock.block.BlockPart;
import erogenousbeef.bigreactors.common.multiblock.block.ITurbineRotorPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbineRotorShaft;
import erogenousbeef.bigreactors.init.BrBlocks;
import it.zerono.mods.zerocore.api.multiblock.MultiblockTileEntityBase;
import java.util.EnumSet;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockTurbineRotorShaft
extends BlockPart
implements ITurbineRotorPart {
    private IBlockState[] _neighbors;
    private static final RotorShaftState[][] ROTOR_STATE_MAP = new RotorShaftState[3][5];

    public BlockTurbineRotorShaft(String blockName) {
        super(PartType.TurbineRotorShaft, blockName, Material.field_151573_f);
        this.func_149715_a(0.9f);
        this._neighbors = new IBlockState[EnumFacing.field_82609_l.length];
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityTurbineRotorShaft();
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_176214_u(IBlockState state) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public int getMass(IBlockState blockState) {
        return 10;
    }

    @Override
    public boolean isShaft() {
        return true;
    }

    @Override
    public boolean isBlade() {
        return false;
    }

    protected void buildBlockState(BlockStateContainer.Builder builder) {
        super.buildBlockState(builder);
        builder.add(new IProperty[]{Properties.ROTORSHAFTSTATE});
    }

    protected IBlockState buildDefaultState(IBlockState state) {
        return super.buildDefaultState(state).func_177226_a(Properties.ROTORSHAFTSTATE, (Comparable)((Object)RotorShaftState.Y_NOBLADES));
    }

    @Override
    protected IBlockState buildActualState(IBlockState state, IBlockAccess world, BlockPos position, MultiblockTileEntityBase part) {
        return this.buildActualStateInternal(state, world, position, part, false);
    }

    public IBlockState buildActualStateInternal(IBlockState state, IBlockAccess world, BlockPos position, MultiblockTileEntityBase part, boolean buildingClientRotor) {
        MultiblockTurbine turbine;
        MultiblockTurbine multiblockTurbine = turbine = part.isConnected() ? (MultiblockTurbine)part.getMultiblockController() : null;
        if (!buildingClientRotor && null != turbine && turbine.isAssembledAndActive()) {
            return super.buildActualState(state, world, position, part).func_177226_a(Properties.ROTORSHAFTSTATE, (Comparable)((Object)RotorShaftState.HIDDEN));
        }
        EnumFacing.Axis rotorAxis = EnumFacing.Axis.Y;
        int neighborsSlotCount = this._neighbors.length;
        for (int i = 0; i < neighborsSlotCount; ++i) {
            this._neighbors[i] = null;
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            IBlockState neighbor;
            this._neighbors[facing.func_176745_a()] = neighbor = world.func_180495_p(position.func_177972_a(facing));
            if (this != neighbor.func_177230_c()) continue;
            rotorAxis = facing.func_176740_k();
            break;
        }
        EnumFacing.AxisDirection[] directions = EnumFacing.AxisDirection.values();
        EnumSet<EnumFacing.Axis> candidateBladeAxis = EnumSet.allOf(EnumFacing.Axis.class);
        candidateBladeAxis.remove(rotorAxis);
        EnumSet<EnumFacing.Axis> bladeAxis = EnumSet.copyOf(candidateBladeAxis);
        block2: for (EnumFacing.Axis axis : candidateBladeAxis) {
            for (EnumFacing.AxisDirection direction : directions) {
                EnumFacing facing = EnumFacing.func_181076_a((EnumFacing.AxisDirection)direction, (EnumFacing.Axis)axis);
                int index = facing.func_176745_a();
                IBlockState neighbor = this._neighbors[index];
                if (null == neighbor) {
                    neighbor = world.func_180495_p(position.func_177972_a(facing));
                }
                if (BrBlocks.turbineRotorBlade == neighbor.func_177230_c()) continue;
                bladeAxis.remove(axis);
                continue block2;
            }
        }
        RotorShaftState rotorState = this.getStateFromBladePosition(rotorAxis, bladeAxis);
        return super.buildActualState(state, world, position, part).func_177226_a(Properties.ROTORSHAFTSTATE, (Comparable)((Object)rotorState));
    }

    private RotorShaftState getStateFromBladePosition(EnumFacing.Axis rotorAxis, EnumSet<EnumFacing.Axis> bladeAxis) {
        int count = bladeAxis.size();
        RotorShaftState[] states = ROTOR_STATE_MAP[rotorAxis.ordinal()];
        RotorShaftState result = RotorShaftState.Y_NOBLADES;
        block0 : switch (count) {
            case 0: {
                result = states[3];
                break;
            }
            case 1: {
                for (EnumFacing.Axis axis : bladeAxis) {
                    if (!bladeAxis.contains(axis)) continue;
                    result = states[axis.ordinal()];
                    break block0;
                }
                break;
            }
            case 2: {
                result = states[4];
            }
        }
        return result;
    }

    static {
        int xIndex = EnumFacing.Axis.X.ordinal();
        int yIndex = EnumFacing.Axis.Y.ordinal();
        int zIndex = EnumFacing.Axis.Z.ordinal();
        RotorShaftState[] entry = ROTOR_STATE_MAP[xIndex];
        entry[xIndex] = null;
        entry[yIndex] = RotorShaftState.X_Y;
        entry[zIndex] = RotorShaftState.X_Z;
        entry[3] = RotorShaftState.X_NOBLADES;
        entry[4] = RotorShaftState.X_YZ;
        entry = ROTOR_STATE_MAP[yIndex];
        entry[xIndex] = RotorShaftState.Y_X;
        entry[yIndex] = null;
        entry[zIndex] = RotorShaftState.Y_Z;
        entry[3] = RotorShaftState.Y_NOBLADES;
        entry[4] = RotorShaftState.Y_XZ;
        entry = ROTOR_STATE_MAP[zIndex];
        entry[xIndex] = RotorShaftState.Z_X;
        entry[yIndex] = RotorShaftState.Z_Y;
        entry[zIndex] = null;
        entry[3] = RotorShaftState.Z_NOBLADES;
        entry[4] = RotorShaftState.Z_XY;
    }
}

