/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.network.fx;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.casters.FocusEffect;
import thaumcraft.api.casters.FocusEngine;
import thaumcraft.api.casters.IFocusElement;

public class PacketFXFocusEffect
implements IMessage,
IMessageHandler<PacketFXFocusEffect, IMessage> {
    float x;
    float y;
    float z;
    float mx;
    float my;
    float mz;
    String parts;

    public PacketFXFocusEffect() {
    }

    public PacketFXFocusEffect(float x, float y, float z, float mx, float my, float mz, String[] parts) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.mx = mx;
        this.my = my;
        this.mz = mz;
        this.parts = "";
        for (int a = 0; a < parts.length; ++a) {
            if (a > 0) {
                this.parts = this.parts + "%";
            }
            this.parts = this.parts + parts[a];
        }
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeFloat(this.x);
        buffer.writeFloat(this.y);
        buffer.writeFloat(this.z);
        buffer.writeFloat(this.mx);
        buffer.writeFloat(this.my);
        buffer.writeFloat(this.mz);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.parts);
    }

    public void fromBytes(ByteBuf buffer) {
        this.x = buffer.readFloat();
        this.y = buffer.readFloat();
        this.z = buffer.readFloat();
        this.mx = buffer.readFloat();
        this.my = buffer.readFloat();
        this.mz = buffer.readFloat();
        this.parts = ByteBufUtils.readUTF8String((ByteBuf)buffer);
    }

    public IMessage onMessage(final PacketFXFocusEffect message, MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a(new Runnable(){

            @Override
            public void run() {
                PacketFXFocusEffect.this.processMessage(message);
            }
        });
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    void processMessage(PacketFXFocusEffect message) {
        String[] partKeys = message.parts.split("%");
        int amt = Math.max(1, 10 / partKeys.length);
        for (String k : partKeys) {
            IFocusElement part = FocusEngine.getElement(k);
            if (part == null || !(part instanceof FocusEffect)) continue;
            for (int a = 0; a < amt; ++a) {
                ((FocusEffect)part).renderParticleFX((World)Minecraft.func_71410_x().field_71441_e, message.x, message.y, message.z, (double)message.mx + Minecraft.func_71410_x().field_71441_e.field_73012_v.nextGaussian() / 20.0, (double)message.my + Minecraft.func_71410_x().field_71441_e.field_73012_v.nextGaussian() / 20.0, (double)message.mz + Minecraft.func_71410_x().field_71441_e.field_73012_v.nextGaussian() / 20.0);
            }
        }
    }
}

