/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.pieces.chests;

import jaredbgreat.dldungeons.ConfigHandler;
import jaredbgreat.dldungeons.nbt.NBTHelper;
import jaredbgreat.dldungeons.nbt.tags.ITag;
import jaredbgreat.dldungeons.util.debug.Logging;
import jaredbgreat.dldungeons.util.parser.Tokenizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;

public class LootItem {
    private static IForgeRegistry ItemRegistry;
    private static Map<ItemPrototype, Integer> prototypes;
    Item item;
    int min;
    int max;
    int meta;
    int level;
    ArrayList<ITag> nbtData;
    public static LootItem stoneSword;
    public static LootItem ironSword;
    public static LootItem diamondSword;
    public static LootItem bow;
    public static LootItem fewArrows;
    public static LootItem someArrows;
    public static LootItem manyArrows;
    public static LootItem fewTorches;
    public static LootItem someToreches;
    public static LootItem manyTorches;
    public static LootItem leatherHat;
    public static LootItem goldHat;
    public static LootItem ironHat;
    public static LootItem diamondHat;
    public static LootItem leatherBoots;
    public static LootItem goldBoots;
    public static LootItem ironBoots;
    public static LootItem diamondBoots;
    public static LootItem leatherPants;
    public static LootItem goldPants;
    public static LootItem ironPants;
    public static LootItem diamondPants;
    public static LootItem leatherChest;
    public static LootItem goldChest;
    public static LootItem ironChest;
    public static LootItem diamondChest;
    public static LootItem someBread;
    public static LootItem moreBread;
    public static LootItem someSteak;
    public static LootItem moreSteak;
    public static LootItem someChicken;
    public static LootItem moreChicken;
    public static LootItem someApples;
    public static LootItem moreApples;
    public static LootItem somePie;
    public static LootItem morePie;
    public static LootItem goldApple;
    public static LootItem goldApples;
    public static LootItem oneGold;
    public static LootItem someGold;
    public static LootItem moreGold;
    public static LootItem someIron;
    public static LootItem moreIron;
    public static LootItem oneDiamond;
    public static LootItem diamonds;
    public static LootItem manyDiamonds;
    public static LootItem oneEmerald;
    public static LootItem emeralds;
    public static LootItem manyEmerald;
    public static LootItem saddle;
    public static LootItem ironBarding;
    public static LootItem goldBarding;
    public static LootItem diamondBard;
    public static LootItem book;
    public static LootItem someBooks;
    public static LootItem moreBooks;
    public static LootItem nameTag;
    public static LootItem enderpearl;
    public static LootItem enderpearls;
    public static LootItem eyeOfEnder;
    public static LootItem blazeRod;
    public static LootItem netherstar;
    public static LootItem disc13;
    public static LootItem discCat;
    public static LootItem discBlocks;
    public static LootItem discChirp;
    public static LootItem discFar;
    public static LootItem discMall;
    public static LootItem discMellohi;
    public static LootItem discStrad;
    public static LootItem discWard;
    public static LootItem disc11;
    public static LootItem discWait;

    public LootItem(String id, int min, int max, int level) {
        this.metaParse(id);
        if (min > max) {
            min = max;
        }
        this.min = min;
        this.max = max;
        this.level = level;
        if (this.item == null) {
            String error = "[DLDUNGEONS] ERROR! Item read as \"" + id + "\" was was not in registry (returned null).";
            Logging.logError(error);
            if (ConfigHandler.failfast) {
                throw new NoSuchElementException(error);
            }
        } else {
            this.fixLevel();
        }
    }

    public LootItem(Item item, int min, int max) {
        this.item = item;
        if (min > max) {
            min = max;
        }
        this.min = min;
        this.max = max;
        this.level = 6;
    }

    public LootItem(Block item, int min, int max) {
        this.item = Item.func_150898_a((Block)item);
        if (min > max) {
            min = max;
        }
        this.min = min;
        this.max = max;
        this.level = 6;
    }

    private void fixLevel() {
        if (this.max == 1) {
            ItemPrototype p = new ItemPrototype(this.item, this.meta);
            if (prototypes.containsKey(p)) {
                int l = prototypes.get(p);
                if (l < this.level) {
                    this.level = l;
                }
                if (l > this.level) {
                    prototypes.put(p, this.level);
                }
            } else {
                prototypes.put(p, this.level);
            }
        }
    }

    private void metaParse(String in) {
        Tokenizer tokens = new Tokenizer(in, "({[]})");
        String name = tokens.nextToken();
        this.item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(name));
        if (this.item == null) {
            Logging.logError("[DLDUNGEONS] ERROR! Item read as \"" + in + "\" was was not in registry (returned null).");
        }
        if (tokens.hasMoreTokens()) {
            this.meta = Integer.parseInt(tokens.nextToken());
        }
    }

    private static Item getItem(String in) {
        return (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(in));
    }

    public void addNbt(String in) {
        if (this.nbtData == null) {
            this.nbtData = new ArrayList();
        }
        this.nbtData.add(NBTHelper.getTagFromLabel(in));
    }

    public void trimNbt() {
        if (this.nbtData != null) {
            this.nbtData.trimToSize();
        }
    }

    public ItemStack getStack(Random random) {
        ItemStack out = this.max <= this.min ? (this.item instanceof Item ? new ItemStack(this.item, this.max) : new ItemStack(this.item, this.max)) : (this.item instanceof Item ? new ItemStack(this.item, random.nextInt(this.max - this.min) + this.min + 1) : new ItemStack(this.item, random.nextInt(this.max - this.min) + this.min + 1));
        if (out.func_77973_b() == null) {
            return null;
        }
        if (out.func_77981_g() && this.meta >= 0) {
            out.func_77964_b(this.meta);
        } else {
            out.func_77964_b(0);
        }
        if (this.nbtData != null && !this.nbtData.isEmpty()) {
            for (ITag tag : this.nbtData) {
                NBTHelper.setNbtTag(out, tag);
            }
        }
        return out;
    }

    static {
        prototypes = new HashMap<ItemPrototype, Integer>();
        stoneSword = new LootItem(LootItem.getItem("stone_sword"), 1, 1);
        ironSword = new LootItem(LootItem.getItem("iron_sword"), 1, 1);
        diamondSword = new LootItem(LootItem.getItem("diamond_sword"), 1, 1);
        bow = new LootItem(LootItem.getItem("bow"), 1, 1);
        fewArrows = new LootItem(LootItem.getItem("arrow"), 4, 12);
        someArrows = new LootItem(LootItem.getItem("arrow"), 8, 16);
        manyArrows = new LootItem(LootItem.getItem("arrow"), 16, 48);
        fewTorches = new LootItem(Block.func_149684_b((String)"torch"), 4, 12);
        someToreches = new LootItem(Block.func_149684_b((String)"torch"), 12, 16);
        manyTorches = new LootItem(Block.func_149684_b((String)"torch"), 16, 24);
        leatherHat = new LootItem(LootItem.getItem("leather_helmet"), 1, 1);
        goldHat = new LootItem(LootItem.getItem("golden_helmet"), 1, 1);
        ironHat = new LootItem(LootItem.getItem("iron_helmet"), 1, 1);
        diamondHat = new LootItem(LootItem.getItem("diamond_helmet"), 1, 1);
        leatherBoots = new LootItem(LootItem.getItem("leather_boots"), 1, 1);
        goldBoots = new LootItem(LootItem.getItem("golden_boots"), 1, 1);
        ironBoots = new LootItem(LootItem.getItem("iron_boots"), 1, 1);
        diamondBoots = new LootItem(LootItem.getItem("diamond_boots"), 1, 1);
        leatherPants = new LootItem(LootItem.getItem("leather_leggings"), 1, 1);
        goldPants = new LootItem(LootItem.getItem("golden_leggings"), 1, 1);
        ironPants = new LootItem(LootItem.getItem("iron_leggings"), 1, 1);
        diamondPants = new LootItem(LootItem.getItem("diamond_leggings"), 1, 1);
        leatherChest = new LootItem(LootItem.getItem("leather_chestplate"), 1, 1);
        goldChest = new LootItem(LootItem.getItem("golden_chestplate"), 1, 1);
        ironChest = new LootItem(LootItem.getItem("iron_chestplate"), 1, 1);
        diamondChest = new LootItem(LootItem.getItem("diamond_chestplate"), 1, 1);
        someBread = new LootItem(LootItem.getItem("bread"), 2, 4);
        moreBread = new LootItem(LootItem.getItem("bread"), 4, 8);
        someSteak = new LootItem(LootItem.getItem("cooked_beef"), 2, 4);
        moreSteak = new LootItem(LootItem.getItem("cooked_beef"), 4, 8);
        someChicken = new LootItem(LootItem.getItem("cooked_chicken"), 2, 4);
        moreChicken = new LootItem(LootItem.getItem("cooked_chicken"), 4, 8);
        someApples = new LootItem(LootItem.getItem("apple"), 1, 3);
        moreApples = new LootItem(LootItem.getItem("apple"), 2, 7);
        somePie = new LootItem(LootItem.getItem("pumpkin_pie"), 1, 3);
        morePie = new LootItem(LootItem.getItem("pumpkin_pie"), 2, 7);
        goldApple = new LootItem(LootItem.getItem("golden_apple"), 1, 1);
        goldApples = new LootItem(LootItem.getItem("golden_apple"), 1, 3);
        oneGold = new LootItem(LootItem.getItem("gold_ingot"), 1, 1);
        someGold = new LootItem(LootItem.getItem("gold_ingot"), 2, 5);
        moreGold = new LootItem(LootItem.getItem("gold_ingot"), 3, 8);
        someIron = new LootItem(LootItem.getItem("iron_ingot"), 1, 8);
        moreIron = new LootItem(LootItem.getItem("iron_ingot"), 3, 12);
        oneDiamond = new LootItem(LootItem.getItem("iron_ingot"), 1, 1);
        diamonds = new LootItem(LootItem.getItem("diamond"), 1, 4);
        manyDiamonds = new LootItem(LootItem.getItem("diamond"), 3, 9);
        oneEmerald = new LootItem(LootItem.getItem("emerald"), 1, 1);
        emeralds = new LootItem(LootItem.getItem("emerald"), 1, 4);
        manyEmerald = new LootItem(LootItem.getItem("emerald"), 3, 7);
        saddle = new LootItem(LootItem.getItem("saddle"), 1, 1);
        ironBarding = new LootItem(LootItem.getItem("iron_horse_armor"), 1, 1);
        goldBarding = new LootItem(LootItem.getItem("golden_horse_armor"), 1, 1);
        diamondBard = new LootItem(LootItem.getItem("diamond_horse_armor"), 1, 1);
        book = new LootItem(LootItem.getItem("book"), 1, 1);
        someBooks = new LootItem(LootItem.getItem("book"), 2, 5);
        moreBooks = new LootItem(LootItem.getItem("book"), 3, 8);
        nameTag = new LootItem(LootItem.getItem("name_tag"), 1, 1);
        enderpearl = new LootItem(LootItem.getItem("ender_pearl"), 1, 2);
        enderpearls = new LootItem(LootItem.getItem("ender_pearl"), 1, 9);
        eyeOfEnder = new LootItem(LootItem.getItem("ender_eye"), 1, 2);
        blazeRod = new LootItem(LootItem.getItem("blaze_rod"), 1, 2);
        netherstar = new LootItem(LootItem.getItem("nether_star"), 1, 1);
        disc13 = new LootItem(LootItem.getItem("record_13"), 1, 1);
        discCat = new LootItem(LootItem.getItem("record_cat"), 1, 1);
        discBlocks = new LootItem(LootItem.getItem("record_blocks"), 1, 1);
        discChirp = new LootItem(LootItem.getItem("stone_chirp"), 1, 1);
        discFar = new LootItem(LootItem.getItem("record_far"), 1, 1);
        discMall = new LootItem(LootItem.getItem("record_mall"), 1, 1);
        discMellohi = new LootItem(LootItem.getItem("record_mellohi"), 1, 1);
        discStrad = new LootItem(LootItem.getItem("record_strad"), 1, 1);
        discWard = new LootItem(LootItem.getItem("record_ward"), 1, 1);
        disc11 = new LootItem(LootItem.getItem("record_11"), 1, 1);
        discWait = new LootItem(LootItem.getItem("record_wait"), 1, 1);
    }

    private static class ItemPrototype {
        public final Item item;
        public final int meta;

        public ItemPrototype(Item i, int m) {
            this.item = i;
            this.meta = m;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ItemPrototype)) {
                return false;
            }
            ItemPrototype p = (ItemPrototype)obj;
            return p.item == this.item && p.meta == this.meta;
        }

        public int hashCode() {
            return this.item.hashCode() + this.meta * 102181;
        }
    }
}

