/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.builder;

import jaredbgreat.dldungeons.DoomlikeDungeons;
import jaredbgreat.dldungeons.api.DLDEvent;
import jaredbgreat.dldungeons.builder.RegisteredBlock;
import jaredbgreat.dldungeons.planner.Dungeon;
import jaredbgreat.dldungeons.util.cache.Coords;
import jaredbgreat.dldungeons.util.cache.WeakCache;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class Builder {
    private static final WeakCache<Dungeon> DUNGEON_CACHE = new WeakCache();
    private static boolean debugPole = false;

    public static void placeDungeon(Random random, int chunkX, int chunkZ, World world) throws Throwable {
        if (world.field_72995_K) {
            return;
        }
        if (MinecraftForge.TERRAIN_GEN_BUS.post((Event)new DLDEvent.PlaceDungeonBegin(chunkX, chunkZ, world))) {
            return;
        }
        DoomlikeDungeons.profiler.startTask("Create Dungeons");
        Dungeon dungeon = new Dungeon(world.func_180494_b(new BlockPos(chunkX * 16, 64, chunkZ * 16)), world, chunkX, chunkZ);
        Builder.buildDungeon(dungeon);
        dungeon.preFinalize();
        dungeon = null;
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)new DLDEvent.PlaceDungeonFinish(chunkX, chunkZ, world, dungeon));
        DoomlikeDungeons.profiler.endTask("Create Dungeons");
    }

    public static void placeDungeon(int chunkX, int chunkZ, World world) throws Throwable {
        if (world.field_72995_K) {
            return;
        }
        if (MinecraftForge.TERRAIN_GEN_BUS.post((Event)new DLDEvent.PlaceDungeonBegin(chunkX, chunkZ, world))) {
            return;
        }
        DoomlikeDungeons.profiler.startTask("Create Dungeons");
        Dungeon dungeon = new Dungeon(world.func_180494_b(new BlockPos(chunkX * 16, 64, chunkZ * 16)), world, chunkX, chunkZ);
        if (dungeon.theme != null && (dungeon.theme.dimensionWhitelist.length == 0 || Arrays.stream(dungeon.theme.dimensionWhitelist).anyMatch(id -> id == world.field_73011_w.getDimension()))) {
            if (debugPole) {
                Builder.debuggingPole(world, chunkX, chunkZ, dungeon);
            }
            Builder.buildDungeon(dungeon);
        }
        dungeon.preFinalize();
        dungeon = null;
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)new DLDEvent.PlaceDungeonFinish(chunkX, chunkZ, world, dungeon));
        DoomlikeDungeons.profiler.endTask("Create Dungeons");
    }

    public static void buildDungeonChunk(int cx, int cz, Coords dc, World world) throws Throwable {
        Dungeon dungeon = DUNGEON_CACHE.get(dc);
        if (dungeon == null) {
            dungeon = new Dungeon(world, dc);
            DUNGEON_CACHE.add(dungeon);
        }
        if (dungeon != null) {
            dungeon.map.buildInChunk(dungeon, cx, cz);
        }
    }

    public static void buildDungeonsChunk(int cx, int cz, List<Coords> dcs, World world) throws Throwable {
        for (Coords dc : dcs) {
            Builder.buildDungeonChunk(cx, cz, dc, world);
        }
    }

    public static void buildDungeon(Dungeon dungeon) {
        if (dungeon.theme != null) {
            dungeon.map.buildByChunks(dungeon);
        }
    }

    public static void debuggingPole(World world, int chunkX, int chunkZ, Dungeon dungeon) {
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        for (int y = 16; y <= 241; ++y) {
            RegisteredBlock.placeBlock(world, x, y, z, RegisteredBlock.quartz);
        }
        for (int i = -dungeon.size.radius; i <= dungeon.size.radius; ++i) {
            RegisteredBlock.placeBlock(world, x - dungeon.size.radius, 80, z + i, RegisteredBlock.lapis);
            RegisteredBlock.placeBlock(world, x + dungeon.size.radius, 80, z + i, RegisteredBlock.lapis);
            RegisteredBlock.placeBlock(world, x + i, 80, z - dungeon.size.radius, RegisteredBlock.lapis);
            RegisteredBlock.placeBlock(world, x + i, 80, z + dungeon.size.radius, RegisteredBlock.lapis);
        }
    }

    public static void setDebugPole(boolean val) {
        debugPole = val;
    }
}

