/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.TileFluidHandler;
import rustic.common.blocks.ModBlocks;

public class TileEntityLiquidBarrel
extends TileFluidHandler {
    public static int capacity = 16000;
    public static final int MAX_TEMP = 573;

    public TileEntityLiquidBarrel() {
        this.tank = new FluidTank(capacity){

            protected void onContentsChanged() {
                TileEntityLiquidBarrel.this.func_70296_d();
                TileEntityLiquidBarrel.this.func_145831_w().func_184138_a(TileEntityLiquidBarrel.this.field_174879_c, TileEntityLiquidBarrel.this.func_145831_w().func_180495_p(TileEntityLiquidBarrel.this.field_174879_c), TileEntityLiquidBarrel.this.func_145831_w().func_180495_p(TileEntityLiquidBarrel.this.field_174879_c), 2);
            }
        };
        this.tank.setTileEntity((TileEntity)this);
        this.tank.setCanFill(true);
        this.tank.setCanDrain(true);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public int getCapacity() {
        return this.tank.getCapacity();
    }

    public int getAmount() {
        return this.tank.getFluidAmount();
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public Fluid getFluid() {
        if (this.tank.getFluid() != null) {
            return this.tank.getFluid().getFluid();
        }
        return null;
    }

    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem != ItemStack.field_190927_a && (FluidUtil.getFluidHandler((ItemStack)heldItem) != null || heldItem.func_77973_b() instanceof ItemBucket || heldItem.func_77973_b() instanceof UniversalBucket)) {
            boolean didFill;
            FluidStack f = FluidUtil.getFluidContained((ItemStack)heldItem);
            if ((f != null && !f.getFluid().isGaseous() && f.getFluid().getTemperature() <= 573 || f == null) && (didFill = FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)((IFluidHandler)this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side))))) {
                this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, 0);
                this.func_145831_w().func_184138_a(pos, state, state, 3);
                this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
                this.func_70296_d();
            }
            return true;
        }
        return false;
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d) {
            ItemStack toDrop = new ItemStack((Block)ModBlocks.LIQUID_BARREL, 1);
            if (this.getTank().getFluidAmount() > 0) {
                NBTTagCompound tag = new NBTTagCompound();
                this.getTank().writeToNBT(tag);
                toDrop.func_77982_d(tag);
            }
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, toDrop));
        }
        world.func_175690_a(pos, null);
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().func_180495_p(this.field_174879_c), 3);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
            this.func_70296_d();
            return true;
        }
        return super.func_145842_c(id, type);
    }
}

