/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RangedWrapper;
import rustic.common.blocks.BlockCondenser;
import rustic.common.blocks.ModBlocks;
import rustic.common.crafting.ICondenserRecipe;
import rustic.common.crafting.Recipes;
import rustic.common.tileentity.TileEntityCondenserBase;
import rustic.core.Rustic;

public class TileEntityCondenser
extends TileEntityCondenserBase {
    public static int SLOT_NUM = 5;
    private IItemHandler handlerBottom;
    private IItemHandler handlerBack;
    private IItemHandler handlerSide;

    @Override
    protected int getInternalSize() {
        return SLOT_NUM;
    }

    @Override
    public String getName() {
        return "container.rustic.condenser";
    }

    public TileEntityCondenser() {
        this.handlerBottom = new RangedWrapper((IItemHandlerModifiable)this.externalStackHandler, 0, 1);
        this.handlerBack = new RangedWrapper((IItemHandlerModifiable)this.externalStackHandler, 1, 3);
        this.handlerSide = new RangedWrapper((IItemHandlerModifiable)this.externalStackHandler, 3, 5);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() != ModBlocks.CONDENSER || !((BlockCondenser)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c()).hasRetorts(this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c))) {
            return false;
        }
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() != ModBlocks.CONDENSER || !((BlockCondenser)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c()).hasRetorts(this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c))) {
            return null;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return (T)this.externalStackHandler;
            }
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == ((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockCondenser.FACING)).func_176734_d()) {
                return (T)this.handlerBack;
            }
            if (facing.func_176740_k() != EnumFacing.Axis.Y) {
                return (T)this.handlerSide;
            }
            return (T)this.externalStackHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    protected boolean canBrew() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() != ModBlocks.CONDENSER || !((Boolean)state.func_177229_b((IProperty)BlockCondenser.BOTTOM)).booleanValue()) {
            return false;
        }
        if (this.internalStackHandler.getStackInSlot(3).func_190926_b() && this.internalStackHandler.getStackInSlot(4).func_190926_b()) {
            return false;
        }
        return ((BlockCondenser)state.func_177230_c()).hasRetorts(this.field_145850_b, this.field_174879_c, state);
    }

    @Override
    protected void refreshCurrentRecipe() {
        if (this.hasContentChanged) {
            this.hasContentChanged = false;
            Fluid fluid = this.getFluid();
            ItemStack bottle = this.internalStackHandler.getStackInSlot(2);
            ItemStack[] inputs = new ItemStack[]{this.internalStackHandler.getStackInSlot(3), this.internalStackHandler.getStackInSlot(4)};
            if (this.currentRecipe != null && this.currentRecipe.matches(fluid, ItemStack.field_190927_a, bottle, inputs)) {
                return;
            }
            this.brewTime = 0;
            this.currentRecipe = null;
            for (ICondenserRecipe recipe : Recipes.condenserRecipes) {
                if (!recipe.isBasic() || !recipe.matches(fluid, ItemStack.field_190927_a, bottle, inputs)) continue;
                this.currentRecipe = recipe;
                this.totalBrewTime = recipe.getTime();
                return;
            }
        }
    }

    @Override
    protected void renderParticles() {
        if (this.field_145850_b.field_72995_K && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == ModBlocks.CONDENSER) {
            EnumFacing blockFacing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockCondenser.FACING);
            double yVel = 0.125;
            if (blockFacing == EnumFacing.NORTH || blockFacing == EnumFacing.SOUTH) {
                Rustic.proxy.spawnAlchemySmokeFX(this.field_145850_b, this.brewTime, (double)this.field_174879_c.func_177958_n() - 0.5, (double)this.field_174879_c.func_177956_o() + 1.0625, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, yVel, 0.0);
                Rustic.proxy.spawnAlchemySmokeFX(this.field_145850_b, this.brewTime, (double)this.field_174879_c.func_177958_n() + 1.5, (double)this.field_174879_c.func_177956_o() + 1.0625, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, yVel, 0.0);
            } else if (blockFacing == EnumFacing.EAST || blockFacing == EnumFacing.WEST) {
                Rustic.proxy.spawnAlchemySmokeFX(this.field_145850_b, this.brewTime, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0625, (double)this.field_174879_c.func_177952_p() - 0.5, 0.0, yVel, 0.0);
                Rustic.proxy.spawnAlchemySmokeFX(this.field_145850_b, this.brewTime, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0625, (double)this.field_174879_c.func_177952_p() + 1.5, 0.0, yVel, 0.0);
            }
        }
    }

    @Override
    protected void brew() {
        if (this.canBrew()) {
            ItemStack[] inputs = new ItemStack[]{this.internalStackHandler.getStackInSlot(3), this.internalStackHandler.getStackInSlot(4)};
            ItemStack bottle = this.internalStackHandler.getStackInSlot(2);
            ICondenserRecipe recipe = this.currentRecipe;
            if (recipe.matches(this.getFluid(), ItemStack.field_190927_a, bottle, inputs) && this.getAmount() >= recipe.getFluid().amount) {
                this.internalStackHandler.insertItem(0, recipe.getResult(), false);
                int[] consume = recipe.getInputConsumption(inputs);
                this.internalStackHandler.extractItem(3, consume[0], false);
                this.internalStackHandler.extractItem(4, consume[1], false);
                this.internalStackHandler.extractItem(2, recipe.getBottleConsumption(bottle), false);
                this.tank.drain(recipe.getFluid().amount, true);
            }
        }
    }
}

