/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.blocks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import rustic.common.blocks.BlockPlanksRustic;
import rustic.common.blocks.IColoredBlock;
import rustic.common.blocks.ModBlocks;
import rustic.common.items.ModItems;
import rustic.core.ClientProxy;
import rustic.core.Rustic;

public class BlockLeavesRustic
extends BlockLeaves
implements IColoredBlock {
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", BlockPlanksRustic.EnumType.class);

    public BlockLeavesRustic() {
        this.setRegistryName("leaves");
        this.func_149663_c("rustic.leaves");
        this.func_149647_a(Rustic.farmingTab);
        ItemBlock item = new ItemBlock((Block)this){

            public String func_77667_c(ItemStack stack) {
                IBlockState state = BlockLeavesRustic.this.func_176203_a(stack.func_77960_j());
                return this.func_77658_a() + "_" + state.func_177229_b(BlockPlanksRustic.VARIANT);
            }

            public int func_77647_b(int damage) {
                return damage;
            }
        };
        item.func_77627_a(true);
        item.func_77656_e(0);
        item.setRegistryName(this.getRegistryName());
        GameRegistry.findRegistry(Block.class).register((IForgeRegistryEntry)this);
        GameRegistry.findRegistry(Item.class).register((IForgeRegistryEntry)item);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)((Object)BlockPlanksRustic.EnumType.OLIVE)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(true)));
        Blocks.field_150480_ab.func_180686_a((Block)this, 30, 60);
    }

    protected void func_176234_a(World worldIn, BlockPos pos, IBlockState state, int chance) {
        if (worldIn.field_73012_v.nextInt(chance) == 0) {
            switch ((BlockPlanksRustic.EnumType)((Object)state.func_177229_b((IProperty)VARIANT))) {
                case OLIVE: {
                    BlockLeavesRustic.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((Item)ModItems.OLIVES));
                    break;
                }
                case IRONWOOD: {
                    BlockLeavesRustic.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((Item)ModItems.IRONBERRIES));
                }
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)ModBlocks.SAPLING);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack drop;
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        int chance = this.func_176232_d(state);
        if (fortune > 0 && (chance -= 2 << fortune) < 10) {
            chance = 10;
        }
        if (rand.nextInt(chance) == 0 && !(drop = new ItemStack(this.func_180660_a(state, rand, fortune), 1, this.func_180651_a(state))).func_190926_b()) {
            ret.add(drop);
        }
        chance = 0;
        switch ((BlockPlanksRustic.EnumType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case OLIVE: {
                chance = 6;
                break;
            }
            case IRONWOOD: {
                chance = 16;
            }
        }
        if (fortune > 0 && (chance -= fortune) < 2) {
            chance = 2;
        }
        this.captureDrops(true);
        if (world instanceof World) {
            this.func_176234_a((World)world, pos, state, chance);
        }
        ret.addAll((Collection<ItemStack>)this.captureDrops(false));
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        StateMap custom_mapper = new StateMap.Builder().func_178442_a(new IProperty[]{field_176236_b, field_176237_a}).func_178441_a();
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)custom_mapper);
        for (int i = 0; i < BlockPlanksRustic.EnumType.values().length && i < 4; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)i, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_" + BlockPlanksRustic.EnumType.byMetadata(i).func_176610_l(), "inventory"));
        }
        ClientProxy.addColoredBlock((Block)this);
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return NonNullList.func_191197_a((int)1, (Object)new ItemStack((Block)this, 1, ((BlockPlanksRustic.EnumType)((Object)world.func_180495_p(pos).func_177229_b((IProperty)VARIANT))).getMetadata()));
    }

    public int func_180651_a(IBlockState state) {
        return ((BlockPlanksRustic.EnumType)((Object)state.func_177229_b((IProperty)VARIANT))).getMetadata();
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, ((BlockPlanksRustic.EnumType)((Object)state.func_177229_b((IProperty)VARIANT))).getMetadata());
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (!worldIn.field_72995_K && stack.func_77973_b() == Items.field_151097_aZ) {
            player.func_71029_a(StatList.func_188055_a((Block)this));
        } else {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
        }
    }

    protected int func_176232_d(IBlockState state) {
        return 20;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (BlockPlanksRustic.EnumType blockplanks$enumtype : BlockPlanksRustic.EnumType.values()) {
            if (blockplanks$enumtype.getMetadata() >= 4) continue;
            list.add((Object)new ItemStack(Item.func_150898_a((Block)this), 1, blockplanks$enumtype.getMetadata()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return Blocks.field_150362_t.func_180664_k();
    }

    public boolean func_149662_c(IBlockState state) {
        return Blocks.field_150362_t.func_149662_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return Blocks.field_150362_t.func_176225_a(state, world, pos, side);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, ((BlockPlanksRustic.EnumType)((Object)state.func_177229_b((IProperty)VARIANT))).getMetadata());
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(false));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)BlockPlanksRustic.EnumType.byMetadata(meta & 3))).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf((meta & 4) == 0)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((BlockPlanksRustic.EnumType)((Object)state.func_177229_b((IProperty)VARIANT))).getMetadata();
        if (!((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            i |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176236_b, field_176237_a, VARIANT});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                if (worldIn != null && pos != null) {
                    return BiomeColorHelper.func_180287_b((IBlockAccess)worldIn, (BlockPos)pos);
                }
                return ColorizerFoliage.func_77468_c();
            }
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                if (!(stack.func_77973_b() instanceof ItemBlock)) {
                    return 0xFFFFFF;
                }
                IBlockState state = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
                IBlockColor blockColor = ((IColoredBlock)state.func_177230_c()).getBlockColor();
                return blockColor == null ? 0xFFFFFF : blockColor.func_186720_a(state, null, null, tintIndex);
            }
        };
    }

    public BlockPlanks.EnumType func_176233_b(int meta) {
        return null;
    }
}

