/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.lib.varia.EnergyTools;
import mcjty.rftoolspower.RFToolsPower;
import mcjty.rftoolspower.blocks.InformationScreenTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketMonitorLogReady
implements IMessage {
    private BlockPos pos;
    private EnergyTools.EnergyLevel power;
    private long rfPerTickInserted;
    private long rfPerTickExtracted;
    private long roughMaxRfPerTick;

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos((ByteBuf)buf);
        this.rfPerTickExtracted = buf.readLong();
        this.rfPerTickInserted = buf.readLong();
        this.roughMaxRfPerTick = buf.readLong();
        this.power = buf.readBoolean() ? new EnergyTools.EnergyLevel(buf.readLong(), buf.readLong()) : null;
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        buf.writeLong(this.rfPerTickExtracted);
        buf.writeLong(this.rfPerTickInserted);
        buf.writeLong(this.roughMaxRfPerTick);
        if (this.power != null) {
            buf.writeBoolean(true);
            buf.writeLong(this.power.getEnergy());
            buf.writeLong(this.power.getMaxEnergy());
        } else {
            buf.writeBoolean(false);
        }
    }

    public PacketMonitorLogReady() {
    }

    public PacketMonitorLogReady(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketMonitorLogReady(BlockPos pos, EnergyTools.EnergyLevel power, long rfPerTickInserted, long rfPerTickExtracted, long roughMaxRfPerTick) {
        this.pos = pos;
        this.power = power;
        this.rfPerTickExtracted = rfPerTickExtracted;
        this.rfPerTickInserted = rfPerTickInserted;
        this.roughMaxRfPerTick = roughMaxRfPerTick;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te = RFToolsPower.proxy.getClientWorld().func_175625_s(this.pos);
            if (te instanceof InformationScreenTileEntity) {
                InformationScreenTileEntity info = (InformationScreenTileEntity)te;
                info.setClientPower(this.power, this.rfPerTickInserted, this.rfPerTickExtracted, this.roughMaxRfPerTick);
            }
        });
        ctx.setPacketHandled(true);
    }
}

