/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.config;

import java.io.File;
import mcjty.lib.thirteen.ConfigSpec;
import mcjty.lib.varia.Logging;
import mcjty.rftoolspower.RFToolsPower;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

public class ConfigSetup {
    public static final String CATEGORY_GENERAL = "general";
    public static ConfigSpec.IntValue TIER1_MAXRF;
    public static ConfigSpec.IntValue TIER2_MAXRF;
    public static ConfigSpec.IntValue TIER3_MAXRF;
    public static ConfigSpec.IntValue TIER1_RFPERTICK;
    public static ConfigSpec.IntValue TIER2_RFPERTICK;
    public static ConfigSpec.IntValue TIER3_RFPERTICK;
    public static ConfigSpec.DoubleValue RFPERTICK_SCALE;
    public static ConfigSpec.IntValue NETWORK_MAX;
    private static final ConfigSpec.Builder SERVER_BUILDER;
    private static final ConfigSpec.Builder CLIENT_BUILDER;
    public static ConfigSpec SERVER_CONFIG;
    public static ConfigSpec CLIENT_CONFIG;
    public static Configuration mainConfig;

    public static void init() {
        Configuration cfg = mainConfig = new Configuration(new File(RFToolsPower.setup.getModConfigDir().getPath() + File.separator + "rftools", "rftoolspower.cfg"));
        try {
            cfg.load();
            SERVER_CONFIG = SERVER_BUILDER.build(mainConfig);
            CLIENT_CONFIG = CLIENT_BUILDER.build(mainConfig);
        }
        catch (Exception e1) {
            Logging.getLogger().log(Level.ERROR, "Problem loading config file!", (Throwable)e1);
        }
    }

    public static void postInit() {
        if (mainConfig.hasChanged()) {
            mainConfig.save();
        }
    }

    static {
        SERVER_BUILDER = new ConfigSpec.Builder();
        CLIENT_BUILDER = new ConfigSpec.Builder();
        SERVER_BUILDER.comment("General settings").push(CATEGORY_GENERAL);
        CLIENT_BUILDER.comment("General settings").push(CATEGORY_GENERAL);
        TIER1_MAXRF = SERVER_BUILDER.comment("Maximum RF a single tier1 cell can hold").defineInRange("tier1MaxRF", 500000, 1, 2000000000);
        TIER2_MAXRF = SERVER_BUILDER.comment("Maximum RF a single tier2 cell can hold").defineInRange("tier2MaxRF", 4000000, 1, 2000000000);
        TIER3_MAXRF = SERVER_BUILDER.comment("Maximum RF a single tier3 cell can hold").defineInRange("tier3MaxRF", 20000000, 1, 2000000000);
        TIER1_RFPERTICK = SERVER_BUILDER.comment("Maximum RF/tick per side for a tier1 cell").defineInRange("tier1MaxRFPerTick", 250, 1, 2000000000);
        TIER2_RFPERTICK = SERVER_BUILDER.comment("Maximum RF/tick per side for a tier2 cell").defineInRange("tier2MaxRFPerTick", 1000, 1, 2000000000);
        TIER3_RFPERTICK = SERVER_BUILDER.comment("Maximum RF/tick per side for a tier3 cell").defineInRange("tier3MaxRFPerTick", 4000, 1, 2000000000);
        RFPERTICK_SCALE = SERVER_BUILDER.comment("How much extra RF/tick every cell gets per cell in the network. 0 means constant RF/t. 1 means linear with amount of cells").defineInRange("rfPerTickScale", 0.25, 0.0, 100.0);
        NETWORK_MAX = SERVER_BUILDER.comment("Maximum number of blocks in a single multiblock network").defineInRange("networkMax", 729, 1, 2000000000);
        SERVER_BUILDER.pop();
        CLIENT_BUILDER.pop();
    }
}

