/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.compat.theoneprobe;

import com.google.common.base.Function;
import javax.annotation.Nullable;
import mcjty.lib.McJtyLib;
import mcjty.lib.base.ModBase;
import mcjty.lib.compat.theoneprobe.TOPInfoProvider;
import mcjty.lib.multipart.MultipartHelper;
import mcjty.lib.multipart.MultipartTE;
import mcjty.lib.setup.ModSetup;
import mcjty.lib.varia.Logging;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import org.apache.commons.lang3.text.WordUtils;

public class TOPCompatibility {
    private static boolean registered;

    public static void register() {
        if (registered) {
            return;
        }
        registered = true;
        FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)"mcjty.lib.compat.theoneprobe.TOPCompatibility$GetTheOneProbe");
    }

    public static class GetTheOneProbe
    implements Function<ITheOneProbe, Void> {
        public static ITheOneProbe probe;

        @Nullable
        public Void apply(ITheOneProbe theOneProbe) {
            probe = theOneProbe;
            Logging.log("Enabled support for The One Probe");
            probe.registerProvider(new IProbeInfoProvider(){

                public String getID() {
                    return "mcjtylib:default";
                }

                public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
                    if (blockState.func_177230_c() instanceof TOPInfoProvider) {
                        TOPInfoProvider provider = (TOPInfoProvider)blockState.func_177230_c();
                        provider.addProbeInfo(mode, probeInfo, player, world, blockState, data);
                    }
                }
            });
            probe.registerBlockDisplayOverride((mode, probeInfo, player, world, blockState, data) -> {
                Block block = blockState.func_177230_c();
                if (block == ModSetup.multipartBlock) {
                    String modid = "mcjtylib_ng";
                    ItemStack pickBlock = data.getPickBlock();
                    MultipartTE.Part part = ModSetup.multipartBlock.getHitPart(blockState, world, data.getPos(), MultipartHelper.getPlayerEyes(player), data.getHitVec());
                    if (part != null) {
                        pickBlock = part.getState().func_177230_c().func_185473_a(world, data.getPos(), part.getState());
                        modid = part.getState().func_177230_c().getRegistryName().func_110624_b();
                    }
                    modid = WordUtils.capitalize((String)modid);
                    if (!pickBlock.func_190926_b()) {
                        probeInfo.horizontal().item(pickBlock).vertical().itemLabel(pickBlock).text(TextStyleClass.MODNAME + modid);
                    } else {
                        probeInfo.vertical().text(TextStyleClass.NAME + "{*" + block.func_149739_a() + ".name" + "*}").text(TextStyleClass.MODNAME + modid);
                    }
                    return true;
                }
                return false;
            });
            McJtyLib.forEachMod(ModBase::handleTopExtras);
            return null;
        }
    }
}

