/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.network.packet;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;

public class WindowItemsFragmentPacket
extends PacketCodec {
    @CodecField
    private int windowId;
    @CodecField
    private NBTTagCompound itemStacks;

    public WindowItemsFragmentPacket() {
    }

    public WindowItemsFragmentPacket(int windowId, NBTTagCompound itemStacks) {
        this.windowId = windowId;
        this.itemStacks = itemStacks;
    }

    public boolean isAsync() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void actionClient(World world, EntityPlayer player) {
        if (this.windowId == 0) {
            this.putStacksInSlotsWithOffset(player.field_71069_bz);
        } else if (this.windowId == player.field_71070_bA.field_75152_c) {
            this.putStacksInSlotsWithOffset(player.field_71070_bA);
        }
    }

    protected void putStacksInSlotsWithOffset(Container container) {
        NBTTagList list = this.itemStacks.func_150295_c("stacks", MinecraftHelpers.NBTTag_Types.NBTTagCompound.ordinal());
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            int slot = tag.func_74762_e("slot");
            ItemStack stack = new ItemStack(tag.func_74775_l("stack"));
            container.func_75141_a(slot, stack);
        }
    }

    public void actionServer(World world, EntityPlayerMP player) {
    }
}

