/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.fencejumper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockWall;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import p455w0rd.fencejumper.Globals;
import p455w0rd.fencejumper.integration.Quark;

@Mod(modid="fencejumper", name="Fence Jumper", version="1.0.5", acceptedMinecraftVersions="1.12")
public class FenceJumper {
    @Mod.Instance(value="fencejumper")
    public static FenceJumper INSTANCE;
    public static final List<Block> OREDICT_FENCES;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        INSTANCE = this;
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onJump(LivingEvent.LivingJumpEvent e) {
        if (e.getEntity() instanceof EntityPlayerSP) {
            EntityPlayerSP player = (EntityPlayerSP)e.getEntity();
            if (player.field_71158_b.field_78901_c && this.isPlayerNextToFence(player)) {
                player.field_70181_x += 0.05;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isPlayerNextToFence(EntityPlayerSP player) {
        double x = player.field_70165_t - 1.0;
        double y = player.field_70163_u;
        double z = player.field_70161_v - 1.0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                Block block;
                if ((double)i == x && (double)j == z || !((block = this.getBlock(player.func_130014_f_(), new BlockPos(x + (double)i, y, z + (double)j))) instanceof BlockFence) && !(block instanceof BlockWall) && !this.getOreDictFences().contains(block) && !this.quarkCheck(block)) continue;
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean quarkCheck(Block block) {
        return Globals.Mods.QUARK.isLoaded() ? Quark.isQuarkWall(block) : false;
    }

    private final List<Block> getOreDictFences() {
        ArrayList oreNames = Lists.newArrayList();
        for (String oreName : OreDictionary.getOreNames()) {
            if (oreName == null || oreName.length() <= 5 || !oreName.toLowerCase().startsWith("fence") || oreNames.contains(oreName)) continue;
            oreNames.add(oreName);
        }
        for (String name : oreNames) {
            if (name == null || name.length() <= 0) continue;
            for (ItemStack fence : OreDictionary.getOres((String)name)) {
                Block block = Block.func_149634_a((Item)fence.func_77973_b());
                if (block == null || block == Blocks.field_150350_a || this.doesListContainBlock(block)) continue;
                OREDICT_FENCES.add(block);
            }
        }
        return OREDICT_FENCES;
    }

    private boolean doesListContainBlock(@Nonnull Block block) {
        for (Block tmpBlock : OREDICT_FENCES) {
            if (tmpBlock != block) continue;
            return true;
        }
        return false;
    }

    private Block getBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c();
    }

    static {
        OREDICT_FENCES = Lists.newArrayList();
    }
}

