/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.modcompat;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.init.ModBase;

public class IMCHandler {
    protected final ModBase mod;
    private Map<String, IIMCAction> actions = Maps.newHashMap();

    public IMCHandler(ModBase mod) {
        this.mod = mod;
    }

    public void registerAction(String key, IIMCAction action) {
        this.actions.put(key, action);
    }

    public void handle(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            this.handle(message);
        }
    }

    public void handle(FMLInterModComms.IMCMessage message) {
        this.mod.log(Level.INFO, String.format("Handling IMC message from %s.", message.getSender()));
        IIMCAction action = this.actions.get(message.key);
        if (action != null) {
            if (!action.handle(message)) {
                this.mod.log(Level.ERROR, String.format("The IMC message for key %s was rejected. It may have been incorrectly formatted or has resulted in an error.", message.key));
            }
        } else {
            this.mod.log(Level.ERROR, String.format("An IMC message with invalid key %s was received.", message.key));
        }
    }

    public static interface IIMCAction {
        public boolean handle(FMLInterModComms.IMCMessage var1);
    }
}

