/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.item;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.cyclops.cyclopscore.item.IBucketRegistry;

public class BucketRegistry
implements IBucketRegistry {
    private final Map<Block, Item> items = Maps.newHashMap();
    private final Map<Item, FluidStack> fluidStacks = Maps.newHashMap();

    @Override
    public void registerBucket(Block block, Item item) {
        this.items.put(block, item);
    }

    @Override
    public void registerBucket(Item item, FluidStack fluidStack) {
        this.fluidStacks.put(item, fluidStack);
    }

    @Override
    public Map<Block, Item> getBlockItem() {
        return this.items;
    }

    @Override
    public Map<Item, FluidStack> getItemFluidStack() {
        return this.fluidStacks;
    }

    @Override
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBucketFill(FillBucketEvent event) {
        ItemStack result = this.fillCustomBucket(event.getWorld(), event.getTarget(), event.getEmptyBucket());
        if (result != null) {
            event.setFilledBucket(result);
            event.setResult(Event.Result.ALLOW);
        }
    }

    private ItemStack fillCustomBucket(World world, RayTraceResult pos, ItemStack current) {
        if (pos == null) {
            return null;
        }
        Block block = world.func_180495_p(pos.func_178782_a()).func_177230_c();
        Item bucket = this.items.get(block);
        if (bucket != null && world.func_180495_p(pos.func_178782_a()) == block.func_176223_P() && ItemStack.func_77989_b((ItemStack)current, (ItemStack)bucket.getContainerItem(current))) {
            world.func_175698_g(pos.func_178782_a());
            return new ItemStack(bucket);
        }
        return null;
    }
}

