/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client;

import com.google.common.base.Preconditions;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import openmods.colors.RGB;
import org.lwjgl.opengl.GL11;

public class Icons {
    private static void addVertexWithUV(BufferBuilder wr, double x, double y, double u, double v) {
        wr.func_181662_b(x, y, 0.0).func_187315_a(u, v).func_181675_d();
    }

    public static IDrawableIcon createIcon(ResourceLocation iconId, int color) {
        return new LoadableSingleIcon(iconId, color);
    }

    public static IDrawableIcon createIcon(ResourceLocation iconId) {
        return Icons.createIcon(iconId, 0xFFFFFF);
    }

    public static class ComposedIcon
    implements IDrawableIcon {
        private final IDrawableIcon front;
        private final IDrawableIcon back;
        private final double scaleRatio;
        private final double distance;

        public ComposedIcon(IDrawableIcon front, IDrawableIcon back, double scaleRatio, double distance) {
            this.front = front;
            this.back = back;
            this.scaleRatio = scaleRatio;
            this.distance = distance;
        }

        @Override
        public void draw(double alpha, double scale) {
            this.back.draw(alpha, scale * this.scaleRatio);
            GL11.glTranslated((double)0.0, (double)0.0, (double)(-this.distance));
            this.front.draw(alpha, scale);
        }

        @Override
        public void registerIcons(TextureMap registry) {
            this.front.registerIcons(registry);
            this.back.registerIcons(registry);
        }
    }

    private static class LoadableSingleIcon
    extends SingleIcon {
        private final ResourceLocation iconId;

        private LoadableSingleIcon(ResourceLocation iconId, int color) {
            super(color);
            this.iconId = iconId;
        }

        @Override
        public void registerIcons(TextureMap registry) {
            this.icon = registry.func_174942_a(this.iconId);
        }
    }

    public static class SingleIcon
    implements IDrawableIcon {
        protected TextureAtlasSprite icon;
        public final float r;
        public final float g;
        public final float b;

        protected SingleIcon(int color) {
            RGB rgb = new RGB(color);
            this.r = rgb.getR();
            this.g = rgb.getG();
            this.b = rgb.getB();
        }

        public SingleIcon(TextureAtlasSprite icon, int color) {
            this(color);
            this.icon = icon;
        }

        @Override
        public void draw(double alpha, double scale) {
            Preconditions.checkNotNull((Object)this.icon);
            GlStateManager.func_179131_c((float)this.r, (float)this.g, (float)this.b, (float)MathHelper.func_76128_c((double)(255.0 * alpha)));
            Tessellator tes = Tessellator.func_178181_a();
            BufferBuilder wr = tes.func_178180_c();
            wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            Icons.addVertexWithUV(wr, scale, scale, this.icon.func_94209_e(), this.icon.func_94206_g());
            Icons.addVertexWithUV(wr, scale, -scale, this.icon.func_94209_e(), this.icon.func_94210_h());
            Icons.addVertexWithUV(wr, -scale, -scale, this.icon.func_94212_f(), this.icon.func_94210_h());
            Icons.addVertexWithUV(wr, -scale, scale, this.icon.func_94212_f(), this.icon.func_94206_g());
            tes.func_78381_a();
        }

        @Override
        public void registerIcons(TextureMap registry) {
        }
    }

    public static interface IDrawableIcon {
        public void draw(double var1, double var3);

        public void registerIcons(TextureMap var1);
    }
}

