/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.world.trickery;

import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.common.entity.EntityFairy;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;

public class ChunkGeneratorTorikki
implements IChunkGenerator {
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState DIRT = Blocks.field_150346_d.func_176223_P();
    protected static final IBlockState BEDROCK = Blocks.field_150357_h.func_176223_P();
    private NoiseGeneratorPerlin noise;
    private NoiseGeneratorOctaves lperlinNoise1;
    private NoiseGeneratorOctaves lperlinNoise2;
    private World world;
    private final Random rand;

    public ChunkGeneratorTorikki(World worldIn) {
        this.world = worldIn;
        this.rand = new Random(this.world.func_72905_C());
        this.noise = new NoiseGeneratorPerlin(RandUtil.random, 4);
        this.lperlinNoise1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.lperlinNoise2 = new NoiseGeneratorOctaves(this.rand, 16);
    }

    public ChunkGeneratorTorikki(World world, long seed) {
        this.world = world;
        this.rand = new Random(world.func_72905_C());
        this.noise = new NoiseGeneratorPerlin(this.rand, 4);
    }

    private boolean isChunkCenter(int chunkX, int chunkZ) {
        long s2 = ((long)chunkX + this.world.func_72905_C() + 337L) * 947L + (long)chunkZ * 719L;
        Random rand = new Random(s2);
        rand.nextFloat();
        return rand.nextFloat() < 0.3f;
    }

    private Random getRandomForChunk(int chunkX, int chunkZ) {
        long s2 = ((long)chunkX + this.world.func_72905_C() + 13L) * 314L + (long)chunkZ * 17L;
        Random rand = new Random(s2);
        rand.nextFloat();
        return rand;
    }

    private void generate(int chunkX, int chunkZ, ChunkPrimer primer) {
        int locZ;
        int locY;
        int locX;
        for (locX = 0; locX < 16; ++locX) {
            for (locY = 0; locY < 256; ++locY) {
                for (locZ = 0; locZ < 16; ++locZ) {
                    if (locY <= 64 && locY > 1 || locY > 192 && locY < 255) {
                        primer.func_177855_a(locX, locY, locZ, DIRT);
                        continue;
                    }
                    if (locY != 1 && locY != 255) continue;
                    primer.func_177855_a(locX, locY, locZ, BEDROCK);
                }
            }
        }
        for (locX = 0; locX < 16; ++locX) {
            for (locY = 65; locY < 128; ++locY) {
                for (locZ = 0; locZ < 16; ++locZ) {
                    if (!(0.5 < this.noise.func_151601_a((double)chunkZ, (double)chunkX))) continue;
                    primer.func_177855_a(locX, locY, locZ, DIRT);
                }
            }
        }
    }

    @Nonnull
    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.generate(x, z, chunkprimer);
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        byte[] biomeArray = chunk.func_76605_m();
        for (int i = 0; i < biomeArray.length; ++i) {
            biomeArray[i] = 42;
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int x, int z) {
    }

    public boolean func_185933_a(@Nonnull Chunk chunkIn, int x, int z) {
        return false;
    }

    @Nonnull
    public List<Biome.SpawnListEntry> func_177458_a(@Nonnull EnumCreatureType creatureType, @Nonnull BlockPos pos) {
        ArrayList<Biome.SpawnListEntry> list = new ArrayList<Biome.SpawnListEntry>();
        list.add(new Biome.SpawnListEntry(EntityFairy.class, 1, 1, 3));
        return list;
    }

    @Nullable
    public BlockPos func_180513_a(@Nonnull World worldIn, @Nonnull String structureName, @Nonnull BlockPos position, boolean findUnexplored) {
        return null;
    }

    public void func_180514_a(@Nonnull Chunk chunkIn, int x, int z) {
    }

    public boolean func_193414_a(@Nonnull World worldIn, @Nonnull String structureName, @Nonnull BlockPos pos) {
        return false;
    }
}

