/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.potion;

import com.teamwizardry.librarianlib.features.forgeevents.EntityUpdateEvent;
import com.teamwizardry.wizardry.api.events.EntityMoveEvent;
import com.teamwizardry.wizardry.api.events.SpellCastEvent;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.common.potion.PotionBase;
import com.teamwizardry.wizardry.init.ModPotions;
import com.teamwizardry.wizardry.init.ModSounds;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.dragon.phase.IPhase;
import net.minecraft.entity.boss.dragon.phase.PhaseList;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Mod.EventBusSubscriber(modid="wizardry")
public class PotionTimeSlow
extends PotionBase {
    public PotionTimeSlow() {
        super("time_slow", false, 15256077);
    }

    public void func_111185_a(EntityLivingBase entityLivingBaseIn, @Nonnull AbstractAttributeMap attributeMapIn, int amplifier) {
        super.func_111185_a(entityLivingBaseIn, attributeMapIn, amplifier);
        if (PotionTimeSlow.timeScale((Entity)entityLivingBaseIn) == 0.0f && entityLivingBaseIn instanceof EntityCreature) {
            ((EntityLiving)entityLivingBaseIn).func_94061_f(true);
            if (entityLivingBaseIn instanceof EntityCreeper) {
                ((EntityCreeper)entityLivingBaseIn).func_70829_a(-1);
            }
        }
        entityLivingBaseIn.field_70170_p.func_184133_a(null, entityLivingBaseIn.func_180425_c(), (SoundEvent)ModSounds.SLOW_MOTION_IN, SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    public void func_111187_a(EntityLivingBase entityLivingBaseIn, @Nonnull AbstractAttributeMap attributeMapIn, int amplifier) {
        super.func_111187_a(entityLivingBaseIn, attributeMapIn, amplifier);
        if (PotionTimeSlow.timeScale((Entity)entityLivingBaseIn) == 0.0f && entityLivingBaseIn instanceof EntityCreature) {
            ((EntityLiving)entityLivingBaseIn).func_94061_f(false);
        }
        entityLivingBaseIn.field_70170_p.func_184133_a(null, entityLivingBaseIn.func_180425_c(), (SoundEvent)ModSounds.SLOW_MOTION_OUT, SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    public static float timeScale(Entity entity) {
        PotionEffect effect;
        if (entity instanceof EntityLivingBase && (effect = ModPotions.TIME_SLOW.getEffect((EntityLivingBase)entity)) != null) {
            if (effect.func_76458_c() >= 19) {
                return 0.0f;
            }
            return 1.0f / ((float)effect.func_76458_c() + 1.5f);
        }
        return -1.0f;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void fall(LivingFallEvent event) {
        float scale = PotionTimeSlow.timeScale(event.getEntity());
        if (scale >= 0.0f) {
            event.setDistance(event.getDistance() * scale);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void entityPreUpdate(EntityUpdateEvent event) {
        Entity entity = event.getEntity();
        float scale = PotionTimeSlow.timeScale(entity);
        if (!entity.func_189652_ae() && scale > 0.0f) {
            double gravity = entity instanceof EntityLivingBase ? -0.08 : -0.04;
            entity.field_70181_x -= gravity * (double)(1.0f - scale);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void entityMove(EntityMoveEvent event) {
        float scale = PotionTimeSlow.timeScale(event.entity);
        if (scale >= 0.0f) {
            event.x *= (double)scale;
            event.y *= (double)scale;
            event.z *= (double)scale;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityItemPickup(PlayerEvent.ItemPickupEvent e) {
        if (PotionTimeSlow.timeScale((Entity)e.player) == 0.0f) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityJump(LivingEvent.LivingJumpEvent event) {
        PotionTimeSlow.stopEvent((LivingEvent)event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onItemUse(LivingEntityUseItemEvent.Start event) {
        PotionTimeSlow.stopEvent((LivingEvent)event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onItemTickUse(LivingEntityUseItemEvent.Start event) {
        PotionTimeSlow.stopEvent((LivingEvent)event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onAttack(PlayerInteractEvent.LeftClickEmpty e) {
        if (PotionTimeSlow.timeScale((Entity)e.getEntityPlayer()) == 0.0f) {
            e.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onSpell(SpellCastEvent e) {
        if (PotionTimeSlow.timeScale(e.getSpellData().getCaster(e.getWorld())) == 0.0f) {
            e.setSpellData(new SpellData());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onTick(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase e = event.getEntityLiving();
        if (e.func_70644_a((Potion)ModPotions.TIME_SLOW) && PotionTimeSlow.timeScale((Entity)e) == 0.0f) {
            boolean shouldFreeze = true;
            if (e.field_70128_L || e.func_110143_aJ() <= 0.0f) {
                shouldFreeze = false;
            }
            if (e instanceof EntityDragon && ((EntityDragon)e).func_184670_cT().func_188756_a().func_188652_i() == PhaseList.field_188750_j) {
                shouldFreeze = false;
            }
            if (shouldFreeze) {
                PotionTimeSlow.handleImportantEntityTicks(e);
                event.setCanceled(true);
            }
        }
    }

    private static void handleImportantEntityTicks(EntityLivingBase e) {
        IPhase phase;
        PotionEffect pe;
        if (e.field_70737_aN > 0) {
            --e.field_70737_aN;
        }
        if (e.field_70172_ad > 0) {
            --e.field_70172_ad;
        }
        e.field_184618_aE = e.field_70721_aZ;
        e.field_70760_ar = e.field_70761_aq;
        e.field_70127_C = e.field_70125_A;
        e.field_70126_B = e.field_70177_z;
        e.field_70758_at = e.field_70759_as;
        e.field_70732_aI = e.field_70733_aJ;
        e.field_70141_P = e.field_70140_Q;
        e.field_70727_aS = e.field_70726_aT;
        if (e.func_70644_a((Potion)ModPotions.TIME_SLOW) && PotionTimeSlow.timeScale((Entity)e) == 0.0f && !(pe = e.func_70660_b((Potion)ModPotions.TIME_SLOW)).func_76455_a(e) && !e.field_70170_p.field_72995_K) {
            e.func_184589_d((Potion)ModPotions.TIME_SLOW);
        }
        if (e instanceof EntityDragon && (phase = ((EntityDragon)e).func_184670_cT().func_188756_a()).func_188652_i() != PhaseList.field_188741_a && phase.func_188652_i() != PhaseList.field_188750_j) {
            ((EntityDragon)e).func_184670_cT().func_188758_a(PhaseList.field_188741_a);
        }
    }

    private static void stopEvent(LivingEvent event) {
        PotionEffect effect = ModPotions.TIME_SLOW.getEffect(event.getEntityLiving());
        if (effect == null) {
            return;
        }
        if (PotionTimeSlow.timeScale(event.getEntity()) == 0.0f) {
            event.setCanceled(true);
            event.setResult(Event.Result.DENY);
        }
    }
}

