/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects.phase;

import com.teamwizardry.librarianlib.core.client.ClientTickHandler;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL14;

@Mod.EventBusSubscriber(modid="wizardry", value={Side.CLIENT})
public class PhasedBlockRenderer {
    public static final float WARP_TIME_PERIOD = 40.0f;
    public static final float WARP_SPACE_PERIOD = 2.0f;
    public static final float WARP_MAGNITUDE = 0.0f;
    public static final int COLOR = 2666167;
    public static final float ALPHA = 0.75f;
    public static final float BASE_ALPHA = 0.5f;
    private static Set<PhaseObject> phaseObjects = new HashSet<PhaseObject>();

    public static void addPhase(World world, Set<BlockPos> blocks, int expiry) {
        phaseObjects.add(new PhaseObject(world, blocks, expiry));
    }

    public static BufferBuilder beginRender() {
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179089_o();
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179088_q();
        GlStateManager.func_179136_a((float)-0.1f, (float)-1000.0f);
        GlStateManager.func_179142_g();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GL14.glBlendEquation((int)32778);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181712_l);
        buffer.func_178969_c(-TileEntityRendererDispatcher.field_147554_b, -TileEntityRendererDispatcher.field_147555_c, -TileEntityRendererDispatcher.field_147552_d);
        return buffer;
    }

    public static void finishRender(BufferBuilder buffer) {
        Tessellator.func_178181_a().func_78381_a();
        buffer.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_187398_d((int)32774);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179113_r();
        GlStateManager.func_179126_j();
        GlStateManager.func_179098_w();
    }

    public static void render(PhaseObject object, float time, BufferBuilder buffer) {
        float timeAngle = 1.5707964f * (time - object.when) / (float)object.expiry;
        float colorWarp = (MathHelper.func_76134_b((float)timeAngle) * 0.5f + 0.5f) / 255.0f;
        float colorR = 40.0f * colorWarp;
        float colorG = 174.0f * colorWarp;
        float colorB = 183.0f * colorWarp;
        for (SurfaceFace side : object.surface) {
            PhasedBlockRenderer.renderFace(side, colorR, colorG, colorB, time, buffer);
        }
    }

    public static void renderFace(SurfaceFace face, float r, float g, float b, float time, BufferBuilder buffer) {
        for (float[] vertexData : face.shapeData) {
            float timeAngle = (float)Math.PI * time / 40.0f;
            float periodicValue = MathHelper.func_76126_a((float)timeAngle) * vertexData[6];
            float magnitude = (periodicValue + 1.0f) * 0.0f + 0.01f;
            float vectorX = magnitude * vertexData[3];
            float vectorY = magnitude * vertexData[4];
            float vectorZ = magnitude * vertexData[5];
            float x = vertexData[0] + vectorX;
            float y = vertexData[1] + vectorY;
            float z = vertexData[2] + vectorZ;
            buffer.func_181662_b((double)x, (double)y, (double)z).func_187315_a(0.0, 0.0).func_181666_a(r, g, b, 0.75f).func_181663_c(face.xNormal, face.yNormal, face.zNormal).func_181675_d();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void render(RenderWorldLastEvent event) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (Minecraft.func_71410_x().func_175598_ae().field_78733_k == null) {
            return;
        }
        HashSet<PhaseObject> tmp = new HashSet<PhaseObject>(phaseObjects);
        for (PhaseObject phaseObject : tmp) {
            if (Minecraft.func_71410_x().field_71441_e.func_82737_E() - phaseObject.lastWorldTick > (long)phaseObject.expiry) {
                phaseObjects.remove(phaseObject);
            }
            float time = (float)ClientTickHandler.getTicksInGame() + (Minecraft.func_71410_x().func_147113_T() ? 0.0f : ClientTickHandler.getPartialTicks());
            BufferBuilder bufferBuilder = PhasedBlockRenderer.beginRender();
            PhasedBlockRenderer.render(phaseObject, time, bufferBuilder);
            PhasedBlockRenderer.finishRender(bufferBuilder);
        }
    }

    private static class SurfaceFace {
        private static BlockPos.MutableBlockPos VISITOR = new BlockPos.MutableBlockPos();
        public final EnumFacing face;
        public final BlockPos position;
        public final float[][] shapeData = new float[4][7];
        public final float xNormal;
        public final float yNormal;
        public final float zNormal;

        public SurfaceFace(EnumFacing face, BlockPos position, Vec3d shapeLocus) {
            this.face = face;
            this.position = position;
            this.xNormal = -face.func_82601_c();
            this.yNormal = -face.func_96559_d();
            this.zNormal = -face.func_82599_e();
            int direction = -face.func_176743_c().func_179524_a();
            int renderDirection = face.func_176740_k().func_176722_c() ? direction : -direction;
            float xLocus = (float)position.func_177958_n() + (1.0f - this.xNormal) / 2.0f;
            float yLocus = (float)position.func_177956_o() + (1.0f - this.yNormal) / 2.0f;
            float zLocus = (float)position.func_177952_p() + (1.0f - this.zNormal) / 2.0f;
            float xShear = this.yNormal - this.zNormal;
            float yShear = this.zNormal - this.xNormal;
            float zShear = this.xNormal - this.yNormal;
            float yShearOne = xShear == 0.0f ? yShear : 0.0f;
            float yShearTwo = xShear != 0.0f ? yShear : 0.0f;
            int idx = 0;
            for (int shearOne = -renderDirection; shearOne >= -1 && shearOne < 2; shearOne += 2 * renderDirection) {
                for (int shearTwo = shearOne * renderDirection; shearTwo >= -1 && shearTwo < 2; shearTwo -= 2 * shearOne * renderDirection) {
                    float directionX = xShear * (float)shearOne;
                    float directionY = yShearOne * (float)shearOne + yShearTwo * (float)shearTwo;
                    float directionZ = zShear * (float)shearTwo;
                    float calculatedX = directionX / 2.0f + xLocus;
                    float calculatedY = directionY / 2.0f + yLocus;
                    float calculatedZ = directionZ / 2.0f + zLocus;
                    float distanceToLocusX = (float)shapeLocus.field_72450_a - calculatedX;
                    float distanceToLocusY = (float)shapeLocus.field_72448_b - calculatedY;
                    float distanceToLocusZ = (float)shapeLocus.field_72449_c - calculatedZ;
                    float descale = distanceToLocusX * distanceToLocusX + distanceToLocusY * distanceToLocusY + distanceToLocusZ * distanceToLocusZ;
                    float positionWarp = MathHelper.func_76126_a((float)((calculatedX + calculatedY + calculatedZ) * (float)Math.PI / 2.0f));
                    this.shapeData[idx++] = new float[]{calculatedX, calculatedY, calculatedZ, distanceToLocusX / descale, distanceToLocusY / descale, distanceToLocusZ / descale, positionWarp};
                }
            }
        }

        public static Set<SurfaceFace> fromPlaces(Set<BlockPos> places) {
            HashSet<SurfaceFace> faces = new HashSet<SurfaceFace>();
            if (places.isEmpty()) {
                return faces;
            }
            double total = places.size();
            int xLocus = 0;
            int yLocus = 0;
            int zLocus = 0;
            for (BlockPos pos : places) {
                xLocus += pos.func_177958_n();
                yLocus += pos.func_177956_o();
                zLocus += pos.func_177952_p();
            }
            Vec3d locus = new Vec3d((double)xLocus / total, (double)yLocus / total, (double)zLocus / total);
            for (BlockPos pos : places) {
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    VISITOR.func_181079_c(pos.func_177958_n() + facing.func_82601_c(), pos.func_177956_o() + facing.func_96559_d(), pos.func_177952_p() + facing.func_82599_e());
                    if (places.contains(VISITOR)) continue;
                    faces.add(new SurfaceFace(facing, pos, locus));
                }
            }
            return faces;
        }
    }

    private static class PhaseObject {
        public final long lastWorldTick;
        public final float when;
        public final int expiry;
        private Set<SurfaceFace> surface;

        public PhaseObject(World world, Set<BlockPos> blocks, int expiry) {
            this.surface = SurfaceFace.fromPlaces(blocks);
            this.lastWorldTick = world.func_82737_E();
            this.expiry = expiry;
            this.when = ClientTickHandler.getTicksInGame();
        }
    }
}

