/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects;

import com.google.common.base.Predicate;
import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.math.interpolate.position.InterpLine;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpColorHSV;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEffect;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.RayTrace;
import com.teamwizardry.wizardry.init.ModPotions;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@RegisterModule(ID="effect_zoom")
public class ModuleEffectZoom
implements IModuleEffect {
    private static final SpellData.DataField<Vec3d> ORIGINAL_LOC = SpellData.constructField("original_loc", Vec3d.class);

    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_extend_range"};
    }

    @Override
    public boolean run(@NotNull World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Entity entityHit = spell.getVictim(world);
        Vec3d look = spell.getData(SpellData.DefaultKeys.LOOK);
        Vec3d origin = spell.getData(SpellData.DefaultKeys.ORIGIN);
        if (entityHit == null) {
            return true;
        }
        if (!spellRing.taxCaster(world, spell, true)) {
            return false;
        }
        if (look == null) {
            return true;
        }
        if (origin == null) {
            return true;
        }
        double range = spellRing.getAttributeValue(world, AttributeRegistry.RANGE, spell);
        RayTraceResult trace = new RayTrace(world, look, origin, range).setEntityFilter((Predicate<Entity>)((Predicate)input -> input != entityHit)).setIgnoreBlocksWithoutBoundingBoxes(true).setReturnLastUncollidableBlock(false).trace();
        spell.addData(ORIGINAL_LOC, entityHit.func_174791_d());
        entityHit.func_70634_a(trace.field_72307_f.field_72450_a, trace.field_72307_f.field_72448_b, trace.field_72307_f.field_72449_c);
        entityHit.field_70159_w = 0.0;
        entityHit.field_70181_x = 0.0;
        entityHit.field_70179_y = 0.0;
        entityHit.field_70133_I = true;
        if (entityHit instanceof EntityLivingBase) {
            ((EntityLivingBase)entityHit).func_70690_d(new PotionEffect((Potion)ModPotions.NULLIFY_GRAVITY, 2, 1, true, false));
            ((EntityLivingBase)entityHit).func_70690_d(new PotionEffect((Potion)ModPotions.NULL_MOVEMENT, 2, 1, true, false));
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Entity entity = spell.getVictim(world);
        if (entity == null) {
            return;
        }
        Vec3d origin = spell.getData(ORIGINAL_LOC);
        if (origin == null) {
            return;
        }
        Vec3d to = entity.func_174791_d();
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.0f, 0.3f));
        glitter.enableMotionCalculation();
        glitter.disableRandom();
        glitter.setCollision(true);
        glitter.setTick(particle -> {
            if ((double)particle.getAge() >= (double)particle.getLifetime() / RandUtil.nextDouble(2.0, 5.0)) {
                if (particle.getAcceleration().field_72448_b == 0.0) {
                    particle.setAcceleration(new Vec3d(0.0, RandUtil.nextDouble(-0.05, -0.01), 0.0));
                }
            } else if (particle.getAcceleration().field_72450_a != 0.0 || particle.getAcceleration().field_72448_b != 0.0 || particle.getAcceleration().field_72449_c != 0.0) {
                particle.setAcceleration(Vec3d.field_186680_a);
            }
        });
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)origin.func_72441_c(0.0, (double)entity.field_70131_O / 2.0, 0.0)), (int)10, (int)0, (aFloat, particleBuilder) -> {
            glitter.setPositionOffset(new Vec3d(RandUtil.nextDouble(-0.5, 0.5), RandUtil.nextDouble(-0.5, 0.5), RandUtil.nextDouble(-0.5, 0.5)));
            ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new InterpLine(origin.func_178787_e(particleBuilder.getPositionOffset()), to.func_178787_e(particleBuilder.getPositionOffset()).func_72441_c(0.0, (double)entity.field_70131_O / 2.0, 0.0)), (int)((int)origin.func_72438_d(to) * 5), (int)0, (aFloat2, particleBuilder2) -> {
                glitter.setAlpha(RandUtil.nextFloat(0.5f, 0.8f));
                glitter.setScale(RandUtil.nextFloat(0.3f, 0.6f));
                glitter.setLifetime(RandUtil.nextInt(30, 50));
                glitter.setColorFunction((InterpFunction)new InterpColorHSV(instance.getPrimaryColor(), instance.getSecondaryColor()));
                glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.0f, 1.0f));
            });
        });
    }
}

