/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects;

import com.teamwizardry.librarianlib.features.network.PacketHandler;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEffect;
import com.teamwizardry.wizardry.api.util.BlockUtils;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.client.fx.LibParticles;
import com.teamwizardry.wizardry.common.network.PacketThriveBlock;
import com.teamwizardry.wizardry.init.ModSounds;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@RegisterModule(ID="effect_thrive")
public class ModuleEffectThrive
implements IModuleEffect {
    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_increase_potency"};
    }

    @Override
    public boolean run(@NotNull World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        BlockPos targetPos = spell.getTargetPos();
        Entity targetEntity = spell.getVictim(world);
        Entity caster = spell.getCaster(world);
        Vec3d pos = spell.getTarget(world);
        if (pos == null) {
            return true;
        }
        if (targetEntity instanceof EntityLivingBase) {
            double potency = spellRing.getAttributeValue(world, AttributeRegistry.POTENCY, spell) / 2.0f;
            if (!spellRing.taxCaster(world, spell, true)) {
                return false;
            }
            ((EntityLivingBase)targetEntity).func_70691_i((float)potency);
            world.func_184133_a(null, new BlockPos(pos), (SoundEvent)ModSounds.HEAL, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
        if (targetPos != null) {
            BlockPos otherTargetPos = spell.getTargetPos().func_177982_a(0, 1, 0);
            if (world.func_180495_p(targetPos).func_177230_c() instanceof IGrowable || world.func_180495_p(otherTargetPos).func_177230_c() instanceof IGrowable) {
                if (!spellRing.taxCaster(world, spell, true)) {
                    return false;
                }
                if (!(caster instanceof EntityPlayerMP) || BlockUtils.hasEditPermission(targetPos, (EntityPlayerMP)caster)) {
                    ItemDye.func_179234_a((ItemStack)new ItemStack(Items.field_151100_aR), (World)world, (BlockPos)targetPos);
                    ItemDye.func_179234_a((ItemStack)new ItemStack(Items.field_151100_aR), (World)world, (BlockPos)otherTargetPos);
                    PacketThriveBlock ptb = new PacketThriveBlock(targetPos);
                    PacketHandler.NETWORK.sendToAllAround((IMessage)ptb, new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)targetPos.func_177958_n(), (double)targetPos.func_177956_o(), (double)targetPos.func_177952_p(), 100.0));
                    if (!world.field_72995_K) {
                        world.func_175718_b(2005, targetPos, 0);
                        world.func_175718_b(2005, otherTargetPos, 0);
                    }
                }
            } else if (world.func_180495_p(targetPos).func_177230_c() instanceof IPlantable || world.func_180495_p(otherTargetPos).func_177230_c() instanceof IPlantable) {
                IBlockState state = world.func_180495_p(targetPos);
                Block block = state.func_177230_c();
                if (!spellRing.taxCaster(world, spell, true)) {
                    return false;
                }
                if (caster == null || caster instanceof EntityPlayer && BlockUtils.hasEditPermission(targetPos, (EntityPlayerMP)caster)) {
                    while (world.func_180495_p(targetPos.func_177984_a()).func_177230_c() == block) {
                        targetPos = targetPos.func_177984_a();
                        state = world.func_180495_p(targetPos);
                        block = state.func_177230_c();
                    }
                    world.func_189507_a(targetPos, state, RandUtil.random);
                    world.func_184133_a(null, new BlockPos(pos), (SoundEvent)ModSounds.HEAL, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                }
                state = world.func_180495_p(otherTargetPos);
                block = state.func_177230_c();
                if (caster == null || caster instanceof EntityPlayer && BlockUtils.hasEditPermission(otherTargetPos, (EntityPlayerMP)caster)) {
                    while (world.func_180495_p(otherTargetPos.func_177984_a()).func_177230_c() == block) {
                        otherTargetPos = otherTargetPos.func_177984_a();
                        state = world.func_180495_p(otherTargetPos);
                        block = state.func_177230_c();
                    }
                    world.func_189507_a(otherTargetPos, state, RandUtil.random);
                    world.func_184133_a(null, new BlockPos(pos), (SoundEvent)ModSounds.HEAL, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                }
            }
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Vec3d position = spell.getTarget(world);
        ItemDye.func_179234_a((ItemStack)new ItemStack(Items.field_151100_aR), (World)world, (BlockPos)new BlockPos(position));
        ItemDye.func_179234_a((ItemStack)new ItemStack(Items.field_151100_aR), (World)world, (BlockPos)new BlockPos(position.func_72441_c(0.0, 1.0, 0.0)));
        if (position == null) {
            return;
        }
        LibParticles.EFFECT_REGENERATE(world, position, instance.getPrimaryColor());
    }
}

