/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.wizardry.api.spell.ILingeringModule;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEffect;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.init.ModSounds;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@RegisterModule(ID="effect_poison_cloud")
public class ModuleEffectPoisonCloud
implements IModuleEffect,
ILingeringModule {
    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_increase_aoe", "modifier_increase_potency", "modifier_extend_time"};
    }

    @Override
    public boolean runOnStart(@Nonnull World world, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        return spellRing.taxCaster(world, spell, true);
    }

    @Override
    public boolean run(@NotNull World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Vec3d position = spell.getTarget(world);
        BlockPos pos = spell.getTargetPos();
        if (position == null || pos == null) {
            return true;
        }
        double potency = spellRing.getAttributeValue(world, AttributeRegistry.POTENCY, spell);
        double area = spellRing.getAttributeValue(world, AttributeRegistry.AREA, spell);
        if (world.func_82737_E() % 2L == 0L) {
            world.func_184133_a(null, pos, (SoundEvent)ModSounds.FIZZING_LOOP, SoundCategory.NEUTRAL, RandUtil.nextFloat(0.6f, 1.0f), RandUtil.nextFloat(0.1f, 4.0f));
        }
        for (Entity entity : world.func_72839_b(null, new AxisAlignedBB(new BlockPos(position)).func_72314_b(area, area, area))) {
            if (!(entity instanceof EntityLivingBase)) continue;
            EntityLivingBase living = (EntityLivingBase)entity;
            if (potency >= 3.0) {
                living.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 100));
            }
            living.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 60, (int)(potency / 3.0)));
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Vec3d position = spell.getTarget(world);
        if (position == null) {
            return;
        }
        ParticleBuilder glitter = new ParticleBuilder(0);
        if (RandUtil.nextInt(5) != 0) {
            glitter.setColor(instance.getPrimaryColor());
        } else {
            glitter.setColor(instance.getSecondaryColor());
        }
        glitter.setRender(new ResourceLocation("wizardry", "particles/smoke"));
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)position), (int)20, (int)0, (aFloat, particleBuilder) -> {
            particleBuilder.setLifetime(RandUtil.nextInt(10, 40));
            particleBuilder.setScale(RandUtil.nextFloat(5.0f, 10.0f));
            particleBuilder.setAlpha(RandUtil.nextFloat(0.3f, 0.5f));
            particleBuilder.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.3f, 0.4f));
            double area = spellRing.getAttributeValue(world, AttributeRegistry.AREA, spell);
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double r = area * (double)RandUtil.nextFloat();
            double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
            particleBuilder.setPositionOffset(new Vec3d(x, RandUtil.nextDouble(-r, r), z));
            particleBuilder.setMotion(new Vec3d(RandUtil.nextDouble(-0.01, 0.01), RandUtil.nextDouble(-0.01, 0.01), RandUtil.nextDouble(-0.01, 0.01)));
        });
    }

    @Override
    public int getLingeringTime(World world, SpellData spell, SpellRing spellRing) {
        return (int)(spellRing.getAttributeValue(world, AttributeRegistry.DURATION, spell) * 10.0f);
    }
}

