/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.wizardry.api.capability.player.mana.ManaManager;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEffect;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.init.ModSounds;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@RegisterModule(ID="effect_leech")
public class ModuleEffectLeech
implements IModuleEffect {
    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_increase_potency"};
    }

    @Override
    public boolean run(@NotNull World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Vec3d target;
        Entity targetEntity = spell.getVictim(world);
        Entity caster = spell.getCaster(world);
        double potency = spellRing.getAttributeValue(world, AttributeRegistry.POTENCY, spell);
        if (!spellRing.taxCaster(world, spell, true)) {
            return false;
        }
        if (targetEntity instanceof EntityLivingBase) {
            int invTime = targetEntity.field_70172_ad;
            targetEntity.field_70172_ad = 0;
            if (targetEntity instanceof EntityPlayer) {
                double targetMana = ManaManager.getMana(targetEntity);
                targetEntity.func_70097_a(DamageSource.field_76376_m, (float)potency);
                if (targetEntity.field_70128_L) {
                    targetMana /= 2.0;
                    targetMana = MathHelper.func_151237_a((double)targetMana, (double)targetMana, (double)(spellRing.getManaDrain(spell) * 2.0));
                    ManaManager.forObject(caster).addMana(targetMana).close();
                }
            } else if (targetEntity instanceof EntityWitch) {
                double targetMana = spellRing.getManaDrain(spell) * 2.0;
                targetEntity.func_70097_a(DamageSource.field_76376_m, (float)potency);
                if (targetEntity.field_70128_L) {
                    ManaManager.forObject(caster).addMana(targetMana).close();
                }
            } else {
                if (caster instanceof EntityLivingBase) {
                    ((EntityLivingBase)caster).func_130011_c(targetEntity);
                }
                if (caster != null) {
                    targetEntity.func_70097_a(new EntityDamageSource("magic", caster).func_76348_h().func_82726_p(), (float)potency);
                } else {
                    targetEntity.func_70097_a(DamageSource.field_76376_m, (float)potency);
                }
            }
            targetEntity.field_70172_ad = invTime;
        }
        if ((target = spell.getTargetWithFallback(world)) != null) {
            world.func_184133_a(null, new BlockPos(target), (SoundEvent)ModSounds.CHAINY_ZAP, SoundCategory.NEUTRAL, 0.5f, 1.0f);
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Vec3d position = spell.getTarget(world);
        if (position == null) {
            return;
        }
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.setCollision(true);
        glitter.setCanBounce(true);
        glitter.enableMotionCalculation();
        glitter.setAcceleration(new Vec3d(0.0, RandUtil.nextDouble(-0.05, -0.035), 0.0));
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)position), (int)80, (int)0, (i, builder) -> {
            builder.setLifetime(RandUtil.nextInt(30, 60));
            builder.addMotion(new Vec3d(RandUtil.nextDouble(-0.05, 0.05), RandUtil.nextDouble(0.01, 0.02), RandUtil.nextDouble(-0.05, 0.05)));
            builder.setScale((float)RandUtil.nextDouble(0.3, 0.5));
            builder.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.0f, 0.3f));
            builder.setColor(RandUtil.nextBoolean() ? spellRing.getPrimaryColor() : spellRing.getSecondaryColor());
        });
    }
}

