/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects;

import com.teamwizardry.wizardry.api.item.BaublesSupport;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEffect;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.client.fx.LibParticles;
import com.teamwizardry.wizardry.init.ModSounds;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

@RegisterModule(ID="effect_extract")
public class ModuleEffectExtract
implements IModuleEffect {
    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_increase_potency", "modifier_extend_time"};
    }

    private static boolean shouldContinue(Entity caster, EntityLivingBase target, ItemStack stack) {
        if (!(caster instanceof EntityLivingBase)) {
            return true;
        }
        ItemStack held = ((EntityLivingBase)caster).func_184614_ca();
        return !target.func_110124_au().equals(caster.func_110124_au()) || !ItemStack.func_77989_b((ItemStack)held, (ItemStack)stack);
    }

    @Override
    public boolean run(@NotNull World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        TileEntity tile;
        Entity caster = spell.getCaster(world);
        Entity targetEntity = spell.getVictim(world);
        BlockPos targetPos = spell.getTargetPos();
        EnumFacing facing = spell.getFaceHit();
        if (caster == null) {
            return true;
        }
        double potency = spellRing.getAttributeValue(world, AttributeRegistry.POTENCY, spell);
        double maxPotency = spellRing.getModule() != null ? (double)spellRing.getModule().getAttributeRanges().get((Object)AttributeRegistry.POTENCY).max : 0.0;
        float powerLevel = (float)(potency / maxPotency);
        double duration = spellRing.getAttributeValue(world, AttributeRegistry.DURATION, spell);
        if (targetEntity instanceof EntityLivingBase) {
            if (!spellRing.taxCaster(world, spell, true)) {
                return false;
            }
            ItemStack stack = ItemStack.field_190927_a;
            boolean success = false;
            if (!(targetEntity instanceof EntityPlayer) && (stack = ((EntityLivingBase)targetEntity).func_184614_ca()).func_190926_b()) {
                stack = ((EntityLivingBase)targetEntity).func_184592_cb();
            }
            if (!stack.func_190926_b()) {
                success = true;
            }
            if (!success) {
                ItemStack invStack;
                if ((double)powerLevel <= 0.25) {
                    if (targetEntity instanceof EntityPlayer) {
                        for (int i = ((EntityPlayer)targetEntity).field_71071_by.func_70302_i_() - 1; i > 0; --i) {
                            invStack = ((EntityPlayer)targetEntity).field_71071_by.func_70301_a(i);
                            if (invStack.func_190926_b() || !ModuleEffectExtract.shouldContinue(caster, (EntityLivingBase)targetEntity, invStack)) continue;
                            stack = invStack;
                            success = true;
                            break;
                        }
                    }
                } else if ((double)powerLevel <= 0.5) {
                    if (targetEntity instanceof EntityPlayer) {
                        for (int i = 0; i < ((EntityPlayer)targetEntity).field_71071_by.func_70302_i_(); ++i) {
                            invStack = ((EntityPlayer)targetEntity).field_71071_by.func_70301_a(i);
                            if (invStack.func_190926_b() || !ModuleEffectExtract.shouldContinue(caster, (EntityLivingBase)targetEntity, invStack)) continue;
                            stack = invStack;
                            success = true;
                            break;
                        }
                    }
                } else {
                    if ((double)powerLevel >= 0.75) {
                        for (ItemStack bauble : BaublesSupport.getAllBaubles((EntityLivingBase)targetEntity)) {
                            if (bauble.func_190926_b()) continue;
                            stack = bauble;
                            success = true;
                            break;
                        }
                    }
                    if (!success) {
                        for (ItemStack armorStack : targetEntity.func_184193_aE()) {
                            if (armorStack.func_190926_b()) continue;
                            stack = armorStack;
                            success = true;
                            break;
                        }
                    }
                    if (!success && targetEntity instanceof EntityPlayer) {
                        for (int i = 0; i < ((EntityPlayer)targetEntity).field_71071_by.func_70302_i_(); ++i) {
                            invStack = ((EntityPlayer)targetEntity).field_71071_by.func_70301_a(i);
                            if (invStack.func_190926_b() || !ModuleEffectExtract.shouldContinue(caster, (EntityLivingBase)targetEntity, invStack)) continue;
                            stack = invStack;
                            success = true;
                            break;
                        }
                    }
                }
            }
            if (!success || stack.func_190926_b()) {
                return true;
            }
            ItemStack left = stack.func_77979_a(Math.max((int)((float)stack.func_77976_d() * powerLevel), 1));
            EntityItem entityitem = new EntityItem(world, targetEntity.field_70165_t, targetEntity.field_70163_u, targetEntity.field_70161_v, left);
            entityitem.func_174867_a((int)duration);
            world.func_72838_d((Entity)entityitem);
            world.func_184133_a(null, targetEntity.func_180425_c(), (SoundEvent)ModSounds.ENCHANTED_WHASHOOSH, SoundCategory.NEUTRAL, 1.0f, RandUtil.nextFloat(0.5f, 1.5f));
            return true;
        }
        if (targetPos != null && (tile = world.func_175625_s(targetPos)) != null) {
            if (tile instanceof ILockableContainer && ((ILockableContainer)tile).func_174893_q_()) {
                return true;
            }
            if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
                IItemHandler cap = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
                if (cap == null) {
                    return true;
                }
                for (int i = 0; i < cap.getSlots(); ++i) {
                    ItemStack extracted = cap.extractItem(i, (int)potency, false);
                    if (extracted.func_190926_b()) continue;
                    if (!spellRing.taxCaster(world, spell, true)) {
                        return false;
                    }
                    Vec3d pos = new Vec3d((double)targetPos.func_177958_n(), (double)targetPos.func_177956_o(), (double)targetPos.func_177952_p()).func_72441_c(0.5, 0.5, 0.5);
                    pos = facing != null ? pos.func_178787_e(new Vec3d(facing.func_176730_m()).func_186678_a(0.5)) : pos.func_72441_c(0.0, 1.0, 0.0);
                    EntityItem entityitem = new EntityItem(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, extracted);
                    entityitem.func_174867_a((int)duration);
                    world.func_72838_d((Entity)entityitem);
                    world.func_184133_a(null, targetPos, (SoundEvent)ModSounds.ENCHANTED_WHASHOOSH, SoundCategory.NEUTRAL, 1.0f, RandUtil.nextFloat(0.5f, 1.5f));
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Vec3d position = spell.getTarget(world);
        if (position == null) {
            return;
        }
        LibParticles.EFFECT_REGENERATE(world, position, instance.getPrimaryColor());
    }
}

