/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.item.halos;

import com.teamwizardry.librarianlib.features.base.item.ItemModArmor;
import com.teamwizardry.wizardry.api.ConfigValues;
import com.teamwizardry.wizardry.api.capability.player.mana.ManaManager;
import com.teamwizardry.wizardry.api.item.halo.IHalo;
import com.teamwizardry.wizardry.init.ModBlocks;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemFakeHaloHead
extends ItemModArmor
implements IHalo {
    private boolean isInitialized = true;

    public ItemFakeHaloHead() {
        super("halo_fake", ItemArmor.ArmorMaterial.IRON, EntityEquipmentSlot.HEAD, new String[0]);
        this.func_77625_d(1);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.func_180495_p(pos).func_177230_c() == ModBlocks.ALTAR_SACRAMENT) {
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (worldIn.field_72995_K) {
            return;
        }
        try (ManaManager.CapManagerBuilder mgr = ManaManager.forObject(entityIn);){
            mgr.setMaxMana(ConfigValues.crudeHaloBufferSize);
            mgr.setMaxBurnout(ConfigValues.crudeHaloBufferSize);
            mgr.removeBurnout(mgr.getMaxBurnout() * ConfigValues.haloGenSpeed * 2.0);
        }
    }

    public final String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return new ResourceLocation("wizardry", "textures/empty.png").toString();
    }

    public void func_77624_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, @NotNull ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        tooltip.addAll(this.getHaloTooltip(stack));
    }

    @NotNull
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    @Nonnull
    public Item func_77656_e(int maxDamageIn) {
        if (!this.isInitialized) {
            return this;
        }
        return super.func_77656_e(maxDamageIn);
    }
}

