/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.item;

import com.teamwizardry.librarianlib.core.LibrarianLib;
import com.teamwizardry.librarianlib.features.base.item.ItemMod;
import com.teamwizardry.librarianlib.features.helpers.NBTHelper;
import com.teamwizardry.librarianlib.features.utilities.client.TooltipHelper;
import com.teamwizardry.wizardry.api.capability.player.mana.CustomManaCapability;
import com.teamwizardry.wizardry.api.capability.player.mana.ManaCapabilityProvider;
import com.teamwizardry.wizardry.api.item.INacreProduct;
import com.teamwizardry.wizardry.api.item.IPotionEffectExplodable;
import com.teamwizardry.wizardry.api.item.ISpellInfusable;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.SpellUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class NacrePearlSpell
extends ItemMod
implements ISpellInfusable,
IPotionEffectExplodable,
INacreProduct {
    public NacrePearlSpell() {
        super("nacre_pearl", new String[0]);
        this.func_77625_d(1);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new ManaCapabilityProvider(new CustomManaCapability(300.0, 300.0, 0.0, 0.0));
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        this.colorableOnUpdate(stack, worldIn);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        this.colorableOnEntityItemUpdate(entityItem);
        return super.onEntityItemUpdate(entityItem);
    }

    private String getNameType(@Nonnull ItemStack stack) {
        float quality = this.getQuality(stack);
        if (quality > 1.0f) {
            return "ancient";
        }
        if (quality == 1.0f) {
            return "apex";
        }
        if ((double)quality > 0.8) {
            return "potent";
        }
        if ((double)quality > 0.6) {
            return "decent";
        }
        if ((double)quality > 0.4) {
            return "flawed";
        }
        if ((double)quality > 0.2) {
            return "drained";
        }
        return "wasted";
    }

    @NotNull
    public String func_77667_c(@NotNull ItemStack stack) {
        if (!stack.func_77942_o()) {
            return super.func_77667_c(stack);
        }
        return super.func_77667_c(stack) + "." + this.getNameType(stack);
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        if (!stack.func_77942_o()) {
            return super.func_77653_i(stack);
        }
        StringBuilder finalName = null;
        List<SpellRing> spellChains = SpellUtils.getSpellChains(stack);
        for (SpellRing spellRing : spellChains) {
            if (finalName == null) {
                finalName = new StringBuilder();
            } else {
                finalName.append(" / ");
            }
            finalName.append(spellRing.toString());
        }
        if (finalName == null) {
            return super.func_77653_i(stack);
        }
        return finalName.toString();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        block15: {
            List<SpellRing> spellRings;
            block14: {
                String used;
                int i;
                if (!stack.func_77942_o()) {
                    return;
                }
                spellRings = SpellUtils.getSpellChains(stack);
                SpellRing lastRing = null;
                for (SpellRing ring : spellRings) {
                    if (lastRing == null) {
                        lastRing = ring;
                    }
                    if (ring == null) continue;
                    if (ring != lastRing) {
                        tooltip.add("");
                    }
                    SpellRing tmpRing = ring;
                    i = 0;
                    while (tmpRing != null) {
                        tooltip.add(StringUtils.repeat((String)"-", (int)i) + "> " + TextFormatting.GRAY + tmpRing.getModuleReadableName() + " - " + TextFormatting.BLUE + Math.round(tmpRing.getManaDrain(null) * tmpRing.getManaMultiplier()) + TextFormatting.GRAY + "/" + TextFormatting.RED + Math.round(tmpRing.getBurnoutFill(null) * tmpRing.getBurnoutMultiplier()));
                        if (GuiScreen.func_146272_n()) {
                            for (String key : tmpRing.getInformationTag().func_150296_c()) {
                                int value = (int)tmpRing.getInformationTag().func_74769_h(key);
                                tooltip.add(StringUtils.repeat((String)" ", (int)(i + 1)) + " | " + TextFormatting.DARK_GRAY + key + " x" + value);
                            }
                        }
                        tmpRing = tmpRing.getChildRing();
                        ++i;
                    }
                }
                if (!GuiScreen.func_146272_n() && !spellRings.isEmpty()) {
                    TooltipHelper.addToTooltip(tooltip, (String)"wizardry.misc.sneak_expanded", (Object[])new Object[0]);
                }
                if (!spellRings.isEmpty() || !(NBTHelper.getFloat((ItemStack)stack, (String)"purity_override", (float)-1.0f) < 0.0f)) break block14;
                float purity = this.getQuality(stack);
                String desc = super.func_77667_c(stack) + ".";
                if (purity >= 1.0f) {
                    desc = desc + "perfect";
                } else {
                    boolean over;
                    boolean bl = over = NBTHelper.getInt((ItemStack)stack, (String)"purity", (int)0) > 600;
                    desc = (double)purity >= 0.8333333333333334 ? (over ? desc + "over_near" : desc + "under_near") : (over ? desc + "overdone" : desc + "underdone");
                }
                desc = desc + ".desc";
                String string = used = LibrarianLib.PROXY.canTranslate(desc) ? desc : desc + "0";
                if (!LibrarianLib.PROXY.canTranslate(used)) break block15;
                TooltipHelper.addToTooltip(tooltip, (String)used, (Object[])new Object[0]);
                i = 0;
                while (LibrarianLib.PROXY.canTranslate(desc + ++i)) {
                    TooltipHelper.addToTooltip(tooltip, (String)(desc + i), (Object[])new Object[0]);
                }
                break block15;
            }
            if (spellRings.isEmpty() && this.getQuality(stack) > 1.0f) {
                String used;
                String desc = super.func_77667_c(stack) + ".ancient.desc";
                String string = used = LibrarianLib.PROXY.canTranslate(desc) ? desc : desc + "0";
                if (LibrarianLib.PROXY.canTranslate(used)) {
                    TooltipHelper.addToTooltip(tooltip, (String)used, (Object[])new Object[0]);
                    int i = 0;
                    while (LibrarianLib.PROXY.canTranslate(desc + ++i)) {
                        TooltipHelper.addToTooltip(tooltip, (String)(desc + i), (Object[])new Object[0]);
                    }
                }
            }
        }
    }

    public void func_150895_a(@Nullable CreativeTabs tab, @Nonnull NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            subItems.add((Object)new ItemStack((Item)this));
            ItemStack stack = new ItemStack((Item)this);
            NBTHelper.setFloat((ItemStack)stack, (String)"purity_override", (float)2.0f);
            subItems.add((Object)stack);
        }
    }

    @NotNull
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }
}

