/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.item;

import com.teamwizardry.librarianlib.features.base.item.IItemColorProvider;
import com.teamwizardry.librarianlib.features.base.item.ItemMod;
import com.teamwizardry.librarianlib.features.helpers.NBTHelper;
import com.teamwizardry.wizardry.api.capability.player.mana.CustomManaCapability;
import com.teamwizardry.wizardry.api.capability.player.mana.IManaCapability;
import com.teamwizardry.wizardry.api.capability.player.mana.ManaCapabilityProvider;
import com.teamwizardry.wizardry.api.capability.player.mana.ManaManager;
import com.teamwizardry.wizardry.api.entity.fairy.FairyData;
import com.teamwizardry.wizardry.common.tile.TileJar;
import com.teamwizardry.wizardry.init.ModBlocks;
import com.teamwizardry.wizardry.init.ModPotions;
import com.teamwizardry.wizardry.init.ModSounds;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kotlin.jvm.functions.Function2;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;

public class ItemJar
extends ItemMod
implements IItemColorProvider {
    public ItemJar() {
        super("jar_item", new String[]{"jar_empty", "jar_jam", "jar_fairy"});
        this.func_77625_d(1);
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        if (stack.func_77952_i() == 1) {
            return EnumAction.DRINK;
        }
        return EnumAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new ManaCapabilityProvider(new CustomManaCapability(1000.0, 1000.0, 0.0, 0.0));
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        stack.func_190918_g(1);
        if (entityLiving instanceof EntityPlayer) {
            ((EntityPlayer)entityLiving).func_191521_c(new ItemStack((Block)ModBlocks.JAR));
            EntityPlayer entityplayer = (EntityPlayer)entityLiving;
            entityplayer.func_71024_bL().func_75122_a(4, 7.0f);
            worldIn.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
            worldIn.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, (SoundEvent)ModSounds.SPARKLE, SoundCategory.PLAYERS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
            entityLiving.func_70690_d(new PotionEffect((Potion)ModPotions.NULLIFY_GRAVITY, 200, 1, true, false));
        }
        return stack;
    }

    @NotNull
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        BlockPos offset;
        IBlockState offsetState;
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77952_i() != 1 && ((offsetState = world.func_180495_p(offset = pos.func_177972_a(side))).func_177230_c().isAir(offsetState, (IBlockAccess)world, offset) || offsetState.func_177230_c().func_176200_f((IBlockAccess)world, offset))) {
            if (!world.func_190527_a((Block)ModBlocks.JAR, offset, false, side, (Entity)player)) {
                return EnumActionResult.PASS;
            }
            boolean replacable = world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos);
            boolean success = world.func_175656_a(replacable ? pos : offset, ModBlocks.JAR.func_176223_P());
            if (success) {
                TileEntity tileEntity;
                world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187567_bP, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                if ((tileEntity = world.func_175625_s(replacable ? pos : offset)) instanceof TileJar) {
                    TileJar jar = (TileJar)tileEntity;
                    jar.fairy = FairyData.deserialize(NBTHelper.getCompound((ItemStack)stack, (String)"fairy"));
                    jar.func_70296_d();
                    world.func_175664_x(replacable ? pos : offset);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77952_i() == 1) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    @Nullable
    public Function2<ItemStack, Integer, Integer> getItemColorFunction() {
        return (stack, tintIndex) -> {
            FairyData object;
            if (tintIndex == 0 && stack.func_77952_i() != 0 && (object = FairyData.deserialize(NBTHelper.getCompound((ItemStack)stack, (String)"fairy"))) != null && object.primaryColor != null) {
                return object.primaryColor.getRGB();
            }
            return 0xFFFFFF;
        };
    }

    public String func_77653_i(ItemStack stack) {
        if (stack.func_77952_i() == 2) {
            FairyData fairy = FairyData.deserialize(NBTHelper.getCompound((ItemStack)stack, (String)"fairy"));
            if (fairy == null) {
                return super.func_77653_i(stack);
            }
            IManaCapability cap = fairy.handler;
            double mana = ManaManager.getMana(cap) / ManaManager.getMaxMana(cap);
            boolean dulled = fairy.isDepressed;
            if (dulled) {
                return I18n.func_74838_a((String)"item.wizardry.fairy_jar.dulled.name").trim();
            }
            if (mana > 0.25 && mana < 0.5) {
                return I18n.func_74838_a((String)"item.wizardry.fairy_jar.barely_excited.name").trim();
            }
            if (mana >= 0.5 && mana < 0.75) {
                return I18n.func_74838_a((String)"item.wizardry.fairy_jar.moderately_excited.name").trim();
            }
            if (mana > 0.75 && mana < 1.0) {
                return I18n.func_74838_a((String)"item.wizardry.fairy_jar.very_excited.name").trim();
            }
            if (mana >= 1.0) {
                return I18n.func_74838_a((String)"item.wizardry.fairy_jar.overloaded.name").trim();
            }
            return super.func_77653_i(stack);
        }
        return super.func_77653_i(stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77952_i() == 2) {
            FairyData fairy = FairyData.deserialize(NBTHelper.getCompound((ItemStack)stack, (String)"fairy"));
            if (fairy == null) {
                return;
            }
            IManaCapability cap = fairy.handler;
            double mana = ManaManager.getMana(cap) / ManaManager.getMaxMana(cap);
            boolean dulled = fairy.isDepressed;
            if (dulled) {
                tooltip.add(I18n.func_74838_a((String)"item.wizardry.fairy_jar.dulled.info").trim());
            } else if (mana > 0.25 && mana < 0.5) {
                tooltip.add(I18n.func_74838_a((String)"item.wizardry.fairy_jar.barely_excited.info").trim());
            } else if (mana >= 0.5 && mana < 0.75) {
                tooltip.add(I18n.func_74838_a((String)"item.wizardry.fairy_jar.moderately_excited.info").trim());
            } else if (mana > 0.75 && mana < 1.0) {
                tooltip.add(I18n.func_74838_a((String)"item.wizardry.fairy_jar.very_excited.info").trim());
            } else if (mana >= 1.0) {
                tooltip.add(I18n.func_74838_a((String)"item.wizardry.fairy_jar.overloaded.info").trim());
            } else {
                super.func_77624_a(stack, worldIn, tooltip, flagIn);
            }
        } else {
            super.func_77624_a(stack, worldIn, tooltip, flagIn);
        }
    }
}

