/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.item;

import com.teamwizardry.librarianlib.features.base.item.ItemModBook;
import com.teamwizardry.librarianlib.features.gui.provided.book.IBookGui;
import com.teamwizardry.librarianlib.features.gui.provided.book.hierarchy.book.Book;
import com.teamwizardry.librarianlib.features.helpers.NBTHelper;
import com.teamwizardry.wizardry.api.spell.SpellUtils;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstance;
import com.teamwizardry.wizardry.client.gui.book.GuiBook;
import com.teamwizardry.wizardry.common.advancement.IPickupAchievement;
import com.teamwizardry.wizardry.common.advancement.ModAdvancements;
import com.teamwizardry.wizardry.init.ModItems;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;

@Mod.EventBusSubscriber(modid="wizardry")
public class ItemBook
extends ItemModBook
implements IPickupAchievement {
    public static Book BOOK;

    public ItemBook() {
        super("book", new String[0]);
        this.func_77625_d(1);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onScroll(MouseEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (Keyboard.isCreated() && event.getDwheel() != 0 && player.func_70093_af()) {
            for (EnumHand hand : EnumHand.values()) {
                ItemStack stack = player.func_184586_b(hand);
                if (stack.func_77973_b() != ModItems.BOOK) continue;
                if (!NBTHelper.getBoolean((ItemStack)stack, (String)"has_spell", (boolean)false)) {
                    return;
                }
                NBTTagList moduleList = NBTHelper.getList((ItemStack)stack, (String)"spellData", (int)8);
                if (moduleList == null) {
                    return;
                }
                if (event.getDwheel() > 0) {
                    List<List<ModuleInstance>> spellModules = SpellUtils.deserializeModuleList(moduleList);
                    List<ItemStack> spellItems = SpellUtils.getSpellItems(spellModules);
                    int page = NBTHelper.getInt((ItemStack)stack, (String)"page", (int)0);
                    int maxPages = 0;
                    int row = 0;
                    int column = 0;
                    for (int i = 0; i < spellItems.size(); ++i) {
                        if (++column >= 3) {
                            column = 0;
                            ++row;
                        }
                        if (row < 9) continue;
                        row = 0;
                        if (++maxPages <= page) continue;
                        NBTHelper.setInt((ItemStack)stack, (String)"page", (int)(page + 1));
                    }
                } else {
                    int page = NBTHelper.getInt((ItemStack)stack, (String)"page", (int)0);
                    NBTHelper.setInt((ItemStack)stack, (String)"page", (int)Math.max(page - 1, 0));
                }
                event.setCanceled(true);
            }
        }
    }

    @Override
    public Advancement getAdvancementOnPickup(ItemStack stack, EntityPlayer player, EntityItem item) {
        return ModAdvancements.BOOK;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public IBookGui createGui(@Nonnull EntityPlayer player, @Nullable World world, @Nonnull ItemStack stack) {
        return new GuiBook(BOOK, stack);
    }

    @Nonnull
    public Book getBook(@Nonnull EntityPlayer player, @Nullable World world, @Nonnull ItemStack stack) {
        return BOOK;
    }

    @NotNull
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }
}

