/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.entity;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.teamwizardry.wizardry.api.capability.world.WizardryWorldCapability;
import com.teamwizardry.wizardry.common.entity.ai.EntityAIFollowPlayer;
import com.teamwizardry.wizardry.common.entity.ai.EntityAILivingAttack;
import com.teamwizardry.wizardry.common.entity.ai.EntityAITargetFiltered;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBackupZombie
extends EntityMob {
    private static final DataParameter<Boolean> ARMS_RAISED = EntityDataManager.func_187226_a(EntityBackupZombie.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> TIMER = EntityDataManager.func_187226_a(EntityBackupZombie.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(EntityBackupZombie.class, (DataSerializer)DataSerializers.field_187203_m);

    public EntityBackupZombie(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.95f);
    }

    public EntityBackupZombie(World world, EntityLivingBase owner, int time) {
        this(world);
        this.setTime(time);
        this.setOwner(owner.func_110124_au());
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILivingAttack((EntityLivingBase)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFollowPlayer((EntityLiving)this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.applyEntityAI();
    }

    private void applyEntityAI() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityPigZombie.class}));
        this.field_70715_bh.func_75776_a(4, new EntityAITargetFiltered<Entity>((EntityLivingBase)this, EntityMob.class, false, new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                if (entity == null) {
                    return false;
                }
                if (entity.func_184212_Q().func_187231_c() == null) {
                    return false;
                }
                boolean success = false;
                for (EntityDataManager.DataEntry entry : entity.func_184212_Q().func_187231_c()) {
                    if (!entry.func_187205_a().equals((Object)OWNER)) continue;
                    success = true;
                    break;
                }
                if (!success) {
                    return false;
                }
                UUID theirOwner = null;
                Object ownerObj = entity.func_184212_Q().func_187225_a(OWNER);
                if (ownerObj != null && ownerObj instanceof Optional && ((Optional)ownerObj).isPresent() && ((Optional)ownerObj).get() instanceof UUID) {
                    theirOwner = (UUID)((Optional)entity.func_184212_Q().func_187225_a(OWNER)).orNull();
                }
                return theirOwner == null || !((Optional)EntityBackupZombie.this.func_184212_Q().func_187225_a(OWNER)).isPresent() || !theirOwner.equals(((Optional)EntityBackupZombie.this.func_184212_Q().func_187225_a(OWNER)).get());
            }
        }));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ARMS_RAISED, (Object)Boolean.FALSE);
        this.func_184212_Q().func_187214_a(TIMER, (Object)0);
        this.func_184212_Q().func_187214_a(OWNER, (Object)Optional.of((Object)UUID.randomUUID()));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isArmsRaised() {
        return (Boolean)this.func_184212_Q().func_187225_a(ARMS_RAISED);
    }

    public void setArmsRaised(boolean armsRaised) {
        this.func_184212_Q().func_187227_b(ARMS_RAISED, (Object)armsRaised);
    }

    public void setTime(int time) {
        this.func_184212_Q().func_187227_b(TIMER, (Object)time);
    }

    public void setOwner(UUID owner) {
        this.func_184212_Q().func_187227_b(OWNER, (Object)Optional.of((Object)owner));
    }

    public UUID getOwner() {
        return (UUID)((Optional)this.func_184212_Q().func_187225_a(OWNER)).get();
    }

    public void func_184206_a(@Nonnull DataParameter<?> key) {
        super.func_184206_a(key);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.func_175446_cd()) {
            return;
        }
        if (this.field_70173_aa >= (Integer)this.func_184212_Q().func_187225_a(TIMER)) {
            this.field_70170_p.func_72900_e((Entity)this);
            WizardryWorldCapability.get(this.field_70170_p).decBackupCount(this.getOwner());
        }
        UUID uuid = null;
        if (this.func_70643_av() != null) {
            uuid = this.func_70643_av().func_110124_au();
        }
        if (uuid != null && ((Optional)this.func_184212_Q().func_187225_a(OWNER)).isPresent() && uuid.equals(((Optional)this.func_184212_Q().func_187225_a(OWNER)).get())) {
            this.func_70604_c(null);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag) {
            float f = this.field_70170_p.func_175649_E(new BlockPos((Entity)this)).func_180168_b();
            if (this.func_184614_ca().func_190926_b() && this.func_70027_ad() && this.field_70146_Z.nextFloat() < f * 0.3f) {
                entityIn.func_70015_d(2 * (int)f);
            }
        }
        return flag;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187899_gZ;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187934_hh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187930_hd;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.field_187939_hm;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(this.getStepSound(), 0.15f, 1.0f);
    }

    @Nonnull
    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public float func_70047_e() {
        return 1.74f;
    }

    protected boolean func_146066_aG() {
        return false;
    }
}

