/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.core.nemez;

import com.teamwizardry.wizardry.common.core.nemez.NemezManager;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;

public class NemezTracker
implements INBTSerializable<NBTTagList> {
    public static final int MAXIMUM_MOMENTS = 6000;
    private NemezManager manager = new NemezManager();
    private Set<String> trackingEntities = new HashSet<String>();

    public Set<Entity> getTrackedEntities(World world) {
        HashSet<Entity> tracking = new HashSet<Entity>();
        for (Entity inWorld : world.field_72996_f) {
            if (!this.trackingEntities.contains(inWorld.func_189512_bd())) continue;
            tracking.add(inWorld);
        }
        return tracking;
    }

    public void trackBlock(BlockPos pos, IBlockState state) {
        this.manager.pushBlockData(pos, state);
        this.compressDownTo(6000);
    }

    public void trackEntity(Entity entity) {
        this.trackingEntities.add(entity.func_189512_bd());
        this.manager.pushEntityData(entity);
        this.compressDownTo(6000);
    }

    public boolean hasNext() {
        return this.manager.peekAtMoment() != null;
    }

    public void endUpdate() {
        this.manager.pushMoment();
    }

    public void erase() {
        this.manager.erase();
    }

    public void collapse() {
        this.manager.collapse();
    }

    public boolean needsCompression(int maximumMoments) {
        return this.manager.needsCompression(maximumMoments);
    }

    public void compressDownTo(int maximumMoments) {
        if (this.needsCompression(maximumMoments)) {
            this.manager.compressDownTo(maximumMoments);
        }
    }

    public NemezTracker snapshot() {
        this.compressDownTo(6000);
        NemezTracker manager = new NemezTracker();
        manager.manager = this.manager.snapshot();
        manager.trackingEntities = new HashSet<String>(this.trackingEntities);
        return manager;
    }

    public void applySnapshot(World world) {
        this.manager.popMoment().apply(world, this.getTrackedEntities(world));
    }

    public void applySnapshot(World world, float partialTicks) {
        if (partialTicks == 0.0f) {
            this.applySnapshot(world);
            return;
        }
        this.manager.peekAtMoment().apply(world, this.getTrackedEntities(world), partialTicks);
    }

    public NBTTagList nextNMoments(int seconds) {
        return this.manager.serializeFirstN(seconds);
    }

    public void absorb(NBTTagList data) {
        this.manager.absorb(data);
    }

    public NBTTagList serializeNBT() {
        return this.manager.serializeNBT();
    }

    public void deserializeNBT(NBTTagList nbt) {
        this.manager.deserializeNBT(nbt);
    }
}

