/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.client.render.item;

import com.teamwizardry.librarianlib.core.LibrarianLib;
import com.teamwizardry.librarianlib.features.animator.Animation;
import com.teamwizardry.librarianlib.features.animator.Animator;
import com.teamwizardry.librarianlib.features.animator.Easing;
import com.teamwizardry.librarianlib.features.animator.animations.BasicAnimation;
import com.teamwizardry.librarianlib.features.helpers.NBTHelper;
import com.teamwizardry.librarianlib.features.sprite.Sprite;
import com.teamwizardry.wizardry.Wizardry;
import com.teamwizardry.wizardry.api.spell.SpellUtils;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstance;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.client.gui.book.GuiBook;
import com.teamwizardry.wizardry.init.ModItems;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelBook;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="wizardry")
@SideOnly(value=Side.CLIENT)
public class RenderCodex {
    private static final ModelBook model = new ModelBook();
    private static final ResourceLocation texture = new ResourceLocation("wizardry", "textures/model/book.png");
    private static final Sprite arrowSprite = new Sprite(new ResourceLocation("wizardry", "textures/gui/arrow.png"));
    public static RenderCodex INSTANCE = new RenderCodex();
    public Animator animator = new Animator();
    public float openingCooldownLeft = 0.0f;
    public float tooltipCooldown = 40.0f;
    public float idleXLeft = 0.0f;
    public float idleYLeft = 0.0f;
    public float idleZLeft = 0.0f;
    public float openingCooldownRight = 0.0f;
    public float pageFlipCooldownRight = 0.0f;
    public float idleXRight = 0.0f;
    public float idleYRight = 0.0f;
    public float idleZRight = 0.0f;
    private Set<String> animatingFields = new HashSet<String>();

    private RenderCodex() {
    }

    @SubscribeEvent
    public static void renderItem(RenderSpecificHandEvent evt) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74320_O != 0 || mc.field_71439_g.func_184586_b(evt.getHand()).func_190926_b() || mc.field_71439_g.func_184586_b(evt.getHand()).func_77973_b() != ModItems.BOOK) {
            return;
        }
        evt.setCanceled(true);
        try {
            RenderCodex.renderItemInFirstPerson((AbstractClientPlayer)mc.field_71439_g, evt.getHand(), evt.getSwingProgress(), evt.getItemStack(), evt.getEquipProgress());
        }
        catch (Throwable throwable) {
            Wizardry.LOGGER.warn("Failed to render book in hand");
        }
    }

    private static void renderItemInFirstPerson(AbstractClientPlayer player, EnumHand hand, float swingProgress, ItemStack stack, float equipProgress) {
        boolean flag = hand == EnumHand.MAIN_HAND;
        EnumHandSide enumhandside = flag ? player.func_184591_cq() : player.func_184591_cq().func_188468_a();
        GlStateManager.func_179094_E();
        boolean flag1 = enumhandside == EnumHandSide.RIGHT;
        float f = -0.4f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * (float)Math.PI));
        float f1 = 0.2f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * ((float)Math.PI * 2)));
        float f2 = -0.2f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
        int i = flag1 ? 1 : -1;
        GlStateManager.func_179109_b((float)((float)i * f), (float)f1, (float)f2);
        RenderCodex.transformSideFirstPerson(enumhandside, equipProgress);
        RenderCodex.transformFirstPerson(enumhandside, swingProgress);
        INSTANCE.doRender(enumhandside, stack);
        GlStateManager.func_179121_F();
    }

    private static void transformSideFirstPerson(EnumHandSide p_187459_1_, float p_187459_2_) {
        int i = p_187459_1_ == EnumHandSide.RIGHT ? 1 : -1;
        GlStateManager.func_179109_b((float)((float)i * 0.56f), (float)(-0.44f + p_187459_2_ * -0.8f), (float)-0.72f);
    }

    private static void transformFirstPerson(EnumHandSide p_187453_1_, float p_187453_2_) {
        int i = p_187453_1_ == EnumHandSide.RIGHT ? 1 : -1;
        GlStateManager.func_179109_b((float)(p_187453_1_ == EnumHandSide.RIGHT ? 0.2f : 0.52f), (float)-0.125f, (float)(p_187453_1_ == EnumHandSide.RIGHT ? 0.6f : 0.25f));
        GlStateManager.func_179114_b((float)(p_187453_1_ == EnumHandSide.RIGHT ? 60.0f : 120.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)30.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
        float f = MathHelper.func_76126_a((float)(p_187453_2_ * p_187453_2_ * (float)Math.PI));
        GlStateManager.func_179114_b((float)((float)i * (45.0f + f * -20.0f)), (float)0.0f, (float)1.0f, (float)0.0f);
        float f1 = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)p_187453_2_) * (float)Math.PI));
        GlStateManager.func_179114_b((float)((float)i * f1 * -20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)(f1 * -80.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)i * -45.0f), (float)0.0f, (float)1.0f, (float)0.0f);
    }

    private void doRender(EnumHandSide side, ItemStack stack) {
        BasicAnimation anim;
        String openingTag;
        Minecraft mc = Minecraft.func_71410_x();
        boolean isGuiOpen = mc.field_71462_r instanceof GuiBook;
        boolean rightHand = side == EnumHandSide.RIGHT;
        boolean hasSpell = NBTHelper.getBoolean((ItemStack)stack, (String)"has_spell", (boolean)false);
        String openingTagRight = "openingCooldownRight";
        String openingTagLeft = "openingCooldownLeft";
        String string = openingTag = rightHand ? "openingCooldownRight" : "openingCooldownLeft";
        if (isGuiOpen || hasSpell) {
            if (!this.animatingFields.contains(openingTag)) {
                this.animatingFields.add(openingTag);
                anim = new BasicAnimation((Object)INSTANCE, openingTag);
                anim.setTo((Object)10);
                anim.setDuration(20.0f);
                anim.setEasing((Easing)Easing.easeOutCubic);
                anim.setCompletion(() -> this.animatingFields.remove(openingTag));
                this.animator.add(new Animation[]{anim});
            }
        } else if (!this.animatingFields.contains(openingTag)) {
            this.animatingFields.add(openingTag);
            anim = new BasicAnimation((Object)INSTANCE, openingTag);
            anim.setTo((Object)0);
            anim.setDuration(20.0f);
            anim.setEasing((Easing)Easing.easeOutCubic);
            anim.setCompletion(() -> this.animatingFields.remove(openingTag));
            this.animator.add(new Animation[]{anim});
        }
        this.animateIdle("idleXRight");
        this.animateIdle("idleYRight");
        this.animateIdle("idleZRight");
        this.animateIdle("idleXLeft");
        this.animateIdle("idleYLeft");
        this.animateIdle("idleZLeft");
        GlStateManager.func_179094_E();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        double flip = rightHand ? 1.0 : -1.0;
        float openingCooldown = rightHand ? this.openingCooldownRight : this.openingCooldownLeft;
        float idleX = rightHand ? this.idleXRight : this.idleXLeft;
        float idleY = rightHand ? this.idleYRight : this.idleYLeft;
        float idleZ = rightHand ? this.idleZRight : this.idleZLeft;
        GlStateManager.func_179137_b((double)((double)(0.3f + 0.02f * openingCooldown) + (double)openingCooldown / 50.0 + (double)((10.0f - openingCooldown) / 50.0f) + (double)(rightHand ? -0.1f : 0.0f)), (double)(0.475f + 0.01f * openingCooldown + (!rightHand ? 0.02f : 0.0f) + (10.0f - openingCooldown) / 100.0f), (double)((double)(-0.2f - (rightHand ? 0.035f : 0.01f) * openingCooldown) + flip * (double)openingCooldown / 50.0 + (double)(!rightHand ? openingCooldown / 10.0f * 0.08f - 0.03f : 0.0f)));
        GlStateManager.func_179114_b((float)((rightHand ? 87.5f : openingCooldown / 10.0f * -20.0f + 90.0f) + openingCooldown * (float)(rightHand ? 8 : 12) + idleY * 5.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(idleZ * 5.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(texture);
        model.func_78088_a(null, 0.0f, 0.0f, this.pageFlipCooldownRight, openingCooldown / 12.0f, 0.0f, 0.0625f);
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        boolean prevFlag = font.func_82883_a();
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (openingCooldown < 3.0f) {
            String[] title;
            font.func_78264_a(false);
            GlStateManager.func_179094_E();
            GlStateManager.func_179140_f();
            GlStateManager.func_179109_b((float)-0.3f, (float)-0.24f, (float)-0.07f);
            GlStateManager.func_179152_a((float)0.003f, (float)0.003f, (float)-0.003f);
            GlStateManager.func_179109_b((float)-2.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)(70 - font.field_78288_b), (float)0.0f);
            for (String aTitle : title = LibrarianLib.PROXY.translate("wizardry.book.title", new Object[0]).split(" ")) {
                GlStateManager.func_179109_b((float)0.0f, (float)font.field_78288_b, (float)0.0f);
                String titleText = font.func_78269_a(aTitle, 80);
                int width = font.func_78256_a(titleText);
                int max = 80;
                double x = (double)max / 2.0 - (double)width / 2.0;
                GlStateManager.func_179137_b((double)x, (double)0.0, (double)0.0);
                font.func_78276_b(titleText, 0, 0, 65535);
                GlStateManager.func_179137_b((double)(-x), (double)0.0, (double)0.0);
            }
            GlStateManager.func_179109_b((float)0.0f, (float)font.field_78288_b, (float)0.0f);
            String subtitle = font.func_78269_a(LibrarianLib.PROXY.translate("wizardry.book.subtitle", new Object[0]), 80);
            double scale = 2.6;
            GlStateManager.func_179137_b((double)((double)(80.0f - (float)font.func_78256_a(subtitle)) * scale), (double)0.0, (double)0.0);
            GlStateManager.func_179152_a((float)0.6f, (float)0.6f, (float)0.6f);
            font.func_78276_b(TextFormatting.ITALIC + subtitle, 0, 0, 65535);
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
        }
        if (hasSpell && openingCooldown > 6.0f) {
            font.func_78264_a(true);
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)60.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)0.0, (double)0.1, (double)0.0);
            GlStateManager.func_179109_b((float)-0.3f, (float)-0.24f, (float)-0.07f);
            GlStateManager.func_179152_a((float)0.003f, (float)0.003f, (float)-0.003f);
            GlStateManager.func_179109_b((float)-10.0f, (float)-30.0f, (float)-5.0f);
            if (rightHand) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)-30.0f, (float)-25.0f, (float)-30.0f);
                this.drawTooltip(font, LibrarianLib.PROXY.translate("wizardry.book.shift_scroll", new Object[0]), LibrarianLib.PROXY.translate("wizardry.book.open_recipe_tab", new Object[0]));
                GlStateManager.func_179121_F();
            }
            String[] lines = this.getSpellStructureLines(stack);
            for (int i = 0; i < lines.length; ++i) {
                font.func_78276_b(lines[i], 0, i * font.field_78288_b, 0);
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)120.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)0.0, (double)0.1, (double)0.0);
            GlStateManager.func_179109_b((float)-0.3f, (float)-0.24f, (float)-0.07f);
            GlStateManager.func_179152_a((float)0.003f, (float)0.003f, (float)-0.003f);
            GlStateManager.func_179109_b((float)120.0f, (float)-25.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)-5.0f, (float)-5.0f, (float)0.0f);
            if (!rightHand) {
                this.drawTooltip(font, LibrarianLib.PROXY.translate("wizardry.book.shift_scroll", new Object[0]), LibrarianLib.PROXY.translate("wizardry.book.open_recipe_tab", new Object[0]));
            }
            List<ItemStack> inventory = this.getSpellInventory(stack);
            int currentPage = NBTHelper.getInt((ItemStack)stack, (String)"page", (int)0);
            int row = 0;
            int column = 0;
            int pageNb = 0;
            for (int i = 0; i < inventory.size(); ++i) {
                ItemStack recipeStack = inventory.get(i);
                if (recipeStack.func_190926_b()) continue;
                if (pageNb >= currentPage) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)(column * 32), (float)(row * 16), (float)-150.0f);
                    this.renderItemStack(recipeStack);
                    GlStateManager.func_179121_F();
                    if (i != inventory.size() - 1 && column < 3) {
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179109_b((float)(32 + column * 32), (float)(row * 16 + 13), (float)0.0f);
                        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GlStateManager.func_179131_c((float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        GlStateManager.func_179140_f();
                        arrowSprite.bind();
                        arrowSprite.draw(0, 0.0f, 0.0f, 16.0f, 8.0f);
                        GlStateManager.func_179145_e();
                        GlStateManager.func_179121_F();
                    }
                }
                if (++column >= 3) {
                    column = 0;
                    ++row;
                }
                if (row < 9) continue;
                row = 0;
                if (++pageNb > currentPage) break;
            }
            GlStateManager.func_179121_F();
        }
        font.func_78264_a(prevFlag);
        GlStateManager.func_179121_F();
    }

    public void drawTooltip(FontRenderer font, String ... text) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)-25.0f, (float)0.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        boolean previousUnicode = font.func_82883_a();
        font.func_78264_a(false);
        int backgroundColor = -267386864;
        int longestWidth = 0;
        for (String string : text) {
            int width = font.func_78256_a(string);
            if (width <= longestWidth) continue;
            longestWidth = width;
        }
        int tooltipTextWidth = longestWidth;
        int tooltipHeight = 8 * text.length;
        GuiUtils.drawGradientRect((int)0, (int)-3, (int)-4, (int)(tooltipTextWidth + 3), (int)-3, (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)0, (int)-3, (int)(tooltipHeight + 3), (int)(tooltipTextWidth + 3), (int)(tooltipHeight + 4), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)0, (int)-3, (int)-3, (int)(tooltipTextWidth + 3), (int)(tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)0, (int)-4, (int)-3, (int)-3, (int)(tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)0, (int)(tooltipTextWidth + 3), (int)-3, (int)(tooltipTextWidth + 4), (int)(tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        int borderColorStart = 0x505000FF;
        int borderColorEnd = 1344798847;
        GuiUtils.drawGradientRect((int)0, (int)-3, (int)-2, (int)-2, (int)(tooltipHeight + 3 - 1), (int)0x505000FF, (int)1344798847);
        GuiUtils.drawGradientRect((int)0, (int)(tooltipTextWidth + 2), (int)-2, (int)(tooltipTextWidth + 3), (int)(tooltipHeight + 3 - 1), (int)0x505000FF, (int)1344798847);
        GuiUtils.drawGradientRect((int)0, (int)-3, (int)-3, (int)(tooltipTextWidth + 3), (int)-2, (int)0x505000FF, (int)0x505000FF);
        GuiUtils.drawGradientRect((int)0, (int)-3, (int)(tooltipHeight + 2), (int)(tooltipTextWidth + 3), (int)(tooltipHeight + 3), (int)1344798847, (int)1344798847);
        for (int i = 0; i < text.length; ++i) {
            String string = text[i];
            font.func_175063_a(string, 0.0f, (float)(i * 8), 16766720);
        }
        font.func_78264_a(previousUnicode);
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179101_C();
        GlStateManager.func_179098_w();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    public void animateIdle(String tag) {
        if (!this.animatingFields.contains(tag) && RandUtil.nextBoolean()) {
            this.animatingFields.add(tag);
            BasicAnimation anim = new BasicAnimation((Object)INSTANCE, tag);
            anim.setTo((Object)Float.valueOf(RandUtil.nextFloat(0.0f, 1.0f)));
            anim.setDuration((float)RandUtil.nextInt(80, 120));
            anim.setEasing((Easing)Easing.easeInOutSine);
            anim.setCompletion(() -> this.animatingFields.remove(tag));
            this.animator.add(new Animation[]{anim});
        }
    }

    public String[] getSpellStructureLines(ItemStack stack) {
        NBTTagList moduleList = NBTHelper.getList((ItemStack)stack, (String)"spellData", (int)8);
        if (moduleList == null) {
            return new String[0];
        }
        List<List<ModuleInstance>> spellModules = SpellUtils.deserializeModuleList(moduleList);
        spellModules = SpellUtils.getEssentialModules(spellModules);
        int page = NBTHelper.getInt((ItemStack)stack, (String)"page", (int)0);
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int widthOfSpace = fr.func_78256_a(" ");
        StringBuilder builder = new StringBuilder("Spell Structure:\n");
        for (List<ModuleInstance> spellModuleList : spellModules) {
            String margin = null;
            for (ModuleInstance module : spellModuleList) {
                if (margin == null) {
                    margin = " - ";
                    builder.append(margin).append(module.getReadableName()).append("\n");
                    continue;
                }
                int realLength = fr.func_78256_a(margin);
                int nbOfSpace = MathHelper.func_76125_a((int)(realLength / widthOfSpace), (int)0, (int)17);
                margin = StringUtils.repeat((String)" ", (int)nbOfSpace) + "|_ ";
                builder.append(margin).append(module.getReadableName()).append("\n");
                if (nbOfSpace < 16) continue;
                builder.append("   ________________|").append("\n");
                margin = "   ";
            }
        }
        String[] lines = builder.toString().split("\n");
        StringBuilder pageChunk = new StringBuilder();
        int count = 0;
        int currentPage = 0;
        for (String line : lines) {
            pageChunk.append(line).append("\n");
            if (++count < 16) continue;
            count = 0;
            if (currentPage >= page) {
                return pageChunk.toString().split("\n");
            }
            pageChunk = new StringBuilder();
        }
        return pageChunk.toString().split("\n");
    }

    public List<ItemStack> getSpellInventory(ItemStack stack) {
        if (!NBTHelper.getBoolean((ItemStack)stack, (String)"has_spell", (boolean)false)) {
            return new ArrayList<ItemStack>();
        }
        NBTTagList spellList = NBTHelper.getList((ItemStack)stack, (String)"spellData", (int)8);
        if (spellList == null) {
            return new ArrayList<ItemStack>();
        }
        return SpellUtils.getSpellItems(SpellUtils.deserializeModuleList(spellList));
    }

    public void renderItemStack(ItemStack stack) {
        EntityPlayerSP entityplayersp;
        float f3;
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179091_B();
        GlStateManager.func_179094_E();
        RenderItem itemRender = Minecraft.func_71410_x().func_175599_af();
        itemRender.func_180450_b(stack, 0, 0);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)150.0f);
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = Minecraft.func_71410_x().field_71466_p;
        }
        if (font != null && stack.func_190916_E() != 1) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)5.0f);
            GlStateManager.func_179140_f();
            GlStateManager.func_179084_k();
            font.func_175063_a(stack.func_190916_E() + "", 17.0f - (float)font.func_78256_a(stack.func_190916_E() + ""), 9.0f, 0xFFFFFF);
            GlStateManager.func_179126_j();
            GlStateManager.func_179147_l();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-5.0f);
        }
        if (stack.func_77973_b().showDurabilityBar(stack)) {
            GlStateManager.func_179140_f();
            GlStateManager.func_179090_x();
            GlStateManager.func_179118_c();
            GlStateManager.func_179084_k();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            double health = stack.func_77973_b().getDurabilityForDisplay(stack);
            int rgbfordisplay = stack.func_77973_b().getRGBDurabilityForDisplay(stack);
            int i = Math.round(13.0f - (float)health * 13.0f);
            this.draw(bufferbuilder, 2, 13, 13, 2, 0, 0, 0, 255);
            this.draw(bufferbuilder, 2, 13, i, 1, rgbfordisplay >> 16 & 0xFF, rgbfordisplay >> 8 & 0xFF, rgbfordisplay & 0xFF, 255);
            GlStateManager.func_179147_l();
            GlStateManager.func_179141_d();
            GlStateManager.func_179098_w();
            GlStateManager.func_179145_e();
        }
        float f = f3 = (entityplayersp = Minecraft.func_71410_x().field_71439_g) == null ? 0.0f : entityplayersp.func_184811_cZ().func_185143_a(stack.func_77973_b(), Minecraft.func_71410_x().func_184121_ak());
        if (f3 > 0.0f) {
            GlStateManager.func_179140_f();
            GlStateManager.func_179090_x();
            Tessellator tessellator1 = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder1 = tessellator1.func_178180_c();
            this.draw(bufferbuilder1, 0, MathHelper.func_76141_d((float)(16.0f * (1.0f - f3))), 16, MathHelper.func_76123_f((float)(16.0f * f3)), 255, 255, 255, 127);
            GlStateManager.func_179098_w();
            GlStateManager.func_179145_e();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179101_C();
    }

    private void draw(BufferBuilder renderer, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        renderer.func_181662_b((double)x, (double)y, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)x, (double)(y + height), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)(x + width), (double)y, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }
}

