/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.client.gui.worktable2;

import com.teamwizardry.librarianlib.features.animator.Easing;
import com.teamwizardry.librarianlib.features.eventbus.Hook;
import com.teamwizardry.librarianlib.features.facade.component.GuiComponent;
import com.teamwizardry.librarianlib.features.facade.component.GuiComponentEvents;
import com.teamwizardry.librarianlib.features.facade.component.GuiLayer;
import com.teamwizardry.librarianlib.features.facade.layers.RectLayer;
import com.teamwizardry.librarianlib.features.facade.layers.SpriteLayer;
import com.teamwizardry.librarianlib.features.facade.layers.TextLayer;
import com.teamwizardry.librarianlib.features.math.Align2d;
import com.teamwizardry.librarianlib.features.math.Vec2d;
import com.teamwizardry.librarianlib.features.sprite.ISprite;
import com.teamwizardry.librarianlib.features.sprite.Sprite;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstance;
import com.teamwizardry.wizardry.api.spell.module.ModuleRegistry;
import com.teamwizardry.wizardry.api.spell.module.ModuleType;
import com.teamwizardry.wizardry.client.gui.worktable2.IRevealable;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public class ComponentModuleSelectionMenu
extends GuiComponent
implements IRevealable {
    private static final Sprite PLATE = new Sprite(new ResourceLocation("wizardry", "textures/gui/worktable/plate.png"));
    private static final Sprite PLATE_HIGHLIGHTED = new Sprite(new ResourceLocation("wizardry", "textures/gui/worktable/plate_highlighted.png"));
    private final ComponentModuleSelector selectShapes = new ComponentModuleSelector(ModuleType.SHAPE);
    private final ComponentModuleSelector selectEffects = new ComponentModuleSelector(ModuleType.EFFECT);
    private final ComponentModuleTypeSelector effects = new ComponentModuleTypeSelector(ModuleType.EFFECT);
    private final ComponentModuleTypeSelector shapes = new ComponentModuleTypeSelector(ModuleType.SHAPE);
    private final RectLayer bg = new RectLayer(Color.GRAY);

    public ComponentModuleSelectionMenu() {
        this.setClipToBounds(true);
        this.shapes.BUS.hook(GuiComponentEvents.MouseClickEvent.class, e -> {
            this.shapes.hide(() -> {});
            this.effects.hide(() -> this.selectShapes.reveal(() -> {}));
        });
        this.effects.BUS.hook(GuiComponentEvents.MouseClickEvent.class, e -> {
            this.shapes.hide(() -> {});
            this.effects.hide(() -> this.selectEffects.reveal(() -> {}));
        });
        this.add(new GuiLayer[]{this.shapes, this.effects, this.selectEffects, this.selectShapes});
    }

    public void layoutChildren() {
        super.layoutChildren();
        this.bg.setSize(this.getSize());
        this.shapes.setPos(new Vec2d(0.0, this.shapes.getY()));
        this.shapes.setSize(new Vec2d(this.getWidth() / 2.0 - 5.0, this.getHeight()));
        this.effects.setPos(new Vec2d(this.getWidth() / 2.0 + 5.0, this.effects.getY()));
        this.effects.setSize(new Vec2d(this.getWidth() / 2.0, this.getHeight()));
        this.selectShapes.setSize(this.getSize());
        this.selectEffects.setSize(this.getSize());
    }

    @Override
    public void reveal(Runnable onComplete) {
        this.setVisible(true);
        this.shapes.reveal(() -> {});
        this.effects.reveal(() -> {});
    }

    @Override
    public void hide(Runnable onComplete) {
        this.getPos_rm().animate((Object)Vec2d.ZERO, (Object)new Vec2d(0.0, this.getHeight()), 10.0f, (Easing)Easing.easeInCubic).completion(onComplete);
    }

    private static class ComponentModuleTypeSelector
    extends GuiComponent
    implements IRevealable {
        private final ModuleType type;
        private final RectLayer bg;
        private final TextLayer text;

        private ComponentModuleTypeSelector(ModuleType type) {
            this.setVisible(false);
            this.type = type;
            this.bg = new RectLayer(Color.GREEN);
            this.add(new GuiLayer[]{this.bg});
            this.text = new TextLayer(type.name.toUpperCase());
            this.text.setAlign(Align2d.CENTER);
            this.add(new GuiLayer[]{this.text});
        }

        @Override
        public void hide(Runnable onComplete) {
            this.getPos_rm().animate((Object)Vec2d.ZERO, (Object)new Vec2d(0.0, this.getHeight()), 10.0f, (Easing)Easing.easeInCubic).completion(onComplete);
        }

        @Override
        public void reveal(Runnable onComplete) {
            this.setVisible(true);
            this.getPos_rm().animate((Object)new Vec2d(0.0, this.getHeight()), (Object)Vec2d.ZERO, 15.0f, (Easing)Easing.easeOutQuart).completion(onComplete);
        }

        @Hook
        private void mouseOut(GuiComponentEvents.MouseLeaveEvent e) {
            this.bg.setColor(Color.GREEN);
        }

        @Hook
        private void mouseIn(GuiComponentEvents.MouseEnterEvent e) {
            this.bg.setColor(Color.YELLOW);
        }

        public void layoutChildren() {
            super.layoutChildren();
            this.bg.setSize(this.getSize());
            this.text.setSize(this.getSize());
        }
    }

    private static class ComponentModuleSelector
    extends GuiComponent
    implements IRevealable {
        private final ModuleType type;
        private final RectLayer bg;
        private final TextLayer text;
        private final List<ComponentModule> modules = new ArrayList<ComponentModule>();

        private ComponentModuleSelector(ModuleType type) {
            this.setVisible(false);
            this.type = type;
            this.bg = new RectLayer(Color.PINK);
            this.add(new GuiLayer[]{this.bg});
            this.text = new TextLayer(type.name.toUpperCase());
            this.text.setAlign(Align2d.TOP_CENTER);
            this.text.setScale(1.0);
            this.add(new GuiLayer[]{this.text});
            for (ModuleInstance module : ModuleRegistry.INSTANCE.getModules(type)) {
                ComponentModule componentModule = new ComponentModule(module);
                this.modules.add(componentModule);
                this.add(new GuiLayer[]{componentModule});
            }
        }

        @Override
        public void hide(Runnable onComplete) {
            this.getPos_rm().animate((Object)Vec2d.ZERO, (Object)new Vec2d(0.0, this.getHeight()), 10.0f, (Easing)Easing.easeInCubic).completion(onComplete);
        }

        @Override
        public void reveal(Runnable onComplete) {
            this.setVisible(true);
            this.getPos_rm().animate((Object)new Vec2d(0.0, this.getHeight()), (Object)Vec2d.ZERO, 15.0f, (Easing)Easing.easeOutQuart).completion(onComplete);
            int maxColumns = 8;
            int maxRows = 0;
            for (int i = 0; i < this.modules.size(); ++i) {
                if (i == 0 || i % 8 != 0) continue;
                ++maxRows;
            }
            int spacing = 5;
            double maxWidth = 8 * PLATE.getWidth() + 40;
            double maxHeight = maxRows * PLATE.getHeight() + maxRows * 5;
            double centerX = this.getWidth() / 2.0 - maxWidth / 2.0;
            double centerY = this.getHeight() / 2.0 - maxHeight / 2.0;
            int r = 0;
            int c = 0;
            for (int i = 0; i < this.modules.size(); ++i) {
                ComponentModule module = this.modules.get(i);
                if (i != 0 && i % 8 == 0) {
                    c = 0;
                    ++r;
                } else if (i != 0) {
                    ++c;
                }
                Vec2d pos = new Vec2d(centerX + (double)(c * PLATE.getWidth()) + (double)(c * 5), centerY + (double)(r * PLATE.getHeight()) + (double)(r * 5));
                module.getPos_rm().animate((Object)pos.add(0.0, this.getHeight()), (Object)pos, (float)(10 + i), (Easing)Easing.easeOutQuart);
            }
        }

        public void layoutChildren() {
            super.layoutChildren();
            this.bg.setSize(this.getSize());
            this.text.setSize(this.getSize());
        }
    }

    private static class ComponentModule
    extends GuiComponent {
        @Nullable
        private static ModuleInstance selectedModule = null;
        private final ModuleInstance module;
        private final SpriteLayer plateLayer = new SpriteLayer();
        private final SpriteLayer iconLayer = new SpriteLayer();

        ComponentModule(ModuleInstance module) {
            this.setVisible(true);
            this.module = module;
            this.plateLayer.setSprite((ISprite)PLATE);
            this.iconLayer.setSprite((ISprite)new Sprite(module.getIconLocation()));
            this.add(new GuiLayer[]{this.plateLayer, this.iconLayer});
        }

        @Hook
        private void mouseOut(GuiComponentEvents.MouseLeaveEvent e) {
            if (selectedModule == this.module) {
                this.plateLayer.setSprite((ISprite)PLATE_HIGHLIGHTED);
            } else {
                this.plateLayer.setSprite((ISprite)PLATE);
            }
        }

        @Hook
        private void mouseIn(GuiComponentEvents.MouseEnterEvent e) {
            this.plateLayer.setSprite((ISprite)PLATE_HIGHLIGHTED);
        }

        @Hook
        private void click(GuiComponentEvents.MouseClickEvent e) {
            selectedModule = selectedModule == this.module ? null : this.module;
        }

        public void layoutChildren() {
            super.layoutChildren();
            this.setSize(this.plateLayer.getSize());
            this.iconLayer.setSize(this.plateLayer.getSize());
        }
    }
}

