/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.client.core.renderer;

import com.teamwizardry.librarianlib.features.sprite.Sprite;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(modid="wizardry", value={Side.CLIENT})
@SideOnly(value=Side.CLIENT)
public class StructureErrorRenderer {
    private static final Sprite particle = new Sprite(new ResourceLocation("wizardry", "textures/particles/sparkle_blurred.png"));
    private static final List<ParticleError> errors = new ArrayList<ParticleError>();
    private static final Deque<ParticleError> adds = new ArrayDeque<ParticleError>();

    public static void addError(@Nonnull BlockPos pos) {
        for (ParticleError error : errors) {
            if (error == null || !error.pos.equals((Object)pos)) continue;
            return;
        }
        for (ParticleError error : adds) {
            if (error == null || !error.pos.equals((Object)pos)) continue;
            return;
        }
        adds.add(new ParticleError(pos, 100));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void tick(TickEvent.ClientTickEvent event) {
        ParticleError entry2;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        while ((entry2 = adds.pollFirst()) != null) {
            errors.add(entry2);
        }
        errors.removeIf(entry -> --entry.tick <= 0);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void render(RenderWorldLastEvent event) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (Minecraft.func_71410_x().func_175598_ae().field_78733_k == null) {
            return;
        }
        for (ParticleError error : errors) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            double interpPosX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
            double interpPosY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
            double interpPosZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
            GlStateManager.func_179137_b((double)((double)error.pos.func_177958_n() + 0.5), (double)((double)error.pos.func_177956_o() + 0.5), (double)((double)error.pos.func_177952_p() + 0.5));
            GlStateManager.func_179114_b((float)(-Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)(Minecraft.func_71410_x().func_175598_ae().field_78733_k.field_74320_O == 2 ? -1 : 1) * Minecraft.func_71410_x().func_175598_ae().field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)-0.25, (double)-0.25, (double)-0.25);
            GlStateManager.func_179097_i();
            GlStateManager.func_179129_p();
            GlStateManager.func_179147_l();
            GlStateManager.func_179098_w();
            GlStateManager.func_179142_g();
            int alphaFunc = GL11.glGetInteger((int)3009);
            float alphaRef = GL11.glGetFloat((int)3010);
            int blendSrc = GL11.glGetInteger((int)3041);
            int blendDst = GL11.glGetInteger((int)3040);
            GlStateManager.func_179092_a((int)519, (float)1.0f);
            GlStateManager.func_179112_b((int)770, (int)1);
            GlStateManager.func_179131_c((float)1.0f, (float)0.0f, (float)0.0f, (float)MathHelper.func_76126_a((float)((float)((double)(1.0f - (float)error.tick / (float)error.maxTick) * Math.PI * 2.0))));
            particle.getTex().bind();
            particle.draw((int)event.getPartialTicks(), 0.0f, 0.0f, 0.5f, 0.5f);
            GlStateManager.func_179112_b((int)blendSrc, (int)blendDst);
            GlStateManager.func_179092_a((int)alphaFunc, (float)alphaRef);
            GlStateManager.func_179126_j();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
    }

    private static class ParticleError {
        public final BlockPos pos;
        public int tick;
        public int maxTick;

        ParticleError(BlockPos pos, int maxTick) {
            this.pos = pos;
            this.tick = this.maxTick = maxTick;
        }
    }
}

