/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.item.pearlswapping;

import com.teamwizardry.librarianlib.features.helpers.NBTHelper;
import com.teamwizardry.wizardry.api.ConfigValues;
import com.teamwizardry.wizardry.init.ModItems;
import java.util.ArrayDeque;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public interface IPearlStorageHolder {
    @Nullable
    public IItemHandler getPearls(ItemStack var1);

    default public int getPearlCount(ItemStack holder) {
        IItemHandler handler = this.getPearls(holder);
        if (handler == null) {
            return 0;
        }
        int total = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack pearl = handler.getStackInSlot(i);
            if (pearl.func_190926_b()) continue;
            ++total;
        }
        return total;
    }

    default public ItemStack removePearl(ItemStack holder, int slot, boolean sort) {
        if (this.isDisabled(holder)) {
            return ItemStack.field_190927_a;
        }
        IItemHandler handler = this.getPearls(holder);
        if (handler == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack output = handler.extractItem(slot, 1, false);
        if (sort) {
            this.sortInv(handler);
        }
        return output;
    }

    default public void sortInv(IItemHandler handler) {
        int i;
        if (handler == null) {
            return;
        }
        ArrayDeque<ItemStack> stacks = new ArrayDeque<ItemStack>();
        int slots = handler.getSlots();
        for (i = 0; i < slots; ++i) {
            ItemStack stack = handler.extractItem(i, 1, false);
            if (stack.func_190926_b()) continue;
            stacks.add(stack);
        }
        for (i = 0; i < slots && !stacks.isEmpty(); ++i) {
            handler.insertItem(i, (ItemStack)stacks.pop(), false);
        }
    }

    default public boolean addPearl(ItemStack holder, ItemStack pearl, boolean sort) {
        if (this.isDisabled(holder)) {
            return false;
        }
        IItemHandler handler = this.getPearls(holder);
        if (handler == null) {
            return false;
        }
        if (this.getPearlCount(holder) > ConfigValues.pearlBeltInvSize) {
            return false;
        }
        ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)pearl, (boolean)false);
        if (sort) {
            this.sortInv(handler);
        }
        return true;
    }

    default public boolean succPearls(EntityPlayer player) {
        ItemStack belt = player.func_184614_ca();
        if (this.isDisabled(belt)) {
            return false;
        }
        boolean changed = false;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_77973_b() != ModItems.PEARL_NACRE || !NBTHelper.getBoolean((ItemStack)stack, (String)"infused", (boolean)false)) continue;
            if (this.getPearlCount(belt) >= ConfigValues.pearlBeltInvSize) break;
            if (!this.addPearl(belt, stack.func_77946_l(), true)) continue;
            stack.func_190918_g(1);
            changed = true;
        }
        return changed;
    }

    default public boolean isDisabled(ItemStack stack) {
        return false;
    }
}

