/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.item.halo;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpColorHSV;
import com.teamwizardry.wizardry.api.item.halo.HaloInfusionItem;
import com.teamwizardry.wizardry.api.item.halo.HaloInfusionItemRegistry;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.interp.InterpScale;
import java.awt.Color;
import java.util.HashMap;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class HaloInfusionItemRenderers {
    public static final HashMap<HaloInfusionItem, BiConsumer<Vec3d, World>> renders = new HashMap();
    public static HaloInfusionItemRenderers INSTANCE = new HaloInfusionItemRenderers();

    public static void addRender(HaloInfusionItem item, BiConsumer<Vec3d, World> renderHook) {
        renders.put(item, renderHook);
    }

    @Nonnull
    public static BiConsumer<Vec3d, World> getHaloRenderer(HaloInfusionItem item) {
        if (renders.containsKey(item)) {
            return renders.get(item);
        }
        return HaloInfusionItemRenderers.getHaloRenderer(HaloInfusionItemRegistry.EMPTY);
    }

    public static HashMap<HaloInfusionItem, BiConsumer<Vec3d, World>> getRenderers() {
        return renders;
    }

    static {
        HaloInfusionItemRenderers.addRender(HaloInfusionItemRegistry.EMPTY, (vec3d, world) -> {
            if (RandUtil.nextInt(5) != 0) {
                return;
            }
            ParticleBuilder glitter = new ParticleBuilder(20);
            glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
            glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.5f, 1.0f));
            glitter.setColor(new Color(16745216));
            ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp(vec3d), (int)1, (int)0, (aFloat, build) -> {
                build.setScale(2.0f);
                build.setLifetime(50);
            });
        });
        HaloInfusionItemRenderers.addRender(HaloInfusionItemRegistry.OVERWORLD_PRISMARINE_CRYSTALS, (vec3d, world) -> {
            if (RandUtil.nextInt(2) != 0) {
                return;
            }
            ParticleBuilder glitter = new ParticleBuilder(20);
            glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
            glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.5f, 1.0f));
            glitter.setColor(new Color(8959));
            glitter.setCollision(true);
            if (RandUtil.nextInt(2) == 0) {
                ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp(vec3d), (int)1, (int)0, (aFloat, build) -> {
                    build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(2.5f, 4.5f), 0.0f));
                    build.setLifetime(RandUtil.nextInt(10, 20));
                });
            }
            if (RandUtil.nextInt(4) != 0) {
                return;
            }
            ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp(vec3d), (int)1, (int)0, (aFloat, build) -> {
                build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(2.5f, 4.5f), 0.0f));
                build.addMotion(new Vec3d(RandUtil.nextDouble(-0.02, 0.02), RandUtil.nextDouble(-0.02, 0.05), RandUtil.nextDouble(-0.02, 0.02)));
                build.setAcceleration(new Vec3d(0.0, RandUtil.nextDouble(-0.015, -0.01), 0.0));
                build.setLifetime(RandUtil.nextInt(15, 25));
            });
        });
        HaloInfusionItemRenderers.addRender(HaloInfusionItemRegistry.OVERWORLD_EMERALD, (vec3d, world) -> {
            if (RandUtil.nextInt(3) != 0) {
                return;
            }
            ParticleBuilder glitter = new ParticleBuilder(20);
            glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
            glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.5f, 1.0f));
            glitter.setColor(new Color(1490688));
            ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp(vec3d), (int)1, (int)0, (aFloat, build) -> {
                build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(2.5f, 4.5f), 0.0f));
                build.addMotion(new Vec3d(RandUtil.nextDouble(-0.02, 0.02), RandUtil.nextDouble(-0.02, 0.02), RandUtil.nextDouble(-0.02, 0.02)));
                build.setLifetime(RandUtil.nextInt(10, 20));
            });
        });
        HaloInfusionItemRenderers.addRender(HaloInfusionItemRegistry.OVERWORLD_RABBIT_FOOT, (vec3d, world) -> {
            if (RandUtil.nextInt(2) != 0) {
                return;
            }
            ParticleBuilder glitter = new ParticleBuilder(20);
            glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
            glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.5f, 1.0f));
            glitter.setColor(new Color(6546087));
            if (RandUtil.nextInt(2) == 0) {
                ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp(vec3d), (int)1, (int)0, (aFloat, build) -> {
                    build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(2.5f, 4.5f), 0.0f));
                    build.setLifetime(RandUtil.nextInt(10, 20));
                });
            }
            if (RandUtil.nextInt(4) != 0) {
                return;
            }
            ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp(vec3d), (int)1, (int)0, (aFloat, build) -> {
                build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(1.5f, 4.5f), 0.0f));
                build.addMotion(new Vec3d(RandUtil.nextDouble(-0.015, 0.015), RandUtil.nextDouble(-0.015, 0.1), RandUtil.nextDouble(-0.015, 0.015)));
                build.setLifetime(RandUtil.nextInt(10, 20));
            });
        });
        HaloInfusionItemRenderers.addRender(HaloInfusionItemRegistry.NETHER_BLAZE_POWDERS, (vec3d, world) -> {
            if (RandUtil.nextInt(1) != 0) {
                return;
            }
            ParticleBuilder glitter = new ParticleBuilder(20);
            glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
            glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.5f, 1.0f));
            glitter.setColorFunction((InterpFunction)new InterpColorHSV(RandUtil.nextBoolean() ? Color.RED : Color.ORANGE, Color.GRAY));
            if (RandUtil.nextInt(2) == 0) {
                ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp(vec3d), (int)1, (int)0, (aFloat, build) -> {
                    build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(2.5f, 4.5f), 0.0f));
                    build.setLifetime(RandUtil.nextInt(10, 20));
                });
            }
            if (RandUtil.nextInt(2) != 0) {
                return;
            }
            ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp(vec3d), (int)1, (int)0, (aFloat, build) -> {
                build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(2.0f, 4.5f), 0.0f));
                build.addMotion(new Vec3d(RandUtil.nextDouble(-0.01, 0.01), RandUtil.nextDouble(-0.01, 0.07), RandUtil.nextDouble(-0.01, 0.01)));
                build.setLifetime(RandUtil.nextInt(10, 20));
            });
        });
        HaloInfusionItemRenderers.addRender(HaloInfusionItemRegistry.NETHER_GHAST_TEARS, (vec3d, world) -> {
            if (RandUtil.nextInt(2) != 0) {
                return;
            }
            ParticleBuilder glitter = new ParticleBuilder(20);
            glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
            glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.5f, 1.0f));
            glitter.setColor(new Color(16739829));
            if (RandUtil.nextInt(2) == 0) {
                ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp(vec3d), (int)1, (int)0, (aFloat, build) -> {
                    build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(2.5f, 4.5f), 0.0f));
                    build.setLifetime(RandUtil.nextInt(10, 20));
                });
            }
            if (RandUtil.nextInt(3) != 0) {
                return;
            }
            ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp(vec3d), (int)1, (int)0, (aFloat, build) -> {
                build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(0.5f, 1.5f), 0.0f));
                build.addMotion(new Vec3d(RandUtil.nextDouble(-0.05, 0.05), RandUtil.nextDouble(-0.05, 0.05), RandUtil.nextDouble(-0.05, 0.05)));
                build.setLifetime(RandUtil.nextInt(10, 20));
                build.setAcceleration(new Vec3d(0.0, 0.001, 0.0));
            });
        });
        HaloInfusionItemRenderers.addRender(HaloInfusionItemRegistry.NETHER_NETHER_STAR, (vec3d, world) -> {
            if (RandUtil.nextInt(2) != 0) {
                return;
            }
            ParticleBuilder glitter = new ParticleBuilder(20);
            glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
            glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.5f, 1.0f));
            glitter.setColor(new Color(14335999));
            if (RandUtil.nextInt(2) == 0) {
                ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp(vec3d), (int)1, (int)0, (aFloat, build) -> {
                    build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(2.5f, 4.5f), 0.0f));
                    build.setLifetime(RandUtil.nextInt(10, 20));
                });
            }
            if (RandUtil.nextInt(4) != 0) {
                return;
            }
            ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp(vec3d), (int)1, (int)0, (aFloat, build) -> {
                build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(0.5f, 1.5f), 0.0f));
                build.setPositionOffset(new Vec3d(RandUtil.nextDouble(-0.2, 0.2), RandUtil.nextDouble(-0.2, 0.2), RandUtil.nextDouble(-0.2, 0.2)));
                build.addMotion(new Vec3d(RandUtil.nextDouble(-0.01, 0.01), RandUtil.nextDouble(0.01, 0.05), RandUtil.nextDouble(-0.01, 0.01)));
                build.setLifetime(RandUtil.nextInt(10, 20));
            });
        });
        HaloInfusionItemRenderers.addRender(HaloInfusionItemRegistry.END_DRAGON_BREATH, (vec3d, world) -> {
            if (RandUtil.nextInt(2) != 0) {
                return;
            }
            ParticleBuilder glitter = new ParticleBuilder(20);
            glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
            glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.5f, 1.0f));
            glitter.setColor(new Color(11606207));
            if (RandUtil.nextInt(2) == 0) {
                ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp(vec3d), (int)1, (int)0, (aFloat, build) -> {
                    build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(2.5f, 4.5f), 0.0f));
                    build.setLifetime(RandUtil.nextInt(10, 20));
                });
            }
            if (world.func_82737_E() % 10L != 0L) {
                return;
            }
            ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp(vec3d), (int)10, (int)0, (aFloat, build) -> {
                build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(0.5f, 2.0f), 0.0f));
                build.addMotion(new Vec3d(RandUtil.nextDouble(-0.015, 0.015), RandUtil.nextDouble(-0.015, 0.015), RandUtil.nextDouble(-0.015, 0.015)));
                build.setLifetime(20);
            });
        });
        HaloInfusionItemRenderers.addRender(HaloInfusionItemRegistry.END_POPPED_CHORUS, (vec3d, world) -> {
            if (RandUtil.nextInt(2) != 0) {
                return;
            }
            ParticleBuilder glitter = new ParticleBuilder(20);
            glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
            glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.0f, 1.0f));
            glitter.setColor(new Color(5643660));
            if (RandUtil.nextInt(2) == 0) {
                ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp(vec3d), (int)1, (int)0, (aFloat, build) -> {
                    build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(2.5f, 4.5f), 0.0f));
                    build.setLifetime(RandUtil.nextInt(10, 20));
                });
            }
            if (RandUtil.nextInt(4) != 0) {
                return;
            }
            ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp(vec3d), (int)1, (int)0, (aFloat, build) -> {
                build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(4.0f, 4.5f), 0.0f));
                build.setPositionOffset(new Vec3d(RandUtil.nextDouble(-0.2, 0.2), RandUtil.nextDouble(-0.2, 0.2), RandUtil.nextDouble(-0.2, 0.2)));
                build.addMotion(new Vec3d(RandUtil.nextDouble(-0.01, 0.01), RandUtil.nextDouble(0.01, 0.05), RandUtil.nextDouble(-0.01, 0.01)));
                build.setLifetime(RandUtil.nextInt(10, 20));
            });
        });
        HaloInfusionItemRenderers.addRender(HaloInfusionItemRegistry.END_SHULKER_SHELL, (vec3d, world) -> {
            if (RandUtil.nextInt(2) != 0) {
                return;
            }
            ParticleBuilder glitter = new ParticleBuilder(20);
            glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
            glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.5f, 1.0f));
            glitter.setColor(new Color(8519935));
            if (RandUtil.nextInt(2) == 0) {
                ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp(vec3d), (int)1, (int)0, (aFloat, build) -> {
                    build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(2.5f, 3.0f), 0.0f));
                    build.setLifetime(RandUtil.nextInt(10, 20));
                });
            }
            if (RandUtil.nextInt(4) != 0) {
                return;
            }
            ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp(vec3d), (int)1, (int)0, (aFloat, build) -> {
                build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(4.0f, 3.0f), 0.0f));
                build.setPositionOffset(new Vec3d(RandUtil.nextDouble(-0.02, 0.02), RandUtil.nextDouble(-0.02, 0.02), RandUtil.nextDouble(-0.02, 0.02)));
                build.setLifetime(RandUtil.nextInt(10, 20));
                build.setAcceleration(new Vec3d(0.0, 0.015, 0.0));
            });
        });
        HaloInfusionItemRenderers.addRender(HaloInfusionItemRegistry.UNDEROWRLD_UNICORN_HORN, (vec3d, world) -> {
            if (RandUtil.nextInt(2) != 0) {
                return;
            }
            ParticleBuilder glitter = new ParticleBuilder(5);
            glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
            glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.5f, 1.0f));
            glitter.setColor(new Color(0xFF4C4C));
            glitter.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(3.0f, 3.5f), 0.0f));
            ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp(vec3d), (int)1, (int)0, (aFloat, build) -> {
                build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(1.5f, 3.5f), 0.0f));
                build.setLifetime(RandUtil.nextInt(10, 20));
            });
            if (RandUtil.nextInt(4) == 0) {
                ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp(vec3d), (int)1, (int)0, (aFloat, build) -> build.setAcceleration(new Vec3d(0.0, 0.01, 0.0)));
            }
            if (RandUtil.nextInt(4) == 0) {
                ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp(vec3d), (int)1, (int)0, (aFloat, build) -> build.setAcceleration(new Vec3d(0.01, 0.0, 0.0)));
            }
            if (RandUtil.nextInt(4) == 0) {
                ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp(vec3d), (int)1, (int)0, (aFloat, build) -> build.setAcceleration(new Vec3d(0.0, 0.0, 0.01)));
            }
            if (RandUtil.nextInt(4) == 0) {
                ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp(vec3d), (int)1, (int)0, (aFloat, build) -> build.setAcceleration(new Vec3d(0.0, -0.01, 0.0)));
            }
            if (RandUtil.nextInt(4) == 0) {
                ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp(vec3d), (int)1, (int)0, (aFloat, build) -> build.setAcceleration(new Vec3d(-0.01, 0.0, 0.0)));
            }
            if (RandUtil.nextInt(4) == 0) {
                ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp(vec3d), (int)1, (int)0, (aFloat, build) -> build.setAcceleration(new Vec3d(0.0, 0.0, -0.01)));
            }
        });
        HaloInfusionItemRenderers.addRender(HaloInfusionItemRegistry.UNDERWORLD_FAIRY_DUST, (vec3d, world) -> {
            ParticleBuilder glitter = new ParticleBuilder(20);
            glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
            glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.5f, 1.0f));
            glitter.setColor(new Color(0xFFFFFF));
            if (RandUtil.nextInt(2) == 0) {
                ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp(vec3d), (int)1, (int)0, (aFloat, build) -> {
                    Color color = RandUtil.nextBoolean() ? Color.GREEN : (RandUtil.nextBoolean() ? Color.BLUE : Color.RED);
                    build.setColor(color.brighter());
                    build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(1.5f, 3.5f), 0.0f));
                    build.setLifetime(RandUtil.nextInt(10, 20));
                });
            }
        });
    }
}

