/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.item;

import com.teamwizardry.librarianlib.features.helpers.NBTHelper;
import com.teamwizardry.librarianlib.features.network.PacketHandler;
import com.teamwizardry.wizardry.api.spell.IOverrideCooldown;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.SpellUtils;
import com.teamwizardry.wizardry.common.network.PacketSyncCooldown;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public interface ICooldownSpellCaster {
    default public void setCooldown(World world, @Nullable EntityPlayer player, @Nullable EnumHand hand, ItemStack stack, @Nonnull SpellData data) {
        int maxCooldown = 0;
        List<SpellRing> rings = SpellUtils.getAllSpellRings(stack);
        for (SpellRing ring : rings) {
            if (ring.isContinuous()) {
                return;
            }
            if (ring.getModule() != null && ring.getModule().getModuleClass() instanceof IOverrideCooldown) {
                maxCooldown = ring.getCooldownTime(world, data);
                break;
            }
            if (ring.getCooldownTime() <= maxCooldown) continue;
            maxCooldown = ring.getCooldownTime();
        }
        if (maxCooldown <= 0) {
            return;
        }
        if (player != null && hand != null) {
            player.func_184597_cx();
            player.func_184609_a(hand);
            if (!world.field_72995_K) {
                if (hand == EnumHand.MAIN_HAND) {
                    PacketHandler.NETWORK.sendTo((IMessage)new PacketSyncCooldown(true, false), (EntityPlayerMP)player);
                } else {
                    PacketHandler.NETWORK.sendTo((IMessage)new PacketSyncCooldown(false, true), (EntityPlayerMP)player);
                }
            }
        }
        NBTHelper.setInt((ItemStack)stack, (String)"last_cooldown", (int)maxCooldown);
        NBTHelper.setLong((ItemStack)stack, (String)"last_cast", (long)world.func_82737_E());
    }

    default public boolean isCoolingDown(World world, ItemStack stack) {
        int lastCooldown = NBTHelper.getInt((ItemStack)stack, (String)"last_cooldown", (int)0);
        long lastCast = NBTHelper.getLong((ItemStack)stack, (String)"last_cast", (long)0L);
        long currentCast = world.func_82737_E();
        long sub = currentCast - lastCast;
        return sub <= (long)lastCooldown;
    }
}

