/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.entity.fairy.fairytasks;

import com.teamwizardry.wizardry.api.entity.fairy.fairytasks.FairyTask;
import com.teamwizardry.wizardry.api.entity.fairy.fairytasks.FairyTaskIdle;
import com.teamwizardry.wizardry.common.entity.EntityFairy;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public final class FairyTaskRegistry {
    public static final ResourceLocation IDLE_TASK = new ResourceLocation("wizardry", "idle");
    private static final HashMap<ResourceLocation, Entry<FairyTask>> factories = new HashMap();

    private FairyTaskRegistry() {
    }

    public static void addTask(ResourceLocation resourceLocation, BiPredicate<ItemStack, EntityFairy> acceptTask, Supplier<FairyTask> factory) {
        factories.put(resourceLocation, new Entry<FairyTask>(acceptTask, factory));
    }

    @Nonnull
    public static FairyTask createTaskFromResource(@Nonnull ResourceLocation resourceLocation) {
        Entry<FairyTask> entry = factories.get(resourceLocation);
        if (entry == null) {
            return (FairyTask)((Entry)factories.get(IDLE_TASK)).factory.get();
        }
        return (FairyTask)((Entry)entry).factory.get();
    }

    @Nonnull
    public static ResourceLocation getAcceptableTask(ItemStack stack, EntityFairy fairy) {
        for (Map.Entry<ResourceLocation, Entry<FairyTask>> entry : factories.entrySet()) {
            if (!((Entry)entry.getValue()).acceptTask.test(stack, fairy)) continue;
            return entry.getKey();
        }
        return IDLE_TASK;
    }

    static {
        factories.put(IDLE_TASK, new Entry<FairyTask>((stack, fairy) -> false, FairyTaskIdle::new));
    }

    private static final class Entry<T extends FairyTask> {
        private final BiPredicate<ItemStack, EntityFairy> acceptTask;
        private final Supplier<T> factory;

        Entry(BiPredicate<ItemStack, EntityFairy> acceptTask, Supplier<T> factory) {
            this.acceptTask = acceptTask;
            this.factory = factory;
        }
    }
}

