/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.capability.world;

import com.teamwizardry.wizardry.api.capability.world.WizardryWorld;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public class WizardryWorldStorage
implements Capability.IStorage<WizardryWorld> {
    public static final WizardryWorldStorage INSTANCE = new WizardryWorldStorage();
    public static final String BACKUP_NBT_TAG = "zombieBackup";

    @Nullable
    public NBTBase writeNBT(Capability<WizardryWorld> capability, WizardryWorld instance, EnumFacing side) {
        NBTTagCompound playerMap = new NBTTagCompound();
        for (UUID playerId : instance.getBackupMap().keySet()) {
            playerMap.func_74768_a(playerId.toString(), instance.getBackupMap().get(playerId).intValue());
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a(BACKUP_NBT_TAG, (NBTBase)playerMap);
        return nbt;
    }

    public void readNBT(Capability<WizardryWorld> capability, WizardryWorld instance, EnumFacing side, NBTBase nbt) {
        HashMap<UUID, Integer> map = new HashMap<UUID, Integer>();
        NBTTagCompound tag = (NBTTagCompound)nbt;
        NBTTagCompound playerBackup = tag.func_74775_l(BACKUP_NBT_TAG);
        for (String playerId : playerBackup.func_150296_c()) {
            map.put(UUID.fromString(playerId), playerBackup.func_74762_e(playerId));
        }
        instance.setBackupMap(map);
    }
}

