/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.capability.chunk;

import com.teamwizardry.wizardry.api.capability.chunk.StandardWizardryChunk;
import com.teamwizardry.wizardry.api.capability.chunk.WizardryChunk;
import java.util.Objects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="wizardry")
public final class WizardryChunkCapability {
    private static final ResourceLocation WIZARDRY_CHUNK_ID = new ResourceLocation("wizardry", "wizardry_chunk");
    @CapabilityInject(value=WizardryChunk.class)
    private static final Capability<WizardryChunk> CAPABILITY = null;

    private WizardryChunkCapability() {
    }

    public static Capability<WizardryChunk> capability() {
        return Objects.requireNonNull(CAPABILITY, "MANA_CAPABILITY");
    }

    public static void init() {
        CapabilityManager.INSTANCE.register(WizardryChunk.class, (Capability.IStorage)new WizardryChunkStorage(), StandardWizardryChunk::create);
    }

    public static WizardryChunk get(Chunk chunk) {
        WizardryChunk cap = (WizardryChunk)chunk.getCapability(WizardryChunkCapability.capability(), null);
        if (cap == null) {
            throw new IllegalStateException("Missing capability: " + chunk.func_177412_p().func_72912_H().func_76065_j() + "/" + chunk.func_177412_p().field_73011_w.func_186058_p().func_186065_b() + "/(" + chunk.field_76635_g + "," + chunk.field_76647_h + ")");
        }
        return cap;
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Chunk> event) {
        event.addCapability(WIZARDRY_CHUNK_ID, (ICapabilityProvider)StandardWizardryChunk.create());
    }

    private static final class WizardryChunkStorage
    implements Capability.IStorage<WizardryChunk> {
        private WizardryChunkStorage() {
        }

        public NBTBase writeNBT(Capability<WizardryChunk> capability, WizardryChunk chunk, EnumFacing side) {
            return chunk.serializeNBT();
        }

        public void readNBT(Capability<WizardryChunk> capability, WizardryChunk chunk, EnumFacing side, NBTBase nbt) {
            if (nbt instanceof NBTTagCompound) {
                chunk.deserializeNBT((NBTBase)((NBTTagCompound)nbt));
            }
        }
    }
}

